/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

public class ASDFEncoder {
    private static final char[] posSQZ = new char[]{'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
    private static final char[] negSQZ = new char[]{'@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i'};
    private static final char[] posDIF = new char[]{'%', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R'};
    private static final char[] negDIF = new char[]{'%', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r'};
    private static final char[] posDUP = new char[]{' ', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 's'};
    private static final int MODE_SQZ = 0;
    private static final int MODE_DIF = 1;
    private static final int MAX_CHARS_PER_LINE = 60;

    private ASDFEncoder() {
    }

    public static String encode(double firstx, double lastx, int[] data) {
        boolean mode = false;
        StringBuffer line = new StringBuffer();
        StringBuffer difdup = new StringBuffer();
        int n = data.length;
        int dup = 1;
        int odif = 0;
        boolean checkDUP = false;
        double deltax = (lastx - firstx) / (double)(n - 1);
        line.append(firstx);
        line.append(ASDFEncoder.toSQZ(data[0]));
        for (int i = 1; i < n; ++i) {
            char[] sqzChars;
            int dif;
            char[] difChars;
            if (line.length() > 60) {
                difdup.append(line).append("\r\n");
                line.setLength(0);
                if (mode) {
                    line.append(deltax * (double)(i - 1) + firstx);
                    line.append(ASDFEncoder.toSQZ(data[i - 1]));
                    mode = false;
                    dup = 1;
                    checkDUP = false;
                } else {
                    line.append(deltax * (double)i + firstx);
                    line.append(ASDFEncoder.toSQZ(data[i]));
                    mode = false;
                    dup = 1;
                    checkDUP = false;
                    continue;
                }
            }
            if ((difChars = ASDFEncoder.toDIF(dif = data[i] - data[i - 1])).length > (sqzChars = ASDFEncoder.toSQZ(data[i])).length) {
                if (dup > 1) {
                    line.append(ASDFEncoder.toDUP(dup));
                    dup = 1;
                }
                line.append(sqzChars);
                checkDUP = false;
                mode = false;
                continue;
            }
            if (checkDUP && dif == odif) {
                ++dup;
            } else {
                if (dup > 1) {
                    line.append(ASDFEncoder.toDUP(dup));
                    dup = 1;
                }
                line.append(difChars);
                odif = dif;
            }
            checkDUP = true;
            mode = true;
        }
        if (dup > 1) {
            line.append(ASDFEncoder.toDUP(dup));
        }
        difdup.append(line).append("\r\n");
        if (mode) {
            difdup.append(deltax * (double)(n - 1) + firstx);
            difdup.append(ASDFEncoder.toSQZ(data[n - 1]));
            difdup.append("\r\n");
        }
        return difdup.toString();
    }

    private static char[] toDIF(int value) {
        if (value > 0) {
            char[] dif = Integer.toString(value).toCharArray();
            char first = dif[0];
            dif[0] = posDIF[first - 48];
            return dif;
        }
        if (value < 0) {
            char[] dif = Integer.toString(-value).toCharArray();
            char first = dif[0];
            dif[0] = negDIF[first - 48];
            return dif;
        }
        return new char[]{'%'};
    }

    private static char[] toDUP(int value) {
        char[] dup = Integer.toString(value).toCharArray();
        char first = dup[0];
        dup[0] = posDUP[first - 48];
        return dup;
    }

    private static char[] toSQZ(int value) {
        if (value > 0) {
            char[] sqz = Integer.toString(value).toCharArray();
            char first = sqz[0];
            sqz[0] = posSQZ[first - 48];
            return sqz;
        }
        if (value < 0) {
            char[] sqz = Integer.toString(-value).toCharArray();
            char first = sqz[0];
            sqz[0] = negSQZ[first - 48];
            return sqz;
        }
        return new char[]{'@'};
    }
}

