/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ASDFCheckHandler;
import org.jcamp.parser.ASDFLexer;
import org.jcamp.parser.ASDFParseState;
import org.jcamp.parser.ASDFParserTokenTypes;
import org.jcamp.parser.JCAMPException;

public class ASDFParser
extends LLkParser
implements ASDFParserTokenTypes {
    private static Log log = LogFactory.getLog((Class)(class$org$jcamp$parser$ASDFParser == null ? (class$org$jcamp$parser$ASDFParser = ASDFParser.class$("org.jcamp.parser.ASDFParser")) : class$org$jcamp$parser$ASDFParser));
    protected static final ASDFCheckHandler IGNORE_HANDLER = new ASDFCheckHandler(){

        public int check(ASDFParseState state) {
            return 2;
        }
    };
    protected boolean currentInDIF = false;
    protected boolean lastInDIF = false;
    protected Vector yValues = new Vector();
    protected ASDFParseState state = null;
    protected ASDFCheckHandler checkHandler = IGNORE_HANDLER;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "DIGIT", "SIGN", "EOL", "XCHECK", "PAC", "POSSQZ", "NEGSQZ", "POSDIF", "NEGDIF", "DUP", "WS", "ERROR", "SL_COMMENT"};
    private static final long[] _tokenSet_0_data_ = new long[]{50944L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
    static /* synthetic */ Class class$org$jcamp$parser$ASDFParser;

    public ASDFParser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public ASDFParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected ASDFParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public ASDFParser(TokenStream lexer) {
        this(lexer, 1);
    }

    protected ASDFParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    protected final void block(int expectedSize) throws RecognitionException, TokenStreamException, JCAMPException {
        LineContent lineContent = null;
        this.state = new ASDFParseState();
        this.yValues.setSize(0);
        this.yValues.ensureCapacity(expectedSize);
        this.lastInDIF = false;
        this.currentInDIF = false;
        int _cnt38 = 0;
        while (true) {
            if (this.LA(1) == 7 || this.LA(1) == 14) {
                int indexBeforeCheck;
                lineContent = this.line();
                this.state.setCheckX(lineContent.xCheck);
                if (this.lastInDIF) {
                    indexBeforeCheck = this.state.getCurrentIndex();
                    this.state.setCheckY((Integer)lineContent.yVector.elementAt(0));
                    this.state.setCurrentY((Integer)this.yValues.lastElement());
                } else {
                    Integer y0 = (Integer)lineContent.yVector.elementAt(0);
                    this.yValues.addElement(y0);
                    this.state.incrCurrentIndex();
                    indexBeforeCheck = this.state.getCurrentIndex();
                    this.state.setCheckY(y0);
                    this.state.setCurrentY(y0);
                }
                switch (this.checkHandler.check(this.state)) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.error("ASDF parsing aborted, failed check in line " + Integer.toString(this.state.getCurrentLineNumber()));
                    }
                    case 1: {
                        int indexAfterCheck = this.state.getCurrentIndex();
                        if (indexBeforeCheck < indexAfterCheck) {
                            Integer errorValue = (Integer)this.yValues.lastElement();
                            for (int i = indexBeforeCheck; i < indexAfterCheck; ++i) {
                                this.yValues.addElement(errorValue);
                            }
                            break;
                        }
                        if (indexBeforeCheck > indexAfterCheck) {
                            this.yValues.setSize(indexAfterCheck + 1);
                            this.yValues.setElementAt(new Integer(this.state.getCurrentY()), indexAfterCheck);
                            break;
                        }
                        this.yValues.setElementAt(new Integer(this.state.getCurrentY()), indexAfterCheck);
                        break;
                    }
                }
                for (int i = 1; i < lineContent.yVector.size(); ++i) {
                    this.yValues.addElement(lineContent.yVector.elementAt(i));
                    this.state.incrCurrentIndex();
                }
            } else {
                if (_cnt38 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.state.incrCurrentLineNumber();
            this.lastInDIF = this.currentInDIF;
            ++_cnt38;
        }
    }

    protected final int difNumber() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token n = null;
        int v = 0;
        switch (this.LA(1)) {
            case 11: {
                p = this.LT(1);
                this.match(11);
                v = this.parsePOSDIF(p);
                break;
            }
            case 12: {
                n = this.LT(1);
                this.match(12);
                v = this.parseNEGDIF(n);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return v;
    }

    protected final Vector difNumbers() throws RecognitionException, TokenStreamException {
        int s = 0;
        int d = 0;
        int u = 0;
        Vector<Integer> v = new Vector<Integer>(80);
        switch (this.LA(1)) {
            case 9: 
            case 10: {
                s = this.sqzNumber();
                v.addElement(new Integer(s));
                this.currentInDIF = false;
                break;
            }
            case 15: {
                this.match(15);
                if (this.yValues.size() > 0) {
                    v.addElement((Integer)this.yValues.lastElement());
                } else {
                    v.addElement(new Integer(0));
                }
                this.currentInDIF = false;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block10: while (true) {
            switch (this.LA(1)) {
                case 9: 
                case 10: {
                    s = this.sqzNumber();
                    this.currentInDIF = false;
                    v.addElement(new Integer(s));
                    continue block10;
                }
                case 11: 
                case 12: {
                    d = this.difNumber();
                    this.currentInDIF = true;
                    int l = (Integer)v.lastElement();
                    v.addElement(new Integer(l + d));
                    continue block10;
                }
                case 13: {
                    int l;
                    u = this.dupNumber();
                    if (this.currentInDIF) {
                        l = v.size();
                        int l0 = (Integer)v.elementAt(l - 1);
                        int l1 = (Integer)v.elementAt(l - 2);
                        int dif = l0 - l1;
                        int i = 1;
                        while (true) {
                            if (i >= u) continue block10;
                            v.addElement(new Integer(l0 += dif));
                            ++i;
                        }
                    }
                    l = (Integer)v.lastElement();
                    int i = 1;
                    while (true) {
                        if (i >= u) continue block10;
                        v.addElement(new Integer(l));
                        ++i;
                    }
                }
                case 15: {
                    this.match(15);
                    v.addElement((Integer)v.lastElement());
                    continue block10;
                }
            }
            break;
        }
        return v;
    }

    protected final int dupNumber() throws RecognitionException, TokenStreamException {
        Token d = null;
        int v = 0;
        d = this.LT(1);
        this.match(13);
        v = this.parseDUP(d);
        return v;
    }

    protected void error(String msg) throws JCAMPException {
        log.error((Object)msg);
        throw new JCAMPException(msg);
    }

    public int[] getYData() {
        int n = this.yValues.size();
        int[] y = new int[n];
        for (int i = 0; i < n; ++i) {
            y[i] = (Integer)this.yValues.elementAt(i);
        }
        return y;
    }

    protected final LineContent line() throws RecognitionException, TokenStreamException, JCAMPException {
        double x;
        LineContent lineContent = new LineContent();
        switch (this.LA(1)) {
            case 14: {
                this.match(14);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        lineContent.xCheck = x = this.xcheck();
        if (this.LA(1) == 14) {
            this.match(14);
        } else if (!_tokenSet_0.member(this.LA(1))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        switch (this.LA(1)) {
            case 9: 
            case 10: 
            case 15: {
                Vector y = this.difNumbers();
                this.match(6);
                if (y == null) {
                    this.error("ASDF parsing failed in line " + Integer.toString(this.state.getCurrentLineNumber()));
                }
                lineContent.yVector = y;
                break;
            }
            case 8: 
            case 14: {
                Vector y = this.pacNumbers();
                this.match(6);
                if (y == null) {
                    this.error("ASDF parsing failed in line " + Integer.toString(this.state.getCurrentLineNumber()));
                }
                lineContent.yVector = y;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return lineContent;
    }

    public static void main(String[] args) {
        ASDFLexer lexer = new ASDFLexer(System.in);
        ASDFParser parser = new ASDFParser(lexer);
        try {
            parser.parse();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        int[] y = parser.getYData();
        for (int i = 0; i < y.length; ++i) {
            System.out.println(i + "\t" + y[i]);
        }
    }

    protected final int pacNumber() throws RecognitionException, TokenStreamException {
        Token p = null;
        int v = 0;
        switch (this.LA(1)) {
            case 14: {
                this.match(14);
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        p = this.LT(1);
        this.match(8);
        v = this.parsePAC(p);
        return v;
    }

    protected final Vector pacNumbers() throws RecognitionException, TokenStreamException {
        int p = 0;
        Vector<Integer> v = new Vector<Integer>(80);
        int _cnt28 = 0;
        while (true) {
            if (this.LA(1) == 8 || this.LA(1) == 14) {
                p = this.pacNumber();
                v.addElement(new Integer(p));
                if (this.LA(1) == 14) {
                    this.match(14);
                } else if (this.LA(1) != 6 && this.LA(1) != 8 && this.LA(1) != 14) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else {
                if (_cnt28 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt28;
        }
        return v;
    }

    public void parse() throws JCAMPException {
        this.parse(32000);
    }

    public void parse(int expectedSize) throws JCAMPException {
        try {
            this.block(expectedSize);
        }
        catch (RecognitionException e) {
            log.error((Object)"parsing failed");
            throw new JCAMPException("parsing failed\n" + e.getMessage());
        }
        catch (TokenStreamException e) {
            log.error((Object)"parsing failed");
            throw new JCAMPException("parsing failed\n" + e.getMessage());
        }
    }

    protected int parseDUP(Token d) {
        int v = 0;
        char[] c = d.getText().toCharArray();
        v = c[0] == 's' ? 9 : c[0] - 83 + 1;
        for (int i = 1; i < c.length; ++i) {
            v *= 10;
            v += c[i] - 48;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("DUP-Number: " + Integer.toString(v)));
        }
        return v;
    }

    protected int parseNEGDIF(Token n) {
        int v = 0;
        char[] c = n.getText().toCharArray();
        v = c[0] - 106 + 1;
        for (int i = 1; i < c.length; ++i) {
            v *= 10;
            v += c[i] - 48;
        }
        v = -v;
        if (log.isDebugEnabled()) {
            log.debug((Object)("DIF-Number: " + Integer.toString(v)));
        }
        return v;
    }

    protected int parseNEGSQZ(Token n) {
        int v = 0;
        char[] c = n.getText().toCharArray();
        v = c[0] - 97 + 1;
        for (int i = 1; i < c.length; ++i) {
            v *= 10;
            v += c[i] - 48;
        }
        v = -v;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQZ-Number: " + Integer.toString(v)));
        }
        return v;
    }

    protected int parsePAC(Token p) {
        int v = 0;
        int i = 0;
        boolean negative = false;
        char[] c = p.getText().toCharArray();
        if (c[0] == '-') {
            ++i;
            negative = true;
        } else if (c[0] == '+') {
            ++i;
        }
        v = c[i] - 48;
        ++i;
        while (i < c.length) {
            v *= 10;
            v += c[i] - 48;
            ++i;
        }
        if (negative) {
            v = -v;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PAC-Number: " + Integer.toString(v)));
        }
        return v;
    }

    protected int parsePOSDIF(Token p) {
        int v = 0;
        char[] c = p.getText().toCharArray();
        v = c[0] == '%' ? 0 : c[0] - 74 + 1;
        for (int i = 1; i < c.length; ++i) {
            v *= 10;
            v += c[i] - 48;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("DIF-Number: " + Integer.toString(v)));
        }
        return v;
    }

    protected int parsePOSSQZ(Token p) {
        int v = 0;
        char[] c = p.getText().toCharArray();
        v = c[0] == '@' ? 0 : c[0] - 65 + 1;
        for (int i = 1; i < c.length; ++i) {
            v *= 10;
            v += c[i] - 48;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQZ-Number: " + Integer.toString(v)));
        }
        return v;
    }

    public void setCheckHandler(ASDFCheckHandler handler) {
        this.checkHandler = handler == null ? IGNORE_HANDLER : handler;
    }

    protected final int sqzNumber() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token n = null;
        int v = 0;
        switch (this.LA(1)) {
            case 9: {
                p = this.LT(1);
                this.match(9);
                v = this.parsePOSSQZ(p);
                break;
            }
            case 10: {
                n = this.LT(1);
                this.match(10);
                v = this.parseNEGSQZ(n);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return v;
    }

    protected final double xcheck() throws RecognitionException, TokenStreamException {
        Token x = null;
        double d = 0.0;
        x = this.LT(1);
        this.match(7);
        d = Double.valueOf(x.getText());
        if (log.isDebugEnabled()) {
            log.debug((Object)("X-Check: " + Double.toString(d)));
        }
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LineContent {
        public double xCheck;
        public Vector yVector = null;

        private LineContent() {
        }
    }
}

