/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.Chromatogram;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class ChromatogramJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    private static final String CRLF = "\r\n";
    private static Log log = LogFactory.getLog((Class)(class$org$jcamp$parser$ChromatogramJCAMPReader == null ? (class$org$jcamp$parser$ChromatogramJCAMPReader = ChromatogramJCAMPReader.class$("org.jcamp.parser.ChromatogramJCAMPReader")) : class$org$jcamp$parser$ChromatogramJCAMPReader));
    static /* synthetic */ Class class$org$jcamp$parser$ChromatogramJCAMPReader;

    protected ChromatogramJCAMPReader() {
    }

    private Chromatogram createFS(JCAMPBlock block) throws JCAMPException {
        int nPoints;
        double lastX;
        Unit yUnit;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.second;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        double firstX = this.getFirstX(block);
        double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints = this.getNPoints(block), xFactor, yFactor);
        if (intensities.length != nPoints) {
            block.getErrorHandler().error("incorrect ##NPOINTS=: expected " + Integer.toString(nPoints) + " but got " + Integer.toString(intensities.length));
            nPoints = intensities.length;
        }
        EquidistantData x = new EquidistantData(firstX, lastX, nPoints, xUnit);
        ArrayData y = new ArrayData(intensities, yUnit);
        Chromatogram spectrum = new Chromatogram(x, y, true);
        return spectrum;
    }

    private Chromatogram createPeakTable(JCAMPBlock block) throws JCAMPException {
        Unit yUnit;
        Chromatogram spectrum = null;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.second;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        Object[] tables = this.getPeaktable(block, nPoints, xFactor, yFactor);
        Peak1D[] peaks = (Peak1D[])tables[0];
        if (peaks.length != nPoints) {
            block.getErrorHandler().error("incorrect ##NPOINTS=: expected " + Integer.toString(nPoints) + " but got " + Integer.toString(peaks.length));
            nPoints = peaks.length;
        }
        double[][] xy = ChromatogramJCAMPReader.peakTableToPeakSpectrum(peaks);
        OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
        ArrayData y = new ArrayData(xy[1], yUnit);
        spectrum = new Chromatogram(x, y, false);
        spectrum.setPeakTable(peaks);
        if (tables.length > 1) {
            spectrum.setPatternTable((Pattern[])tables[1]);
            if (tables.length > 2) {
                spectrum.setAssignments((Assignment[])tables[2]);
            }
        }
        return spectrum;
    }

    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 131072) {
            block.getErrorHandler().fatal("JCAMP reader adapter missmatch");
        }
        boolean isFID = false;
        Chromatogram spectrum = null;
        JCAMPDataRecord ldrDataType = block.getDataRecord("DATATYPE");
        String dataType = ldrDataType.getContent().toUpperCase();
        JCAMPBlock.Type type = block.getType();
        if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
            spectrum = this.createFS(block);
        } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
            spectrum = this.createPeakTable(block);
        } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
            spectrum = this.createPeakTable(block);
        } else {
            block.getErrorHandler().fatal("illegal block type");
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

