/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.DataType;
import org.jcamp.parser.JCAMPException;
import org.jcamp.spectrum.Multiplicity;

public class DataGroup {
    private final DataType type;
    private final String[] varSymbols;
    private Object[] values;

    public DataGroup(String[] symbols) {
        this.type = null;
        this.varSymbols = symbols;
        this.values = new Object[symbols.length];
    }

    public DataGroup(String[] symbols, Object[] values) {
        this.type = null;
        this.varSymbols = symbols;
        this.values = new Object[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public DataGroup(double x, double y) {
        this.type = DataType.XY;
        this.varSymbols = DataType.XY.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y)};
    }

    public DataGroup(double x, double y, char m) {
        this.type = DataType.XYM;
        this.varSymbols = DataType.XYM.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), Multiplicity.multiplicityOf(m)};
    }

    public DataGroup(double x, double y, char m, double w, String a) {
        this.type = DataType.XYMWA;
        this.varSymbols = DataType.XYMWA.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), Multiplicity.multiplicityOf(m), new Double(w), a};
    }

    public DataGroup(double x, double y, char m, String a) {
        this.type = DataType.XYMA;
        this.varSymbols = DataType.XYMA.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), Multiplicity.multiplicityOf(m), a};
    }

    public DataGroup(double x, double y, double w) {
        this.type = DataType.XYW;
        this.varSymbols = DataType.XYW.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), new Double(w)};
    }

    public DataGroup(double x, double y, double w, String a) {
        this.type = DataType.XYWA;
        this.varSymbols = DataType.XYWA.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), new Double(w), a};
    }

    public DataGroup(double x, double y, String a) {
        this.type = DataType.XYA;
        this.varSymbols = DataType.XYA.getSymbols();
        this.values = new Object[]{new Double(x), new Double(y), a};
    }

    public DataGroup(DataType type, Object[] values) {
        this.type = null;
        this.varSymbols = type.getSymbols();
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public DataGroup(Double x, Double y) {
        this.type = DataType.XY;
        this.varSymbols = DataType.XY.getSymbols();
        this.values = new Object[]{x, y};
    }

    public DataGroup(Double x, Double y, Multiplicity m) {
        this.type = DataType.XYM;
        this.varSymbols = DataType.XYM.getSymbols();
        this.values = new Object[]{x, y, m};
    }

    public DataGroup(Double x, Double y, Multiplicity m, Double w, String a) {
        this.type = DataType.XYMWA;
        this.varSymbols = DataType.XYMWA.getSymbols();
        this.values = new Object[]{x, y, m, w, a};
    }

    public DataGroup(Double x, Double y, Multiplicity m, String a) {
        this.type = DataType.XYMA;
        this.varSymbols = DataType.XYMA.getSymbols();
        this.values = new Object[]{x, y, m, a};
    }

    public DataGroup(Double x, Double y, Double w) {
        this.type = DataType.XYW;
        this.varSymbols = DataType.XYW.getSymbols();
        this.values = new Object[]{x, y, w};
    }

    public DataGroup(Double x, Double y, Double w, String a) {
        this.type = DataType.XYWA;
        this.varSymbols = DataType.XYWA.getSymbols();
        this.values = new Object[]{x, y, w, a};
    }

    public DataGroup(Double x, Double y, String a) {
        this.type = DataType.XYA;
        this.varSymbols = DataType.XYA.getSymbols();
        this.values = new Object[]{x, y, a};
    }

    public final DataType getType() {
        return this.type;
    }

    public Object getValue(int index) {
        return this.values[index];
    }

    public Object getValue(String c) throws JCAMPException {
        return this.values[this.indexOfSymbol(c)];
    }

    public int indexOfSymbol(String symbol) throws JCAMPException {
        for (int i = 0; i < this.varSymbols.length; ++i) {
            if (!symbol.equalsIgnoreCase(this.varSymbols[i])) continue;
            return i;
        }
        throw new JCAMPException("unknown data variable: " + symbol);
    }

    public void setValue(int index, Object value) {
        this.values[index] = value;
    }

    public void setValue(String symbol, Object value) throws JCAMPException {
        this.values[this.indexOfSymbol((String)symbol)] = value;
    }
}

