/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;

public class DataVariableInfo {
    private static final String INCR_RE = "[:space:]*\\(([:alpha:][:digit:]*)\\+\\+\\(([:alpha:][:digit:]*)\\.\\.\\2\\)\\)[:space:]*";
    private static final String LIST_RE = "[:space:]*\\((([:alpha:][:digit:]*){2,})(\\.\\.\\1)?\\)[:space:]*";
    private static final String VAR_RE = "[:alpha:][:digit:]*";
    private static final REProgram INCR_REPRG;
    private static final REProgram LIST_REPRG;
    private static final REProgram VAR_REPRG;
    private RE incrRE = new RE(INCR_REPRG);
    private RE listRE = new RE(LIST_REPRG);
    private RE varRE = new RE(VAR_REPRG);
    private String[] symbols;
    private boolean incremental;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataVariableInfo(JCAMPDataRecord xyDataLDR) throws JCAMPException {
        String varType;
        String key = xyDataLDR.getKey();
        if (!xyDataLDR.isData()) throw new JCAMPException("not a data LDR: \"##" + key + "\"");
        String xyData = xyDataLDR.getContent();
        int lf = xyData.indexOf("\r\n");
        if (lf < 0) {
            lf = xyData.indexOf("\n");
            if (lf < 0 && (lf = xyData.indexOf("\r")) < 0) {
                throw new JCAMPException("corrupt ##" + key + "=");
            }
            varType = xyData.substring(0, lf);
        } else {
            varType = xyData.substring(0, lf);
        }
        if (this.incrRE.match(varType)) {
            this.symbols = new String[]{this.incrRE.getParen(1), this.incrRE.getParen(2)};
            this.incremental = true;
            return;
        } else {
            if (!this.listRE.match(varType)) throw new JCAMPException("bad ##XYDATA= variable descriptor: \"" + varType + "\"");
            String varlist = this.listRE.getParen(1);
            this.analyzeVarList(varlist);
            this.incremental = false;
        }
    }

    public DataVariableInfo(String type) throws JCAMPException {
        if (this.incrRE.match(type)) {
            this.symbols = new String[]{this.incrRE.getParen(1), this.incrRE.getParen(2)};
            this.incremental = true;
        } else if (this.listRE.match(type)) {
            String varlist = this.listRE.getParen(1);
            this.analyzeVarList(varlist);
            this.incremental = false;
        } else {
            throw new JCAMPException("bad variable descriptor: \"" + type + "\"");
        }
    }

    private void analyzeVarList(String varlist) {
        Vector<String> tmp = new Vector<String>();
        int pos = 0;
        while (this.varRE.match(varlist, pos)) {
            String symbol = varlist.substring(this.varRE.getParenStart(0), this.varRE.getParenEnd(0));
            tmp.addElement(symbol);
            pos += this.varRE.getParenLength(0);
        }
        this.symbols = new String[tmp.size()];
        for (int i = 0; i < this.symbols.length; ++i) {
            this.symbols[i] = (String)tmp.elementAt(i);
        }
    }

    public String[] getSymbols() {
        return this.symbols;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("[");
        for (int i = 0; i < this.symbols.length; ++i) {
            tmp.append(this.symbols[i]);
            if (i >= this.symbols.length - 1) continue;
            tmp.append(',');
        }
        tmp.append("]");
        return tmp.toString();
    }

    static {
        try {
            RECompiler compiler = new RECompiler();
            INCR_REPRG = compiler.compile(INCR_RE);
            LIST_REPRG = compiler.compile(LIST_RE);
            VAR_REPRG = compiler.compile(VAR_RE);
        }
        catch (RESyntaxException e) {
            throw new Error("bad RE in DataVariableInfo");
        }
    }
}

