/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jcamp.parser.DataGroup;
import org.jcamp.parser.DataType;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.LineTokenizer;
import org.jcamp.spectrum.Multiplicity;

public class DatatableTokenizer
implements Enumeration {
    private final DataType type;
    private String data;
    private final String[] varSymbols;
    private int pos;
    private int length;

    public DatatableTokenizer(String[] symbols, String data) throws JCAMPException {
        this.type = DatatableTokenizer.checkSymbols(symbols);
        this.varSymbols = this.type == null ? symbols : this.type.getSymbols();
        this.data = DatatableTokenizer.normalizeData(this.varSymbols.length, data);
        this.length = this.data.length();
    }

    public DatatableTokenizer(JCAMPDataRecord ldr) throws JCAMPException {
        DataVariableInfo varInfo = new DataVariableInfo(ldr);
        this.type = DatatableTokenizer.checkSymbols(varInfo.getSymbols());
        this.varSymbols = this.type == null ? varInfo.getSymbols() : this.type.getSymbols();
        String ldrData = ldr.getContent();
        LineTokenizer lt = new LineTokenizer(ldrData);
        lt.nextLine();
        this.data = DatatableTokenizer.normalizeData(this.varSymbols.length, ldrData.substring(lt.getPosition()));
        this.length = this.data.length();
    }

    private static DataType checkSymbols(String[] varSymbols) throws JCAMPException {
        DataType dataType = null;
        if (varSymbols == null || varSymbols.length == 0) {
            throw new JCAMPException("bad variable declaration");
        }
        if (varSymbols.length == 2) {
            if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y")) {
                dataType = DataType.XY;
            }
        } else if (varSymbols.length == 3) {
            if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("W")) {
                dataType = DataType.XYW;
            } else if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("M")) {
                dataType = DataType.XYM;
            } else if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("A")) {
                dataType = DataType.XYA;
            }
        } else if (varSymbols.length == 4) {
            if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("W") && varSymbols[3].equalsIgnoreCase("A")) {
                dataType = DataType.XYWA;
            } else if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("M") && varSymbols[3].equalsIgnoreCase("A")) {
                dataType = DataType.XYMA;
            }
        } else if (varSymbols.length == 5 && varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("M") && varSymbols[3].equalsIgnoreCase("W") && varSymbols[4].equalsIgnoreCase("A")) {
            dataType = DataType.XYMWA;
        }
        return dataType;
    }

    public final DataType getType() {
        return this.type;
    }

    public boolean hasMoreElements() {
        return this.hasMoreGroups();
    }

    public boolean hasMoreGroups() {
        return this.pos < this.length;
    }

    private Double nextDouble(char delimiter) throws JCAMPException {
        Double x = null;
        String s = this.nextString(delimiter);
        try {
            x = new Double(s);
        }
        catch (NumberFormatException e) {
            throw new JCAMPException("bad number format");
        }
        return x;
    }

    public Object nextElement() {
        try {
            return this.nextGroup();
        }
        catch (JCAMPException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public DataGroup nextGroup() throws JCAMPException {
        if (this.pos >= this.length) {
            throw new JCAMPException("parsed beyond end of data block");
        }
        if (this.type.equals(DataType.XY)) {
            return this.nextXYGroup();
        }
        if (this.type.equals(DataType.XYW)) {
            return this.nextXYWGroup();
        }
        if (this.type.equals(DataType.XYM)) {
            return this.nextXYMGroup();
        }
        if (this.type.equals(DataType.XYA)) {
            return this.nextXYAGroup();
        }
        if (this.type.equals(DataType.XYWA)) {
            return this.nextXYWAGroup();
        }
        if (this.type.equals(DataType.XYMA)) {
            return this.nextXYMAGroup();
        }
        if (this.type.equals(DataType.XYMWA)) {
            return this.nextXYMWAGroup();
        }
        int n = this.varSymbols.length;
        Object[] values = new Object[n];
        for (int i = 0; i < n - 1; ++i) {
            try {
                values[i] = this.nextQString(',');
                continue;
            }
            catch (JCAMPException e) {
                String s = this.nextString(',');
                try {
                    values[i] = new Double(s);
                    continue;
                }
                catch (NumberFormatException ex) {
                    values[i] = s;
                }
            }
        }
        try {
            values[n - 1] = this.nextQString(';');
        }
        catch (JCAMPException e) {
            String s = this.nextString(';');
            try {
                values[n - 1] = new Double(s);
            }
            catch (NumberFormatException ex) {
                values[n - 1] = s;
            }
        }
        return new DataGroup(this.varSymbols, values);
    }

    private char nextMulti(char delimiter) throws JCAMPException {
        char m;
        String s = this.nextString(delimiter);
        if (s.length() == 1) {
            m = s.charAt(0);
            if (m != 'S' && m != 'D' && m != 'T' && m != 'Q' && m != 'M' && m != 'U') {
                throw new JCAMPException("bad multiplet data: \"" + s + "\"");
            }
        } else {
            throw new JCAMPException("bad multiplet data: \"" + s + "\"");
        }
        return m;
    }

    private String nextQString(char delimiter) throws JCAMPException {
        String a;
        int p;
        if (this.data.charAt(this.pos) == '<') {
            ++this.pos;
            p = this.data.indexOf(62, this.pos);
            if (p < 0) {
                throw new JCAMPException("missing closing '>' quote");
            }
            a = this.data.substring(this.pos, p);
            this.pos = p + 1;
            p = this.data.indexOf(delimiter, this.pos);
            if (p < 0) {
                throw new JCAMPException("bad data");
            }
        } else {
            throw new JCAMPException("unquoted string");
        }
        this.pos = p + 1;
        return a;
    }

    private String nextString(char delimiter) throws JCAMPException {
        int p = this.data.indexOf(delimiter, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing data");
        }
        String a = this.data.substring(this.pos, p);
        this.pos = p + 1;
        return a;
    }

    private DataGroup nextXYAGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        String a = this.nextQString(';');
        return new DataGroup(x, y, a);
    }

    private DataGroup nextXYGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(';');
        return new DataGroup(x, y);
    }

    private DataGroup nextXYMAGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        char m = this.nextMulti(',');
        String a = this.nextQString(';');
        return new DataGroup(x, y, Multiplicity.multiplicityOf(m), a);
    }

    private DataGroup nextXYMGroup() throws JCAMPException {
        char m = 'U';
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        m = this.nextMulti(';');
        return new DataGroup(x, y, Multiplicity.multiplicityOf(m));
    }

    private DataGroup nextXYMWAGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        char m = this.nextMulti(',');
        Double w = this.nextDouble(',');
        String a = this.nextQString(';');
        return new DataGroup(x, y, Multiplicity.multiplicityOf(m), w, a);
    }

    private DataGroup nextXYWAGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        Double w = this.nextDouble(',');
        String a = this.nextQString(';');
        return new DataGroup(x, y, w, a);
    }

    private DataGroup nextXYWGroup() throws JCAMPException {
        Double x = this.nextDouble(',');
        Double y = this.nextDouble(',');
        Double w = this.nextDouble(';');
        return new DataGroup(x, y, w);
    }

    private static String normalizeData(int groupLength, String orig) throws JCAMPException {
        StringBuffer normal = new StringBuffer();
        boolean inWS = false;
        boolean inDataValue = false;
        boolean inQuote = false;
        int j = 0;
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (inQuote) {
                if (c == '>') {
                    inQuote = false;
                }
                normal.append(c);
                continue;
            }
            if (c == '<') {
                inWS = false;
                inDataValue = true;
                inQuote = true;
                normal.append(c);
                continue;
            }
            if (c == '(' || c == ')') continue;
            if (Character.isWhitespace(c)) {
                if (inDataValue) {
                    inDataValue = false;
                    if (++j < groupLength) {
                        normal.append(',');
                    } else {
                        normal.append(';');
                        j = 0;
                    }
                }
                inWS = true;
                continue;
            }
            if (c == ';') {
                if (!inDataValue) continue;
                inDataValue = false;
                if (++j < groupLength) {
                    throw new JCAMPException("missing numbers in data");
                }
                if (j > groupLength) {
                    throw new JCAMPException("extra numbers in data");
                }
                normal.append(';');
                j = 0;
                continue;
            }
            if (c == ',') {
                if (!inDataValue) continue;
                inDataValue = false;
                if (++j >= groupLength) {
                    throw new JCAMPException("extra commas in data");
                }
                normal.append(',');
                continue;
            }
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') {
                normal.append(c);
                inWS = false;
                inDataValue = true;
                continue;
            }
            throw new JCAMPException("unexpected character '" + c + "' in data");
        }
        normal.append(';');
        return normal.toString();
    }
}

