/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Iterator;
import org.jcamp.parser.ASDFEncoder;
import org.jcamp.parser.IJCAMPNoteMarshaller;
import org.jcamp.parser.ISpectrumJCAMPWriter;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.NoteMarshallerFactory;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.FluorescenceSpectrum;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.notes.Note;
import org.jcamp.spectrum.notes.NoteDescriptor;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class FluorescenceJCAMPWriter
implements ISpectrumJCAMPWriter {
    private static final String CRLF = "\r\n";

    protected FluorescenceJCAMPWriter() {
    }

    private String buildAssignmentTable(int block, FluorescenceSpectrum fl) {
        StringBuffer jcamp = new StringBuffer();
        String origin = fl.getOrigin();
        String owner = fl.getOwner();
        Assignment[] assigns = fl.getAssignments();
        String title = fl.getTitle();
        int n = assigns.length;
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=FLUORESCENCE PEAK ASSIGNMENTS").append(CRLF);
        jcamp.append("##DATACLASS=ASSIGNMENTS").append(CRLF);
        jcamp.append(this.getJCAMPNotes(fl));
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(FluorescenceJCAMPWriter.getXUnitLDR(fl));
        jcamp.append(FluorescenceJCAMPWriter.getYUnitLDR(fl));
        jcamp.append("##NPOINTS=").append(n).append(CRLF);
        jcamp.append("##PEAKASSIGNMENTS=(XYA)").append(CRLF);
        for (int i = 0; i < n; ++i) {
            Pattern pattern = assigns[i].getPattern();
            double x = assigns[i].getPosition()[0];
            jcamp.append('(').append(x).append(",1,").append(",<").append(assigns[i].getLabel()).append(">)").append(CRLF);
        }
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    private String buildFSData(int block, FluorescenceSpectrum fl) {
        StringBuffer jcamp = new StringBuffer();
        String origin = fl.getOrigin();
        String owner = fl.getOwner();
        int n = fl.getXData().getLength();
        double x0 = fl.getXData().pointAt(0);
        double x1 = fl.getXData().pointAt(n - 1);
        double y0 = fl.getYData().pointAt(0);
        double y1 = fl.getYData().pointAt(n - 1);
        double xf = (double)(n - 1) / (x0 - x1);
        int[] y = new int[n];
        double yf = fl.getYDataAs16BitIntArray(y);
        String title = fl.getTitle();
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=FLUORESCENCE").append(CRLF);
        jcamp.append("##DATACLASS=XYDATA").append(CRLF);
        jcamp.append(this.getJCAMPNotes(fl));
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(FluorescenceJCAMPWriter.getXUnitLDR(fl));
        jcamp.append(FluorescenceJCAMPWriter.getYUnitLDR(fl));
        jcamp.append("##NPOINTS=").append(n).append(CRLF);
        jcamp.append("##FIRSTX=").append(x0).append(CRLF);
        jcamp.append("##LASTX=").append(x1).append(CRLF);
        jcamp.append("##DELTAX=").append((x1 - x0) / (double)(n - 1)).append(CRLF);
        jcamp.append("##XFACTOR=").append(xf).append(CRLF);
        jcamp.append("##FIRSTY=").append(y0).append(CRLF);
        jcamp.append("##LASTY=").append(y1).append(CRLF);
        jcamp.append("##YFACTOR=").append(yf).append(CRLF);
        jcamp.append("##XYDATA=(X++(Y..Y))").append(CRLF);
        jcamp.append(ASDFEncoder.encode(Math.round(x0 * xf), Math.round(x1 * xf), y));
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    private String buildPeakTable(int block, FluorescenceSpectrum fl) {
        StringBuffer jcamp = new StringBuffer();
        String title = fl.getTitle();
        String origin = fl.getOrigin();
        String owner = fl.getOwner();
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=FLUORESCENCE PEAK TABLE").append(CRLF);
        jcamp.append("##DATACLASS=PEAK TABLE").append(CRLF);
        jcamp.append(this.getJCAMPNotes(fl));
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(FluorescenceJCAMPWriter.getXUnitLDR(fl));
        jcamp.append(FluorescenceJCAMPWriter.getYUnitLDR(fl));
        if (fl.hasPeakTable()) {
            Peak1D[] peaks = fl.getPeakTable();
            int n = peaks.length;
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = peaks[i].getPosition()[0];
                double y = peaks[i].getPosition()[1];
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        } else if (!fl.isFullSpectrum()) {
            int n = fl.getXData().getLength();
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = fl.getXData().pointAt(i);
                double y = fl.getYData().pointAt(i);
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        }
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    protected String getJCAMPNotes(Spectrum spectrum) {
        StringBuffer notesStr = new StringBuffer();
        Iterator notesIt = spectrum.getNotes().iterator();
        while (notesIt.hasNext()) {
            Note note = (Note)notesIt.next();
            NoteDescriptor descr = note.getDescriptor();
            if ("title".equals(descr.getKey()) || !descr.isAllowedForSpectrumID(16)) continue;
            Object value = note.getValue();
            IJCAMPNoteMarshaller marshaller = NoteMarshallerFactory.getInstance().findByDescriptor(descr);
            notesStr.append(marshaller.toJCAMP(value));
        }
        return notesStr.toString();
    }

    private static String getXUnitLDR(FluorescenceSpectrum fs) {
        Unit unit = fs.getXData().getUnit();
        String name = unit.equals(CommonUnit.perCM) ? "##XUNITS=1/CM\r\n" : (unit.equals(CommonUnit.micrometerWavelength) ? "##XUNITS=MICROMETERS\r\n" : (unit.equals(CommonUnit.nanometerWavelength) ? "##XUNITS=NANOMETERS\r\n" : (unit.equals(CommonUnit.second) ? "##XUNITS=SECONDS\r\n" : "##XUNITS=ARBITRARY UNITS\r\n")));
        return name;
    }

    private static String getYUnitLDR(FluorescenceSpectrum fs) {
        Unit unit = fs.getYData().getUnit();
        String name = unit.equals(CommonUnit.transmittance) || unit.equals(CommonUnit.percentTransmittance) ? "##YUNITS=TRANSMITTANCE\r\n" : (unit.equals(CommonUnit.reflectance) || unit.equals(CommonUnit.percentReflectance) ? "##YUNITS=REFLECTANCE\r\n" : (unit.equals(CommonUnit.absorbance) ? "##YUNITS=ABSORBANCE\r\n" : (unit.equals(CommonUnit.kubelka) ? "##YUNITS=KUBELKA-MUNK\r\n" : "##YUNITS=ARBITRARY UNITS\r\n")));
        return name;
    }

    public String toJCAMP(Spectrum spectrum) throws JCAMPException {
        if (!(spectrum instanceof FluorescenceSpectrum)) {
            throw new JCAMPException("JCAMP adapter missmatch");
        }
        FluorescenceSpectrum uv = (FluorescenceSpectrum)spectrum;
        StringBuffer jcamp = new StringBuffer();
        String title = uv.getTitle();
        int nDataBlocks = 1;
        int block = 1;
        boolean linked = false;
        if (uv.hasAssignments()) {
            ++nDataBlocks;
        }
        if (uv.hasPeakTable() && uv.isFullSpectrum()) {
            ++nDataBlocks;
        }
        if (nDataBlocks > 1) {
            jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
            jcamp.append("##JCAMP-DX=4.24").append(CRLF);
            jcamp.append("##DATATYPE=LINK").append(CRLF);
            jcamp.append("##NBLOCKS=").append(nDataBlocks + 1).append(CRLF);
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
            ++block;
            linked = true;
        }
        if (uv.isFullSpectrum()) {
            jcamp.append(this.buildFSData(linked ? block : 0, uv));
            ++block;
            if (uv.hasAssignments()) {
                jcamp.append(this.buildAssignmentTable(linked ? block : 0, uv));
                ++block;
            }
            if (uv.hasPeakTable()) {
                jcamp.append(this.buildPeakTable(linked ? block : 0, uv));
                ++block;
            }
        } else {
            jcamp.append(this.buildPeakTable(linked ? block : 0, uv));
            ++block;
            if (uv.hasAssignments()) {
                jcamp.append(this.buildAssignmentTable(linked ? block : 0, uv));
                ++block;
            }
        }
        if (linked) {
            jcamp.append("##END=").append(CRLF);
        }
        return jcamp.toString();
    }

    public String toSimpleJCAMP(Spectrum spectrum) throws JCAMPException {
        if (!(spectrum instanceof FluorescenceSpectrum)) {
            throw new JCAMPException("JCAMP adapter missmatch");
        }
        FluorescenceSpectrum uv = (FluorescenceSpectrum)spectrum;
        StringBuffer jcamp = new StringBuffer();
        if (uv.isFullSpectrum()) {
            jcamp.append(this.buildFSData(0, uv));
        } else if (uv.hasAssignments()) {
            jcamp.append(this.buildAssignmentTable(0, uv));
        } else {
            jcamp.append(this.buildPeakTable(0, uv));
        }
        return jcamp.toString();
    }
}

