/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.IRSpectrum;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class IRJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    private static final String CRLF = "\r\n";

    protected IRJCAMPReader() {
    }

    private IRSpectrum createFS(JCAMPBlock block) throws JCAMPException {
        IRSpectrum spectrum;
        double yFactor;
        double xFactor;
        Unit xUnit = null;
        try {
            xUnit = this.getXUnits(block);
        }
        catch (JCAMPException e) {
            xUnit = CommonUnit.perCM;
        }
        Unit yUnit = null;
        try {
            yUnit = this.getYUnits(block);
        }
        catch (JCAMPException e) {
            yUnit = CommonUnit.absorbance;
        }
        try {
            xFactor = this.getXFactor(block);
        }
        catch (JCAMPException e) {
            xFactor = 1.0;
        }
        try {
            yFactor = this.getYFactor(block);
        }
        catch (JCAMPException e) {
            yFactor = 1.0;
        }
        int nPoints = this.getNPoints(block);
        if (block.getDataRecord("XYDATA") != null) {
            double lastX;
            double firstX = this.getFirstX(block);
            double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints, xFactor, yFactor);
            if (intensities.length != nPoints) {
                throw new JCAMPException("incorrect ##NPOINTS= or bad ##XYDATA=");
            }
            EquidistantData x = new EquidistantData(firstX, lastX, nPoints, xUnit);
            ArrayData y = new ArrayData(intensities, yUnit);
            spectrum = new IRSpectrum(x, y, true);
        } else if (block.getDataRecord("XYPOINTS") != null) {
            double[][] xy = this.getXYPoints(block, nPoints, xFactor, yFactor);
            OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
            ArrayData y = new ArrayData(xy[1], yUnit);
            spectrum = new IRSpectrum(x, y, false);
        } else {
            throw new JCAMPException("missing data: ##XYDATA= or ##XYPOINTS= required.");
        }
        return spectrum;
    }

    private IRSpectrum createPeakTable(JCAMPBlock block) throws JCAMPException {
        Object[] tables;
        Peak1D[] peaks;
        Unit yUnit;
        IRSpectrum spectrum = null;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.hertz;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        if (nPoints != (peaks = (Peak1D[])(tables = this.getPeaktable(block, nPoints, xFactor, yFactor))[0]).length) {
            block.getErrorHandler().error("incorrect ##NPOINTS=: expected " + Integer.toString(nPoints) + " but got " + Integer.toString(peaks.length));
            nPoints = peaks.length;
        }
        double[][] xy = IRJCAMPReader.peakTableToPeakSpectrum(peaks);
        OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
        ArrayData y = new ArrayData(xy[1], yUnit);
        spectrum = new IRSpectrum(x, y, false);
        spectrum.setPeakTable(peaks);
        if (tables.length > 1) {
            spectrum.setPatternTable((Pattern[])tables[1]);
            if (tables.length > 2) {
                spectrum.setAssignments((Assignment[])tables[2]);
            }
        }
        return spectrum;
    }

    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 2) {
            block.getErrorHandler().fatal("JCAMP reader adapter missmatch");
        }
        boolean isFID = false;
        IRSpectrum spectrum = null;
        JCAMPDataRecord ldrDataType = block.getDataRecord("DATATYPE");
        String dataType = ldrDataType.getContent().toUpperCase();
        JCAMPBlock.Type type = block.getType();
        if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
            spectrum = this.createFS(block);
        } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
            spectrum = this.createPeakTable(block);
        } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
            spectrum = this.createPeakTable(block);
        } else {
            block.getErrorHandler().fatal("illegal block type");
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }
}

