/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Hashtable;
import org.jcamp.parser.FluorescenceJCAMPWriter;
import org.jcamp.parser.IRJCAMPWriter;
import org.jcamp.parser.ISpectrumJCAMPWriter;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.MSJCAMPWriter;
import org.jcamp.parser.NMRJCAMPWriter;
import org.jcamp.parser.RamanJCAMPWriter;
import org.jcamp.parser.UVJCAMPWriter;
import org.jcamp.spectrum.Spectrum;

public class JCAMPWriter {
    private static JCAMPWriter theInstance = null;
    private static Hashtable adapters = new Hashtable(10);
    static /* synthetic */ Class class$org$jcamp$spectrum$NMRSpectrum;
    static /* synthetic */ Class class$org$jcamp$spectrum$IRSpectrum;
    static /* synthetic */ Class class$org$jcamp$spectrum$RamanSpectrum;
    static /* synthetic */ Class class$org$jcamp$spectrum$UVSpectrum;
    static /* synthetic */ Class class$org$jcamp$spectrum$MassSpectrum;
    static /* synthetic */ Class class$org$jcamp$spectrum$FluorescenceSpectrum;

    private JCAMPWriter() {
    }

    private ISpectrumJCAMPWriter findAdapter(Spectrum spectrum) {
        Class<?> spectrumClass = spectrum.getClass();
        ISpectrumJCAMPWriter writer = null;
        while (writer == null && spectrumClass != null) {
            writer = (ISpectrumJCAMPWriter)adapters.get(spectrumClass);
            spectrumClass.getSuperclass();
        }
        return writer;
    }

    public static JCAMPWriter getInstance() {
        if (theInstance == null) {
            theInstance = new JCAMPWriter();
            JCAMPWriter.initAdapters();
        }
        return theInstance;
    }

    private static void initAdapters() {
        adapters.put(class$org$jcamp$spectrum$NMRSpectrum == null ? (class$org$jcamp$spectrum$NMRSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.NMRSpectrum")) : class$org$jcamp$spectrum$NMRSpectrum, new NMRJCAMPWriter());
        adapters.put(class$org$jcamp$spectrum$IRSpectrum == null ? (class$org$jcamp$spectrum$IRSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.IRSpectrum")) : class$org$jcamp$spectrum$IRSpectrum, new IRJCAMPWriter());
        adapters.put(class$org$jcamp$spectrum$RamanSpectrum == null ? (class$org$jcamp$spectrum$RamanSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.RamanSpectrum")) : class$org$jcamp$spectrum$RamanSpectrum, new RamanJCAMPWriter());
        adapters.put(class$org$jcamp$spectrum$UVSpectrum == null ? (class$org$jcamp$spectrum$UVSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.UVSpectrum")) : class$org$jcamp$spectrum$UVSpectrum, new UVJCAMPWriter());
        adapters.put(class$org$jcamp$spectrum$MassSpectrum == null ? (class$org$jcamp$spectrum$MassSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.MassSpectrum")) : class$org$jcamp$spectrum$MassSpectrum, new MSJCAMPWriter());
        adapters.put(class$org$jcamp$spectrum$FluorescenceSpectrum == null ? (class$org$jcamp$spectrum$FluorescenceSpectrum = JCAMPWriter.class$("org.jcamp.spectrum.FluorescenceSpectrum")) : class$org$jcamp$spectrum$FluorescenceSpectrum, new FluorescenceJCAMPWriter());
    }

    public String toJCAMP(Spectrum spectrum) throws JCAMPException {
        ISpectrumJCAMPWriter adapter = this.findAdapter(spectrum);
        if (adapter == null) {
            throw new JCAMPException("cannot write JCAMP for " + spectrum.getClass());
        }
        return adapter.toJCAMP(spectrum);
    }

    public String toSimpleJCAMP(Spectrum spectrum) throws JCAMPException {
        ISpectrumJCAMPWriter adapter = this.findAdapter(spectrum);
        if (adapter == null) {
            throw new JCAMPException("cannot write JCAMP for " + spectrum.getClass());
        }
        return adapter.toSimpleJCAMP(spectrum);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

