/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.jcamp.parser.IStringIterator;

public class LDRIterator
implements IStringIterator {
    private static String labelRegExp = "##[^=\\n\\r]*=";
    private static RECompiler compiler = new RECompiler();
    private REProgram labelProgram = null;
    private RE labelRE;
    private int start;
    private int end;
    private String jcamp;

    public LDRIterator() {
        try {
            this.labelProgram = compiler.compile(labelRegExp);
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
        }
        this.labelRE = new RE(this.labelProgram, 1);
        this.start = 0;
        this.end = -1;
    }

    public LDRIterator(String jcamp) {
        try {
            this.labelProgram = compiler.compile(labelRegExp);
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
        }
        this.labelRE = new RE(this.labelProgram, 1);
        this.start = 0;
        this.end = -1;
        this.jcamp = jcamp;
        this.firstLabel();
    }

    private void firstLabel() {
        if (this.jcamp == null) {
            return;
        }
        if (this.start >= this.jcamp.length()) {
            return;
        }
        if (this.labelRE.match(this.jcamp)) {
            this.start = this.labelRE.getParenStart(0);
            this.end = this.labelRE.getParenEnd(0);
            return;
        }
        this.end = this.start = this.jcamp.length();
    }

    public int getOffset() {
        if (this.jcamp != null && this.start < this.jcamp.length()) {
            return this.start;
        }
        return -1;
    }

    public boolean hasNext() {
        if (this.jcamp == null) {
            return false;
        }
        return this.start < this.jcamp.length();
    }

    public String next() {
        String ldr = null;
        if (this.jcamp != null && this.start < this.jcamp.length()) {
            if (this.labelRE.match(this.jcamp, this.end + 1)) {
                ldr = this.jcamp.substring(this.start, this.labelRE.getParenStart(0) - 1);
                this.start = this.labelRE.getParenStart(0);
                this.end = this.labelRE.getParenEnd(0);
            } else {
                ldr = this.jcamp.substring(this.start);
                this.start = this.end = this.jcamp.length();
            }
        }
        return ldr;
    }
}

