/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.math.IArray2D;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuple;
import org.jcamp.parser.JCAMPNTuplePage;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.GCMSSpectrum;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.MassSpectrum;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class MSJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    private static final String CRLF = "\r\n";

    protected MSJCAMPReader() {
    }

    private MassSpectrum createFS(JCAMPBlock block) throws JCAMPException {
        ArrayData y;
        IOrderedDataArray1D x;
        Unit yUnit;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.mz;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.percentIntensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        if (block.getDataRecord("XYDATA") != null) {
            double lastX;
            double firstX = this.getFirstX(block);
            double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints, xFactor, yFactor);
            if (intensities.length != nPoints) {
                throw new JCAMPException("incorrect ##NPOINTS= or bad ##XYDATA=");
            }
            x = new EquidistantData(firstX, lastX, nPoints, xUnit);
            y = new ArrayData(intensities, yUnit);
        } else if (block.getDataRecord("XYPOINTS") != null) {
            double[][] xy = this.getXYPoints(block, nPoints, xFactor, yFactor);
            x = new OrderedArrayData(xy[0], xUnit);
            y = new ArrayData(xy[1], yUnit);
        } else {
            throw new JCAMPException("missing data: ##XYDATA= or ##XYPOINTS= required.");
        }
        MassSpectrum spectrum = new MassSpectrum(x, y, true);
        return spectrum;
    }

    private GCMSSpectrum createGCMS(JCAMPBlock block) throws JCAMPException {
        GCMSSpectrum spectrum;
        Unit yUnit;
        String title = this.getTitle(block);
        JCAMPNTuple ntuple = block.getNTuple();
        JCAMPVariable[] vars = block.getVariables();
        boolean nIndep = false;
        boolean nDep = false;
        int pageVar = -1;
        int nPages = ntuple.numPages();
        MassSpectrum[] ms = new MassSpectrum[nPages];
        double[] times = this.getRetentionTimes(ntuple);
        double[] tics = this.getTICs(ntuple);
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.mz;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.relativeAbundance;
        }
        for (int i = 0; i < nPages; ++i) {
            JCAMPNTuplePage page = block.getNTuple().getPage(i);
            IArray2D msxy = page.getXYData();
            OrderedArrayData x = new OrderedArrayData((IOrderedArray1D)msxy.getXArray(), xUnit);
            ArrayData y = new ArrayData(msxy.getYArray(), yUnit);
            ms[i] = new MassSpectrum(x, y, false);
            if (Double.isNaN(times[i])) {
                ms[i].setTitle(title + "(mass spectrum [" + i + "]");
                continue;
            }
            ms[i].setTitle(title + "(mass spectrum [" + i + "]: t=" + times[i] + ")");
        }
        OrderedArrayData x = new OrderedArrayData(times, CommonUnit.second);
        if (tics != null) {
            ArrayData y = new ArrayData(tics, CommonUnit.intensity);
            spectrum = new GCMSSpectrum((IOrderedDataArray1D)x, (IDataArray1D)y, ms);
        } else {
            spectrum = new GCMSSpectrum((IOrderedDataArray1D)x, ms);
        }
        return spectrum;
    }

    private MassSpectrum createPeakTable(JCAMPBlock block) throws JCAMPException {
        double yFactor;
        double xFactor;
        MassSpectrum spectrum = null;
        String title = this.getTitle(block);
        Unit xUnit = null;
        try {
            xUnit = this.getXUnits(block);
        }
        catch (JCAMPException e) {
            xUnit = CommonUnit.mz;
        }
        Unit yUnit = null;
        try {
            yUnit = this.getYUnits(block);
        }
        catch (JCAMPException e) {
            yUnit = CommonUnit.intensity;
        }
        try {
            xFactor = this.getXFactor(block);
        }
        catch (JCAMPException e) {
            xFactor = 1.0;
        }
        try {
            yFactor = this.getYFactor(block);
        }
        catch (JCAMPException e) {
            yFactor = 1.0;
        }
        int nPoints = this.getNPoints(block);
        Object[] tables = this.getPeaktable(block, nPoints, xFactor, yFactor);
        if (tables == null) {
            throw new JCAMPException("missing data table");
        }
        Peak1D[] peaks = (Peak1D[])tables[0];
        double[][] xy = MSJCAMPReader.peakTableToPeakSpectrum(peaks);
        OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
        ArrayData y = new ArrayData(xy[1], yUnit);
        spectrum = new MassSpectrum(x, y, false);
        if (peaks.length < 50) {
            spectrum.setPeakTable(peaks);
        }
        if (tables.length > 1) {
            Assignment[] assigns;
            Pattern[] pattern = (Pattern[])tables[1];
            if (pattern != null && pattern.length < 50) {
                spectrum.setPatternTable(pattern);
            }
            if (tables.length > 2 && (assigns = (Assignment[])tables[2]) != null && assigns.length < 50) {
                spectrum.setAssignments(assigns);
            }
        }
        spectrum.setTitle(title);
        try {
            String owner = this.getOwner(block);
            spectrum.setOwner(owner);
        }
        catch (JCAMPException e) {
            // empty catch block
        }
        try {
            String origin = this.getOrigin(block);
            spectrum.setOrigin(origin);
        }
        catch (JCAMPException e) {
            // empty catch block
        }
        return spectrum;
    }

    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 64) {
            block.getErrorHandler().fatal("JCAMP reader adapter missmatch");
        }
        boolean isFID = false;
        if (block.isNTupleBlock()) {
            GCMSSpectrum spectrum = this.createGCMS(block);
            this.setNotes(block, spectrum);
            return spectrum;
        }
        MassSpectrum spectrum = null;
        JCAMPBlock.Type type = block.getType();
        if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
            spectrum = this.createFS(block);
        } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
            spectrum = this.createPeakTable(block);
        } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
            spectrum = this.createPeakTable(block);
        } else {
            block.getErrorHandler().fatal("illegal block type");
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }

    private double[] getRetentionTimes(JCAMPNTuple ntuple) {
        int nPages = ntuple.numPages();
        JCAMPVariable vTime = ntuple.getVariableByName("RETENTIONTIME");
        String[] timeValues = ntuple.getVariableValues(".RETENTIONTIME", vTime);
        double[] times = new double[nPages];
        double timeFactor = 1.0;
        double firstTime = Double.NaN;
        double lastTime = Double.NaN;
        double deltaTime = 0.0;
        if (vTime != null) {
            if (vTime.getFactor() != null) {
                timeFactor = vTime.getFactor();
            }
            if (vTime.getFirst() != null) {
                firstTime = vTime.getFirst();
            }
            if (vTime.getLast() != null) {
                lastTime = vTime.getLast();
            }
            deltaTime = (lastTime - firstTime) / (double)nPages;
        }
        for (int i = 0; i < times.length; ++i) {
            times[i] = timeValues[i] != null ? Double.parseDouble(timeValues[i]) * timeFactor : firstTime + (double)i * deltaTime;
        }
        return times;
    }

    private double[] getTICs(JCAMPNTuple ntuple) {
        int nPages = ntuple.numPages();
        JCAMPVariable vtic = ntuple.getVariableByName("RIC");
        String[] ticValues = ntuple.getVariableValues(".RIC", vtic);
        double[] tics = new double[nPages];
        double ticFactor = 1.0;
        boolean hasTIC = false;
        if (vtic != null && vtic.getFactor() != null) {
            ticFactor = vtic.getFactor();
        }
        for (int i = 0; i < tics.length; ++i) {
            if (ticValues[i] != null) {
                hasTIC = true;
                tics[i] = Double.parseDouble(ticValues[i]) * ticFactor;
                continue;
            }
            tics[i] = Double.NaN;
        }
        if (hasTIC) {
            return tics;
        }
        return null;
    }
}

