/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jcamp.parser.Utils;
import org.jcamp.spectrum.notes.NoteDescriptor;

public class NoteDescriptorFactory {
    private static NoteDescriptorFactory theInstance = null;
    private static Hashtable jcampKeys = new Hashtable();
    static /* synthetic */ Class class$org$jcamp$spectrum$notes$NoteDescriptor;

    private NoteDescriptorFactory() {
        this.initFactory();
    }

    public NoteDescriptor findByJCAMPKey(String jcampKey) {
        NoteDescriptor descr = (NoteDescriptor)jcampKeys.get(jcampKey);
        if (descr == null) {
            String key = jcampKey.toLowerCase();
            if (key.charAt(0) == '$') {
                key = key.substring(1);
            }
            descr = new NoteDescriptor(key, jcampKey);
            descr.setUnique(false);
        }
        return descr;
    }

    public static NoteDescriptorFactory getInstance() {
        if (theInstance == null) {
            theInstance = new NoteDescriptorFactory();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFactory() {
        jcampKeys.put("XYDATA", NoteDescriptor.IGNORE);
        jcampKeys.put("PEAKTABLE", NoteDescriptor.IGNORE);
        jcampKeys.put("PEAKASSIGNMENT", NoteDescriptor.IGNORE);
        jcampKeys.put("DATATABLE", NoteDescriptor.IGNORE);
        jcampKeys.put("XYPOINTS", NoteDescriptor.IGNORE);
        jcampKeys.put("PAGE", NoteDescriptor.IGNORE);
        jcampKeys.put("NTUPLES", NoteDescriptor.IGNORE);
        jcampKeys.put("DATACLASS", NoteDescriptor.IGNORE);
        jcampKeys.put("DATATYPE", NoteDescriptor.IGNORE);
        jcampKeys.put("END", NoteDescriptor.IGNORE);
        jcampKeys.put("ENDNTUPLES", NoteDescriptor.IGNORE);
        jcampKeys.put("VARNAME", NoteDescriptor.IGNORE);
        jcampKeys.put("VARTYPE", NoteDescriptor.IGNORE);
        jcampKeys.put("VARDIM", NoteDescriptor.IGNORE);
        jcampKeys.put("SYMBOL", NoteDescriptor.IGNORE);
        jcampKeys.put("LAST", NoteDescriptor.IGNORE);
        jcampKeys.put("FIRST", NoteDescriptor.IGNORE);
        jcampKeys.put("LASTX", NoteDescriptor.IGNORE);
        jcampKeys.put("FIRSTX", NoteDescriptor.IGNORE);
        jcampKeys.put("UNITS", NoteDescriptor.IGNORE);
        jcampKeys.put("XUNITS", NoteDescriptor.IGNORE);
        jcampKeys.put("YUNITS", NoteDescriptor.IGNORE);
        jcampKeys.put("LASTY", NoteDescriptor.IGNORE);
        jcampKeys.put("FIRSTY", NoteDescriptor.IGNORE);
        jcampKeys.put("XFACTOR", NoteDescriptor.IGNORE);
        jcampKeys.put("YFACTOR", NoteDescriptor.IGNORE);
        jcampKeys.put("NPOINTS", NoteDescriptor.IGNORE);
        jcampKeys.put("JCAMPDX", NoteDescriptor.IGNORE);
        jcampKeys.put("JCAMPCS", NoteDescriptor.IGNORE);
        jcampKeys.put("TITLE", NoteDescriptor.IGNORE);
        Properties notesProps = new Properties();
        InputStream is = null;
        try {
            is = (class$org$jcamp$spectrum$notes$NoteDescriptor == null ? (class$org$jcamp$spectrum$notes$NoteDescriptor = NoteDescriptorFactory.class$("org.jcamp.spectrum.notes.NoteDescriptor")) : class$org$jcamp$spectrum$notes$NoteDescriptor).getResourceAsStream("notes.properties");
            if (is == null) {
                return;
            }
            notesProps.load(is);
            Enumeration<?> notesNames = notesProps.propertyNames();
            while (notesNames.hasMoreElements()) {
                String jcamp;
                NoteDescriptor descr;
                String key = (String)notesNames.nextElement();
                Object marshaller = null;
                if (key.indexOf(46) >= 0 || (descr = NoteDescriptor.findByKey(key)) == null || (jcamp = (String)notesProps.get(key + ".jcamp")) == null) continue;
                jcampKeys.put(Utils.normalizeLabel(jcamp), descr);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

