/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Iterator;
import org.jcamp.parser.ASDFEncoder;
import org.jcamp.parser.CommonSpectrumJCAMPWriter;
import org.jcamp.parser.IJCAMPNoteMarshaller;
import org.jcamp.parser.ISpectrumJCAMPWriter;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.NoteMarshallerFactory;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.RamanSpectrum;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.notes.Note;
import org.jcamp.spectrum.notes.NoteDescriptor;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class RamanJCAMPWriter
extends CommonSpectrumJCAMPWriter
implements ISpectrumJCAMPWriter {
    private static final String CRLF = "\r\n";

    protected RamanJCAMPWriter() {
    }

    private String buildAssignmentTable(int block, RamanSpectrum raman) {
        StringBuffer jcamp = new StringBuffer();
        String origin = raman.getOrigin();
        String owner = raman.getOwner();
        Assignment[] assigns = raman.getAssignments();
        String title = raman.getTitle();
        int n = assigns.length;
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=RAMAN PEAK ASSIGNMENTS").append(CRLF);
        jcamp.append("##DATACLASS=ASSIGNMENTS").append(CRLF);
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(this.getJCAMPNotes(raman));
        jcamp.append(RamanJCAMPWriter.getXUnitLDR(raman));
        jcamp.append(RamanJCAMPWriter.getYUnitLDR(raman));
        jcamp.append("##NPOINTS=").append(n).append(CRLF);
        jcamp.append("##PEAKASSIGNMENTS=(XYA)").append(CRLF);
        for (int i = 0; i < n; ++i) {
            Pattern pattern = assigns[i].getPattern();
            double x = assigns[i].getPosition()[0];
            jcamp.append('(').append(x).append(",1,").append(",<").append(assigns[i].getLabel()).append(">)").append(CRLF);
        }
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    private String buildFSData(int block, RamanSpectrum raman) {
        StringBuffer jcamp = new StringBuffer();
        String origin = raman.getOrigin();
        String owner = raman.getOwner();
        int n = raman.getXData().getLength();
        double x0 = raman.getXData().pointAt(0);
        double x1 = raman.getXData().pointAt(n - 1);
        double y0 = raman.getYData().pointAt(0);
        double y1 = raman.getYData().pointAt(n - 1);
        double xf = (double)(n - 1) / (x0 - x1);
        int[] y = new int[n];
        double yf = raman.getYDataAs16BitIntArray(y);
        String title = raman.getTitle();
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=RAMAN SPECTRUM").append(CRLF);
        jcamp.append("##DATACLASS=XYDATA").append(CRLF);
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(this.getJCAMPNotes(raman));
        jcamp.append(RamanJCAMPWriter.getXUnitLDR(raman));
        jcamp.append(RamanJCAMPWriter.getYUnitLDR(raman));
        jcamp.append("##NPOINTS=").append(n).append(CRLF);
        jcamp.append("##FIRSTX=").append(x0).append(CRLF);
        jcamp.append("##LASTX=").append(x1).append(CRLF);
        jcamp.append("##DELTAX=").append((x1 - x0) / (double)(n - 1)).append(CRLF);
        jcamp.append("##XFACTOR=").append(xf).append(CRLF);
        jcamp.append("##FIRSTY=").append(y0).append(CRLF);
        jcamp.append("##LASTY=").append(y1).append(CRLF);
        jcamp.append("##YFACTOR=").append(yf).append(CRLF);
        jcamp.append("##XYDATA=(X++(Y..Y))").append(CRLF);
        jcamp.append(ASDFEncoder.encode(Math.round(x0 * xf), Math.round(x1 * xf), y));
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    private String buildPeakTable(int block, RamanSpectrum raman) {
        StringBuffer jcamp = new StringBuffer();
        String title = raman.getTitle();
        String origin = raman.getOrigin();
        String owner = raman.getOwner();
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=4.24").append(CRLF);
        jcamp.append("##DATATYPE=RAMAN PEAK TABLE").append(CRLF);
        jcamp.append("##DATACLASS=PEAK TABLE").append(CRLF);
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(this.getJCAMPNotes(raman));
        jcamp.append(RamanJCAMPWriter.getXUnitLDR(raman));
        jcamp.append(RamanJCAMPWriter.getYUnitLDR(raman));
        if (raman.hasPeakTable()) {
            Peak1D[] peaks = raman.getPeakTable();
            int n = peaks.length;
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = peaks[i].getPosition()[0];
                double y = peaks[i].getPosition()[1];
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        } else if (!raman.isFullSpectrum()) {
            int n = raman.getXData().getLength();
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = raman.getXData().pointAt(i);
                double y = raman.getYData().pointAt(i);
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        }
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    protected String getJCAMPNotes(Spectrum spectrum) {
        StringBuffer notesStr = new StringBuffer();
        Iterator notesIt = spectrum.getNotes().iterator();
        while (notesIt.hasNext()) {
            Note note = (Note)notesIt.next();
            NoteDescriptor descr = note.getDescriptor();
            if ("title".equals(descr.getKey()) || !descr.isAllowedForSpectrumID(4)) continue;
            Object value = note.getValue();
            IJCAMPNoteMarshaller marshaller = NoteMarshallerFactory.getInstance().findByDescriptor(descr);
            notesStr.append(marshaller.toJCAMP(value));
        }
        return notesStr.toString();
    }

    private static String getXUnitLDR(RamanSpectrum raman) {
        Unit unit = raman.getXData().getUnit();
        String name = unit.equals(CommonUnit.perCM) ? "##XUNITS=1/CM\r\n" : (unit.equals(CommonUnit.micrometerWavelength) ? "##XUNITS=MICROMETERS\r\n" : (unit.equals(CommonUnit.nanometerWavelength) ? "##XUNITS=NANOMETERS\r\n" : (unit.equals(CommonUnit.second) ? "##XUNITS=SECONDS\r\n" : "##XUNITS=ARBITRARY UNITS\r\n")));
        return name;
    }

    private static String getYUnitLDR(RamanSpectrum raman) {
        Unit unit = raman.getYData().getUnit();
        String name = unit.equals(CommonUnit.transmittance) || unit.equals(CommonUnit.percentTransmittance) ? "##YUNITS=TRANSMITTANCE\r\n" : (unit.equals(CommonUnit.reflectance) || unit.equals(CommonUnit.percentReflectance) ? "##YUNITS=REFLECTANCE\r\n" : (unit.equals(CommonUnit.absorbance) ? "##YUNITS=ABSORBANCE\r\n" : (unit.equals(CommonUnit.kubelka) ? "##YUNITS=KUBELKA-MUNK\r\n" : "##YUNITS=ARBITRARY UNITS\r\n")));
        return name;
    }

    public String toJCAMP(Spectrum spectrum) throws JCAMPException {
        if (!(spectrum instanceof RamanSpectrum)) {
            throw new JCAMPException("JCAMP adapter missmatch");
        }
        RamanSpectrum raman = (RamanSpectrum)spectrum;
        StringBuffer jcamp = new StringBuffer();
        String title = raman.getTitle();
        int nDataBlocks = 1;
        int block = 1;
        boolean linked = false;
        if (raman.hasAssignments()) {
            ++nDataBlocks;
        }
        if (raman.hasPeakTable() && raman.isFullSpectrum()) {
            ++nDataBlocks;
        }
        if (nDataBlocks > 1) {
            jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
            jcamp.append("##JCAMP-DX=4.24").append(CRLF);
            jcamp.append("##DATATYPE=LINK").append(CRLF);
            jcamp.append("##NBLOCKS=").append(nDataBlocks + 1).append(CRLF);
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
            jcamp.append(super.getJCAMPNotes(spectrum));
            ++block;
            linked = true;
        }
        if (raman.isFullSpectrum()) {
            jcamp.append(this.buildFSData(linked ? block : 0, raman));
            ++block;
            if (raman.hasAssignments()) {
                jcamp.append(this.buildAssignmentTable(linked ? block : 0, raman));
                ++block;
            }
            if (raman.hasPeakTable()) {
                jcamp.append(this.buildPeakTable(linked ? block : 0, raman));
                ++block;
            }
        } else {
            jcamp.append(this.buildPeakTable(linked ? block : 0, raman));
            ++block;
            if (raman.hasAssignments()) {
                jcamp.append(this.buildAssignmentTable(linked ? block : 0, raman));
                ++block;
            }
        }
        if (linked) {
            jcamp.append("##END=").append(CRLF);
        }
        return jcamp.toString();
    }

    public String toSimpleJCAMP(Spectrum spectrum) throws JCAMPException {
        if (!(spectrum instanceof RamanSpectrum)) {
            throw new JCAMPException("JCAMP adapter missmatch");
        }
        RamanSpectrum raman = (RamanSpectrum)spectrum;
        StringBuffer jcamp = new StringBuffer();
        String title = raman.getTitle();
        if (raman.isFullSpectrum()) {
            jcamp.append(this.buildFSData(0, raman));
        } else if (raman.hasAssignments()) {
            jcamp.append(this.buildAssignmentTable(0, raman));
        } else {
            jcamp.append(this.buildPeakTable(0, raman));
        }
        return jcamp.toString();
    }
}

