/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ASDFCheckHandler;
import org.jcamp.parser.ASDFParseState;

public class ReplacingCheckHandler
implements ASDFCheckHandler {
    private double firstX;
    private double lastX;
    private double deltaX;
    private double xFactor;
    private int nPoints;
    private static double EPS = 2.5E-323;
    private static Log log = LogFactory.getLog((Class)(class$org$jcamp$parser$ReplacingCheckHandler == null ? (class$org$jcamp$parser$ReplacingCheckHandler = ReplacingCheckHandler.class$("org.jcamp.parser.ReplacingCheckHandler")) : class$org$jcamp$parser$ReplacingCheckHandler));
    static /* synthetic */ Class class$org$jcamp$parser$ReplacingCheckHandler;

    public ReplacingCheckHandler(double firstX, double lastX, double xFactor, int nPoints) {
        this.firstX = firstX;
        this.lastX = lastX;
        this.xFactor = xFactor;
        this.deltaX = (lastX - firstX) / (double)(nPoints - 1);
        this.nPoints = nPoints;
    }

    public int check(ASDFParseState state) {
        int realY;
        double realX;
        double checkX = this.xFactor * state.getCheckX();
        if (Math.abs(checkX - (realX = this.firstX + (double)state.getCurrentIndex() * this.deltaX)) * this.xFactor > 0.1) {
            log.warn((Object)("x check failed in line" + state.getCurrentLineNumber() + ": expected x = " + Double.toString(checkX) + " but got " + Double.toString(realX)));
            int newIndex = (int)Math.floor((checkX - this.firstX) / this.deltaX + 0.5);
            if (newIndex < 0 || newIndex >= this.nPoints) {
                log.error((Object)"bad x check value");
                return 2;
            }
            state.setCurrentIndex(newIndex);
            return 1;
        }
        int checkY = state.getCheckY();
        if (checkY != (realY = state.getCurrentY())) {
            log.warn((Object)("y check failed in line " + state.getCurrentLineNumber() + ": expected y = " + Integer.toString(checkY) + " but got " + Integer.toString(realY)));
            return 1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("line " + state.getCurrentLineNumber() + ": check passed"));
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

