/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class Chromatogram
extends Spectrum1D {
    public static final Unit DEFAULT_XUNIT = CommonUnit.second;
    public static final Unit DEFAULT_YUNIT = CommonUnit.intensity;

    protected Chromatogram() {
    }

    public Chromatogram(IOrderedDataArray1D x, IDataArray1D y) {
        super(x, y);
    }

    public Chromatogram(IOrderedDataArray1D x, IDataArray1D y, boolean fullSpectrum) {
        super(x, y, fullSpectrum);
    }

    protected void adjustFullViewRange() {
        Range1D.Double xrange = this.getXData().getRange1D();
        double w = xrange.getXWidth();
        xrange.set(xrange.getXMin() - 0.05 * w, xrange.getXMax() + 0.05 * w);
        this.setXFullViewRange(xrange);
        Range1D.Double yrange = this.getYData().getRange1D();
        w = yrange.getXWidth();
        yrange.set(yrange.getXMin() - 0.05 * w, yrange.getXMax() + 0.05 * w);
        this.setYFullViewRange(yrange);
    }

    public Object clone() {
        Chromatogram spectrum = (Chromatogram)super.clone();
        spectrum.xAxisMap = new LinearAxisMap(this.xData);
        spectrum.yAxisMap = new LinearAxisMap(this.yData);
        return spectrum;
    }

    public int getIdentifier() {
        return 131072;
    }

    public boolean isSameType(Spectrum otherSpectrum) {
        return otherSpectrum instanceof Chromatogram;
    }
}

