/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.DataException;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IEquidistant;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public class EquidistantData
implements IOrderedDataArray1D,
IEquidistant {
    private LinearGrid1D data;
    private Unit unit;
    private String label;

    public EquidistantData(double first, double last, int n, Unit unit) {
        this.data = new LinearGrid1D(first, last, n);
        this.unit = unit != null ? unit : CommonUnit.generic;
    }

    public EquidistantData(LinearGrid1D data) {
        this(data, CommonUnit.generic);
    }

    public EquidistantData(LinearGrid1D data, Unit unit) {
        this.data = data;
        this.unit = unit != null ? unit : CommonUnit.generic;
    }

    public int[] boundIndices(double position) throws DataException {
        Range1D.Double r = this.data.getRange1D();
        int max = this.data.getLength() - 1;
        if (!r.contains(position)) {
            throw new DataException("data point out of data range");
        }
        double c = this.data.coordinateAt(position);
        if (this.isAscending()) {
            int c0 = Math.max(0, (int)Math.floor(c));
            int c1 = Math.min(max, (int)Math.ceil(c));
            return new int[]{c0, c1};
        }
        int c0 = Math.min(max, (int)Math.ceil(c));
        int c1 = Math.max(0, (int)Math.floor(c));
        return new int[]{c0, c1};
    }

    public Range1D.Double bounds(double position) throws DataException {
        int[] bi = this.boundIndices(position);
        return new Range1D.Double(this.data.pointAt(bi[0]), this.data.pointAt(bi[1]));
    }

    public double ceil(double position) throws DataException {
        return this.data.pointAt(this.ceilIndex(position));
    }

    public int ceilIndex(double position) throws DataException {
        double c = this.data.coordinateAt(position);
        Range1D.Double r = this.data.getRange1D();
        if (position > r.getXMax()) {
            throw new DataException("no ceiling data point for position");
        }
        int max = this.data.getLength() - 1;
        if (this.isAscending()) {
            if (position < r.getXMin()) {
                return 0;
            }
            return Math.min(max, (int)Math.ceil(c));
        }
        if (position < r.getXMin()) {
            return max;
        }
        return Math.max(0, (int)Math.floor(c));
    }

    public Object clone() {
        EquidistantData o = null;
        try {
            o = (EquidistantData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        o.data = (LinearGrid1D)this.data.clone();
        o.unit = (Unit)this.unit.clone();
        return o;
    }

    public void convertToUnit(Unit newUnit) throws UnitException {
        double newStart = newUnit.convertFrom(this.data.getStart(), this.unit);
        double newEnd = newUnit.convertFrom(this.data.getEnd(), this.unit);
        this.data = new LinearGrid1D(newStart, newEnd, this.data.getLength());
    }

    public double floor(double position) throws DataException {
        return this.data.pointAt(this.floorIndex(position));
    }

    public int floorIndex(double position) throws DataException {
        double c = this.data.coordinateAt(position);
        Range1D.Double r = this.data.getRange1D();
        int max = this.data.getLength() - 1;
        if (position < r.getXMin()) {
            throw new DataException("no floor data point for position");
        }
        if (this.isAscending()) {
            if (position > r.getXMax()) {
                return max;
            }
            return Math.max(0, (int)Math.floor(c));
        }
        if (position > r.getXMax()) {
            return 0;
        }
        return Math.min(max, (int)Math.ceil(c));
    }

    public LinearGrid1D getDataGrid() {
        return this.data;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.unit.toString();
        }
        return this.label;
    }

    public int getLength() {
        return this.data.getLength();
    }

    public Range.Double getRange() {
        return this.data.getRange();
    }

    public Range1D.Double getRange1D() {
        return this.data.getRange1D();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int indexAt(double p) {
        return this.data.indexAt(p);
    }

    public boolean isAscending() {
        return this.data.isAscending();
    }

    public double pointAt(int index) {
        return this.data.pointAt(index);
    }

    public void scale(double amount) {
        this.data.scale(amount);
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    public double[] toArray() {
        return this.data.toArray();
    }

    public void translate(double amount) {
        this.data.translate(amount);
    }
}

