/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.Range1D;
import org.jcamp.math.Range3D;
import org.jcamp.spectrum.FluorescenceSpectrum;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.NMRSpectrum;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum2D;

public class Fluorescence2DSpectrum
extends Spectrum2D {
    public Fluorescence2DSpectrum(IOrderedDataArray1D x, IOrderedDataArray1D y, IDataArray1D z) {
        super(x, y, z);
        this.setFullSpectrum(true);
        this.adjustFullViewRange();
    }

    private void adjustFullViewRange() {
        if (this.isFullSpectrum()) {
            Range1D.Double xrange = this.getXData().getRange1D();
            this.setXFullViewRange(xrange);
            Range1D.Double yrange = this.getYData().getRange1D();
            this.setYFullViewRange(yrange);
            Range1D.Double zrange = this.getZData().getRange1D();
            this.setZFullViewRange(zrange);
        }
    }

    public Range3D.Double getDataRange() {
        return new Range3D.Double(this.xAxisMap.getDataRange(), this.yAxisMap.getDataRange(), this.zAxisMap.getDataRange());
    }

    public FluorescenceSpectrum getEmissionSpectrum(int index) {
        throw new RuntimeException("not implemented");
    }

    public FluorescenceSpectrum getExcitationSpectrum(int index) {
        throw new RuntimeException("not implemented");
    }

    public int getIdentifier() {
        return 0x2000010;
    }

    public boolean isSameType(Spectrum otherSpectrum) {
        return otherSpectrum instanceof NMRSpectrum;
    }
}

