/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.util.Vector;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.IPeakPicking;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum1D;

public class MinHeightPeakPicking
implements IPeakPicking {
    private double minHeight;
    private double noise;
    private int maxPeaks = 40;

    public MinHeightPeakPicking(double minHeight, double noise) {
        this.minHeight = minHeight;
        this.noise = noise;
    }

    private int calcPeakRange(Peak1D peak, int index, double noise) {
        double int0;
        double int1;
        int j;
        Spectrum1D spectrum = (Spectrum1D)peak.getSpectrum();
        IOrderedDataArray1D xdata = spectrum.getXData();
        IDataArray1D idata = spectrum.getYData();
        int lindex = index;
        int rindex = index;
        lindex = -1;
        for (j = index; j >= 1; --j) {
            int1 = idata.pointAt(j);
            int0 = idata.pointAt(j - 1);
            if (!(int0 > int1) || !(Math.abs(int1 - int0) < noise)) continue;
            lindex = j;
            break;
        }
        lindex = Math.max(lindex, 0);
        rindex = xdata.getLength();
        for (j = index + 1; j <= xdata.getLength() - 2; ++j) {
            int1 = idata.pointAt(j + 1);
            if (!(int1 > (int0 = idata.pointAt(j))) || !(Math.abs(int1 - int0) < noise)) continue;
            rindex = j;
            break;
        }
        rindex = Math.min(xdata.getLength() - 1, rindex);
        Range1D.Double range = new Range1D.Double(xdata.pointAt(lindex), xdata.pointAt(rindex));
        peak.setRange(range);
        int0 = idata.pointAt(lindex);
        index = lindex;
        for (int i = lindex; i <= rindex; ++i) {
            int1 = idata.pointAt(i);
            if (!(int1 > int0)) continue;
            index = i;
            int0 = int1;
        }
        return index;
    }

    public Vector calculate(Spectrum1D spectrum) {
        if (spectrum.isFullSpectrum()) {
            Vector peakVector;
            double currentNoise = this.getNoise();
            do {
                peakVector = this.pickPeaksFS(spectrum, currentNoise);
                currentNoise *= 2.0;
            } while (peakVector.size() > this.maxPeaks);
            return peakVector;
        }
        return this.pickPeaksPT(spectrum);
    }

    public int getMaxPeaks() {
        return this.maxPeaks;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public double getNoise() {
        return this.noise;
    }

    private Vector pickPeaksFS(Spectrum1D spectrum, double noise) {
        Vector<Peak1D> peaks = new Vector<Peak1D>();
        boolean nPeaks = false;
        IOrderedDataArray1D xdata = spectrum.getXData();
        IDataArray1D idata = spectrum.getYData();
        int n = xdata.getLength();
        double base = 0.0;
        for (int i = 0; i < n; ++i) {
            double int0 = idata.pointAt(i);
            int imax = i;
            if (!(Math.abs(int0 - base) > noise)) continue;
            int j = i + 1;
            while (j < n) {
                int0 = idata.pointAt(j - 1);
                double int1 = idata.pointAt(j);
                if (!(int1 >= int0)) break;
                imax = j++;
            }
            Peak1D peak = new Peak1D(xdata.pointAt(imax), idata.pointAt(imax));
            peak.setSpectrum(spectrum);
            imax = this.calcPeakRange(peak, imax, noise);
            int0 = idata.pointAt(imax);
            if (!(int0 > this.minHeight)) continue;
            peaks.addElement(peak);
            i = Math.max(i, peak.getIndexRange().getXMax());
        }
        return peaks;
    }

    private Vector pickPeaksPT(Spectrum1D spectrum) {
        Vector<Peak1D> peaks = new Vector<Peak1D>();
        boolean nPeaks = false;
        IOrderedDataArray1D xdata = spectrum.getXData();
        IDataArray1D idata = spectrum.getYData();
        int n = xdata.getLength();
        for (int i = 0; i < n; ++i) {
            double int0 = idata.pointAt(i);
            if (!(int0 > this.minHeight)) continue;
            Peak1D peak = new Peak1D(spectrum, xdata.pointAt(i));
            peaks.addElement(peak);
        }
        return peaks;
    }

    public void setMaxPeaks(int newMaxPeaks) {
        this.maxPeaks = newMaxPeaks;
    }

    public void setMinHeight(double newMinHeight) {
        this.minHeight = newMinHeight;
    }

    public void setNoise(double newNoise) {
        this.noise = newNoise;
    }
}

