/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Multiplicity
implements Serializable,
Comparable {
    private final String symbol;
    private final int ordinal;
    public static final Multiplicity UNKNOWN = new Multiplicity(0, "U");
    public static final Multiplicity SINGULET = new Multiplicity(1, "S");
    public static final Multiplicity DOUBLET = new Multiplicity(2, "D");
    public static final Multiplicity TRIPLET = new Multiplicity(3, "T");
    public static final Multiplicity QUADRUPLET = new Multiplicity(4, "Q");
    public static final Multiplicity MULTIPLET = new Multiplicity(5, "M");
    private static final Multiplicity[] TYPES = new Multiplicity[]{UNKNOWN, SINGULET, DOUBLET, TRIPLET, QUADRUPLET, MULTIPLET};
    private static final List TYPES_LIST = Collections.unmodifiableList(Arrays.asList(TYPES));

    private Multiplicity(int ordinal, String symbol) {
        this.ordinal = ordinal;
        this.symbol = symbol;
    }

    public int compareTo(Object o) {
        return this.ordinal - ((Multiplicity)o).ordinal;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Multiplicity && (Multiplicity)obj == this;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public final int hashCode() {
        return this.ordinal;
    }

    public static Multiplicity multiplicityOf(char m) {
        switch (m) {
            case 'S': 
            case 's': {
                return SINGULET;
            }
            case 'D': 
            case 'd': {
                return DOUBLET;
            }
            case 'T': 
            case 't': {
                return TRIPLET;
            }
            case 'Q': 
            case 'q': {
                return QUADRUPLET;
            }
            case 'M': 
            case 'm': {
                return MULTIPLET;
            }
        }
        return UNKNOWN;
    }

    public static Multiplicity multiplicityOf(int m) {
        if (m >= Multiplicity.MULTIPLET.ordinal) {
            return MULTIPLET;
        }
        if (m <= 0) {
            return UNKNOWN;
        }
        return TYPES[m];
    }

    public static Multiplicity multiplicityOf(String symbol) {
        symbol = symbol.trim().toUpperCase();
        for (int i = 0; i < TYPES.length; ++i) {
            if (!symbol.equals(TYPES[i].getSymbol())) continue;
            return TYPES[i];
        }
        return UNKNOWN;
    }

    private Object readResolve() throws ObjectStreamException {
        return TYPES[this.ordinal];
    }

    public String toString() {
        return this.symbol;
    }

    public static Collection types() {
        return TYPES_LIST;
    }
}

