/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.AxisMap;
import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.math.ReversedLinearAxisMap;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum2D;

public class NMR2DSpectrum
extends Spectrum2D {
    private static final Range1D.Double DEFAULT_ZRANGE = new Range1D.Double(0.0, 20.0);
    private static final Range1D.Double[] DEFAULT_XYRANGE = new Range1D.Double[]{new Range1D.Double(-2.0, 14.0), new Range1D.Double(0.0, 200.0)};
    String[] nucleus = new String[]{"^13C", "^13C"};
    double[] frequency = new double[]{300.0, 300.0};
    double[] reference = new double[]{0.0, 0.0};
    boolean fullSpectrum = true;

    public NMR2DSpectrum(IOrderedDataArray1D x, IOrderedDataArray1D y, IDataArray1D z, String[] nucleus, double[] freq, double[] ref) {
        super(x, y, z);
        this.nucleus = nucleus;
        this.frequency = freq;
        this.reference = ref;
        this.adjustFullViewRange();
    }

    private void adjustFullViewRange() {
        if (this.isFullSpectrum()) {
            Range1D.Double xrange = this.getXData().getRange1D();
            double w = xrange.getXWidth();
            xrange.set(xrange.getXMin() - 0.05 * w, xrange.getXMax() + 0.05 * w);
            this.setXFullViewRange(xrange);
            Range1D.Double yrange = this.getYData().getRange1D();
            w = yrange.getXWidth();
            yrange.set(yrange.getXMin() - 0.05 * w, yrange.getXMax() + 0.05 * w);
            this.setYFullViewRange(yrange);
            Range1D.Double zrange = this.getZData().getRange1D();
            w = zrange.getXWidth();
            zrange.set(zrange.getXMin() - 0.05 * w, zrange.getXMax() + 0.05 * w);
            this.setZFullViewRange(zrange);
        }
    }

    public Object clone() {
        NMR2DSpectrum o = (NMR2DSpectrum)super.clone();
        o.nucleus = new String[]{this.nucleus[0], this.nucleus[1]};
        o.frequency = new double[]{this.frequency[0], this.frequency[1]};
        o.reference = new double[]{this.reference[0], this.reference[1]};
        return o;
    }

    private static double[] convertToPPM(double[] hz, double freq, double ref) {
        int n = hz.length;
        double[] ppm = new double[n];
        for (int i = 0; i < n; ++i) {
            ppm[i] = (hz[i] - ref) / freq;
        }
        return ppm;
    }

    public int getIdentifier() {
        return 0x2000020;
    }

    public String getXNucleus() {
        return this.nucleus[0];
    }

    public double getXReference() {
        return this.reference[0];
    }

    public AxisMap getYAxisMap() {
        return this.yAxisMap;
    }

    public double getYFrequency() {
        return this.frequency[1];
    }

    public String getYNucleus() {
        return this.nucleus[1];
    }

    public double getYReference() {
        return this.reference[1];
    }

    public boolean isFullSpectrum() {
        return this.fullSpectrum;
    }

    public boolean isSameType(Spectrum otherSpectrum) {
        return otherSpectrum instanceof NMR2DSpectrum;
    }

    public void setXFullViewRange(Range1D.Double dataRange) {
        this.xAxisMap = new ReversedLinearAxisMap(this.getXData(), dataRange);
    }

    public void setYFullViewRange(Range1D.Double dataRange) {
        this.yAxisMap = new ReversedLinearAxisMap(this.getYData(), dataRange);
    }

    public void setZFullViewRange(Range1D.Double dataRange) {
        this.zAxisMap = new LinearAxisMap(this.zData, dataRange);
    }
}

