/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.NMRSpectrum;

public class NMRFIDSpectrum
extends NMRSpectrum {
    protected IDataArray1D rData;
    protected IDataArray1D iData;

    protected NMRFIDSpectrum() {
    }

    public NMRFIDSpectrum(IOrderedDataArray1D x, IDataArray1D r, IDataArray1D i, String nucleus, double freq, double ref) {
        super(x, r, nucleus, freq, ref);
        this.rData = r;
        this.iData = i;
        this.mapRealFID();
    }

    public NMRFIDSpectrum(IOrderedDataArray1D x, IDataArray1D r, String nucleus, double freq, double ref) {
        this(x, r, null, nucleus, freq, ref);
    }

    public Object clone() {
        NMRFIDSpectrum spectrum = null;
        spectrum = (NMRFIDSpectrum)super.clone();
        spectrum.iData = (IDataArray1D)this.iData.clone();
        spectrum.rData = (IDataArray1D)this.rData.clone();
        this.mapRealFID();
        return spectrum;
    }

    public int getIdentifier() {
        return 0x1000020;
    }

    public boolean isFID() {
        return true;
    }

    public void mapImaginaryFID() {
        if (this.iData != null) {
            this.yData = this.iData;
            this.adjustFullViewRange();
        }
    }

    public void mapRealFID() {
        this.yData = this.rData;
        this.adjustFullViewRange();
    }

    public void setData(IOrderedDataArray1D x, IDataArray1D y) {
        this.xData = x;
        this.yData = y;
        this.rData = y;
        this.mapRealFID();
    }

    public void setXFullViewRange(Range1D.Double dataRange) {
        this.xAxisMap = new LinearAxisMap(this.xData, dataRange);
    }

    public void setYFullViewRange(Range1D.Double dataRange) {
        this.yAxisMap = new LinearAxisMap(this.yData, dataRange);
    }
}

