/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.DataException;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.math.OrderedArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public class OrderedArrayData
implements IOrderedDataArray1D {
    private OrderedArray1D data;
    private Unit unit;
    private String label;
    private boolean ascending = true;

    public OrderedArrayData(double[] data, Unit unit) {
        this.data = new OrderedArray1D(data, false, true);
        this.unit = unit != null ? unit : CommonUnit.generic;
        if (data.length > 1) {
            this.ascending = data[0] < data[1];
        }
    }

    public OrderedArrayData(IOrderedArray1D data) {
        this(data, CommonUnit.generic);
    }

    public OrderedArrayData(IOrderedArray1D data, Unit unit) {
        this.data = new OrderedArray1D(data);
        this.unit = unit != null ? unit : CommonUnit.generic;
    }

    private int binsearchIndex(double position) {
        int left = 0;
        int right = this.getLength() - 1;
        double sleft = this.data.pointAt(left);
        double sright = this.data.pointAt(right);
        if (this.isAscending()) {
            while (right - left > 1) {
                int mid = (right + left) / 2;
                double sposition = this.data.pointAt(mid);
                if (position > sposition) {
                    left = mid;
                    continue;
                }
                if (position < sposition) {
                    right = mid;
                    continue;
                }
                left = mid;
                break;
            }
            return left;
        }
        while (right - left > 1) {
            int mid = (right + left) / 2;
            double sposition = this.data.pointAt(mid);
            if (position < sposition) {
                left = mid;
                continue;
            }
            if (position > sposition) {
                right = mid;
                continue;
            }
            left = mid;
            break;
        }
        return left;
    }

    public int[] boundIndices(double position) throws DataException {
        Range1D.Double r = this.data.getRange1D();
        int max = this.data.getLength() - 1;
        if (!r.contains(position)) {
            throw new DataException("data point out of data range");
        }
        if (this.isAscending()) {
            int c0 = Math.max(0, this.binsearchIndex(position));
            return new int[]{c0, c0 + 1};
        }
        int c0 = Math.min(max, this.binsearchIndex(position) + 1);
        return new int[]{c0, c0 - 1};
    }

    public Range1D.Double bounds(double position) throws DataException {
        int[] bi = this.boundIndices(position);
        return new Range1D.Double(this.data.pointAt(bi[0]), this.data.pointAt(bi[1]));
    }

    public double ceil(double position) throws DataException {
        return this.data.pointAt(this.ceilIndex(position));
    }

    public int ceilIndex(double position) throws DataException {
        int n = this.data.getLength();
        if (n == 0) {
            throw new DataException("empty data set");
        }
        if (n == 1) {
            if (position < this.data.pointAt(0)) {
                return 0;
            }
            throw new DataException("no ceiling data point for position");
        }
        Range1D.Double r = this.data.getRange1D();
        if (position > r.getXMax()) {
            throw new DataException("no ceiling data point for position");
        }
        int max = n - 1;
        if (this.isAscending()) {
            if (position < r.getXMin()) {
                return 0;
            }
            return Math.min(max, this.binsearchIndex(position) + 1);
        }
        if (position < r.getXMin()) {
            return max;
        }
        return Math.max(0, this.binsearchIndex(position));
    }

    public Object clone() {
        OrderedArrayData o = null;
        try {
            o = (OrderedArrayData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        o.data = (OrderedArray1D)this.data.clone();
        o.unit = (Unit)this.unit.clone();
        return o;
    }

    public void convertToUnit(Unit newUnit) throws UnitException {
        double[] array = new double[this.data.getLength()];
        for (int i = 0; i < this.data.getLength(); ++i) {
            array[i] = newUnit.convertFrom(this.data.pointAt(i), this.unit);
        }
        this.data = new OrderedArray1D(array, false);
        this.setUnit(newUnit);
    }

    public double floor(double position) throws DataException {
        return this.data.pointAt(this.floorIndex(position));
    }

    public int floorIndex(double position) throws DataException {
        int n = this.data.getLength();
        if (n == 0) {
            throw new DataException("empty data set");
        }
        if (n == 1) {
            if (position > this.data.pointAt(0)) {
                return 0;
            }
            throw new DataException("no floor data point for position");
        }
        Range1D.Double r = this.data.getRange1D();
        int max = n - 1;
        if (position < r.getXMin()) {
            throw new DataException("no floor data point for position");
        }
        if (this.isAscending()) {
            if (position > r.getXMax()) {
                return max;
            }
            return Math.max(0, this.binsearchIndex(position));
        }
        if (position > r.getXMax()) {
            return 0;
        }
        return Math.min(max, this.binsearchIndex(position) + 1);
    }

    public String getLabel() {
        if (this.label == null) {
            return this.unit.toString();
        }
        return this.label;
    }

    public int getLength() {
        return this.data.getLength();
    }

    public Range.Double getRange() {
        return this.data.getRange();
    }

    public Range1D.Double getRange1D() {
        return this.data.getRange1D();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int indexAt(double p) {
        return this.data.indexAt(p);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public double pointAt(int index) {
        return this.data.pointAt(index);
    }

    public void scale(double amount) {
        this.data.scale(amount);
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    public double[] toArray() {
        return this.data.toArray();
    }

    public void translate(double amount) {
        this.data.translate(amount);
    }
}

