/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.util.Enumeration;
import java.util.Vector;
import org.jcamp.spectrum.ISpectrumLabel;
import org.jcamp.spectrum.Multiplicity;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum1D;

public class Pattern
implements ISpectrumLabel,
Cloneable {
    private Multiplicity multiplicity = Multiplicity.UNKNOWN;
    private double[] position = new double[2];
    private Spectrum1D spectrum;
    private Peak1D[] peaks;

    public Pattern(double position, Multiplicity multi) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        this.position[0] = position;
        this.spectrum = null;
        this.multiplicity = multi;
    }

    public Pattern(double position, Multiplicity multi, Peak1D[] peaks) {
        this(null, position, multi, peaks);
    }

    public Pattern(double position, String multi) {
        this(position, Multiplicity.multiplicityOf(multi));
    }

    public Pattern(Multiplicity multi, Peak1D[] peaks) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        double position = 0.0;
        this.spectrum = null;
        this.multiplicity = multi;
        if (peaks == null || peaks.length == 0) {
            throw new IllegalArgumentException("pattern without position or peaks");
        }
        this.setPeaks(peaks);
        for (int i = 0; i < peaks.length; ++i) {
            position += this.peaks[i].getPosition()[0];
        }
        this.position[0] = position / (double)this.peaks.length;
    }

    public Pattern(Spectrum1D spectrum, Peak1D[] peaks) {
        this(spectrum, Multiplicity.multiplicityOf(peaks.length), peaks);
    }

    public Pattern(Spectrum1D spectrum, double position, Multiplicity multi) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        this.position[0] = position;
        this.spectrum = spectrum;
        this.multiplicity = multi;
    }

    public Pattern(Spectrum1D spectrum, double position, Multiplicity multi, Peak1D[] peaks) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        this.position[0] = position;
        this.spectrum = spectrum;
        this.multiplicity = multi;
        this.setPeaks(peaks);
    }

    public Pattern(Spectrum1D spectrum, double position, Multiplicity multi, Vector peaks) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        this.position[0] = position;
        this.spectrum = spectrum;
        this.multiplicity = multi;
        this.setPeaks(peaks);
    }

    public Pattern(Spectrum1D spectrum, double position, String multi) {
        this(spectrum, position, Multiplicity.multiplicityOf(multi));
    }

    public Pattern(Spectrum1D spectrum, double position, String multi, Peak1D[] peaks) {
        this(spectrum, position, Multiplicity.multiplicityOf(multi), peaks);
    }

    public Pattern(Spectrum1D spectrum, double position, String multi, Vector peaks) {
        this(spectrum, position, Multiplicity.multiplicityOf(multi), peaks);
    }

    public Pattern(Spectrum1D spectrum, Multiplicity multi, Peak1D[] peaks) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        double position = 0.0;
        this.spectrum = spectrum;
        this.multiplicity = multi;
        if (peaks == null || peaks.length == 0) {
            throw new IllegalArgumentException("pattern without position or peaks");
        }
        this.setPeaks(peaks);
        for (int i = 0; i < peaks.length; ++i) {
            position += this.peaks[i].getPosition()[0];
        }
        this.position[0] = position / (double)this.peaks.length;
    }

    public Pattern(Spectrum1D spectrum, Multiplicity multi, Vector peaks) {
        this.position[0] = 0.0;
        this.position[1] = 1.0;
        this.spectrum = null;
        this.peaks = null;
        double position = 0.0;
        this.spectrum = spectrum;
        this.multiplicity = multi;
        if (peaks == null || peaks.size() == 0) {
            throw new IllegalArgumentException("pattern without position or peaks");
        }
        this.peaks = new Peak1D[peaks.size()];
        for (int i = 0; i < peaks.size(); ++i) {
            this.peaks[i] = (Peak1D)((Peak1D)peaks.elementAt(i)).clone();
            position += this.peaks[i].getPosition()[0];
        }
        this.position[0] = position / (double)this.peaks.length;
    }

    public Pattern(Spectrum1D spectrum, String multi, Peak1D[] peaks) {
        this(spectrum, Multiplicity.multiplicityOf(multi), peaks);
    }

    public Pattern(Spectrum1D spectrum, String multi, Vector peaks) {
        this(spectrum, Multiplicity.multiplicityOf(multi), peaks);
    }

    public Pattern(Spectrum1D spectrum, Vector peaks) {
        this(spectrum, Multiplicity.multiplicityOf(peaks.size()), peaks);
    }

    public Pattern(String multi, Peak1D[] peaks) {
        this(Multiplicity.multiplicityOf(multi), peaks);
    }

    public Object clone() {
        Pattern pattern = new Pattern(this.spectrum, this.position[0], this.multiplicity, this.peaks);
        return pattern;
    }

    public int compareTo(Object obj) {
        double p1;
        double p0 = this.getPosition()[0];
        if (p0 < (p1 = ((ISpectrumLabel)obj).getPosition()[0])) {
            return -1;
        }
        if (p0 > p1) {
            return 1;
        }
        return 0;
    }

    public String getLabel() {
        return this.multiplicity.getSymbol();
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public Peak1D[] getPeaks() {
        return this.peaks;
    }

    public double[] getPosition() {
        return this.position;
    }

    public Spectrum1D getSpectrum() {
        return this.spectrum;
    }

    public Enumeration peaks() {
        return new Enumeration(){
            int i = 0;

            public Object nextElement() {
                if (Pattern.this.peaks != null && this.i < Pattern.this.peaks.length) {
                    Peak1D peak = Pattern.this.peaks[this.i];
                    ++this.i;
                    return peak;
                }
                return null;
            }

            public boolean hasMoreElements() {
                return Pattern.this.peaks != null && this.i < Pattern.this.peaks.length - 1;
            }
        };
    }

    public void setMultiplicity(Multiplicity newMultiplicity) {
        this.multiplicity = newMultiplicity;
    }

    public void setPeaks(Peak1D[] peaks) {
        this.peaks = null;
        if (peaks != null) {
            this.peaks = new Peak1D[peaks.length];
            for (int i = 0; i < peaks.length; ++i) {
                this.peaks[i] = (Peak1D)peaks[i].clone();
            }
        }
    }

    public void setPeaks(Vector peaks) {
        this.peaks = null;
        if (peaks != null) {
            this.peaks = new Peak1D[peaks.size()];
            for (int i = 0; i < peaks.size(); ++i) {
                this.peaks[i] = (Peak1D)((Peak1D)peaks.elementAt(i)).clone();
            }
        }
    }

    public void setPosition(double[] newPosition) {
        this.position[0] = newPosition[0];
        this.position[1] = newPosition[1];
    }

    public void setSpectrum(Spectrum1D newSpectrum) {
        if (this.spectrum != newSpectrum) {
            this.spectrum = newSpectrum;
            if (this.peaks != null) {
                for (int i = 0; i < this.peaks.length; ++i) {
                    this.peaks[i].setSpectrum(this.spectrum);
                }
            }
        }
    }

    public String toString() {
        StringBuffer label = new StringBuffer("Pattern[");
        for (int i = 0; i < this.position.length; ++i) {
            label.append(this.position[i]);
            if (i >= this.position.length - 1) continue;
            label.append(",");
        }
        label.append("]: ").append(this.getLabel());
        return label.toString();
    }

    public void translate(double[] amount) {
        this.position[0] = this.position[0] + amount[0];
        this.position[1] = this.position[1] + amount[1];
        for (int i = 0; i < this.peaks.length; ++i) {
            this.peaks[i].translate(amount);
        }
    }
}

