/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.spectrum.ISpectrumLabel;
import org.jcamp.spectrum.Spectrum;

public abstract class Peak
implements ISpectrumLabel {
    protected double[] position = new double[]{0.0, 1.0};
    protected double height = 1.0;
    protected Spectrum spectrum;

    public Peak(Spectrum spectrum, double[] position) {
        this.spectrum = spectrum;
        int n = position.length;
        this.position = new double[n];
        for (int i = 0; i < n; ++i) {
            this.position[i] = position[i];
        }
    }

    public Peak(Spectrum spectrum, double[] position, double height) {
        this.spectrum = spectrum;
        int n = position.length;
        this.position = new double[n];
        for (int i = 0; i < n; ++i) {
            this.position[i] = position[i];
        }
        this.height = height;
    }

    public double getHeight() {
        return this.height;
    }

    public abstract String getLabel();

    public double[] getPosition() {
        return this.position;
    }

    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
    }

    public void setPosition(double[] newPosition) {
        this.position[0] = newPosition[0];
        this.position[1] = newPosition[1];
    }

    public void setSpectrum(Spectrum newSpectrum) {
        this.spectrum = newSpectrum;
    }

    public String toString() {
        StringBuffer label = new StringBuffer("Peak[");
        for (int i = 0; i < this.position.length; ++i) {
            label.append(this.position[i]);
            if (i >= this.position.length - 1) continue;
            label.append(",");
        }
        label.append("]: ").append(this.getLabel());
        return label.toString();
    }

    public void translate(double[] amount) {
        this.position[0] = this.position[0] + amount[0];
    }
}

