/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.IrregularAxisMap;
import org.jcamp.math.IrregularGrid1D;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.OpticalSpectrum1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class RamanSpectrum
extends OpticalSpectrum1D {
    private static final double[] DEFAULT_WAVENUMBERS = new double[]{4000.0, 3500.0, 3000.0, 2500.0, 2000.0, 1800.0, 1600.0, 1400.0, 1200.0, 1000.0, 800.0, 600.0, 400.0};
    private static final IrregularGrid1D DEFAULT_XGRID = new IrregularGrid1D(DEFAULT_WAVENUMBERS);
    private static final Range1D.Double DEFAULT_YRANGE = new Range1D.Double(0.0, 1.0);
    private static final Unit DEFAULT_XUNIT = CommonUnit.perCM;
    private static final Unit DEFAULT_YUNIT = CommonUnit.intensity;

    protected RamanSpectrum() {
    }

    public RamanSpectrum(IOrderedDataArray1D x, IDataArray1D y) {
        super(x, y);
    }

    public RamanSpectrum(IOrderedDataArray1D x, IDataArray1D y, boolean fullSpectrum) {
        super(x, y, fullSpectrum);
    }

    public int getIdentifier() {
        return 4;
    }

    public boolean isSameType(Spectrum otherSpectrum) {
        return otherSpectrum instanceof RamanSpectrum;
    }

    public void setXFullViewRange(Range1D.Double dataRange) {
        IrregularGrid1D newGrid = new IrregularGrid1D(DEFAULT_XGRID, dataRange);
        this.xAxisMap = new IrregularAxisMap(this.getXData(), newGrid);
    }
}

