/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jcamp.math.AxisMap;
import org.jcamp.spectrum.notes.Note;
import org.jcamp.spectrum.notes.NoteDescriptor;

public abstract class Spectrum
implements Cloneable,
Serializable {
    protected Spectrum masterSpectrum = null;
    HashMap noteMap = new HashMap(20);
    protected ArrayList notes = new ArrayList(20);

    Spectrum() {
    }

    public Object clone() {
        Spectrum spectrum = null;
        try {
            spectrum = (Spectrum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        spectrum.copyNotes(this);
        return spectrum;
    }

    protected void copyNotes(Spectrum spectrum) {
        Iterator entries = spectrum.getNotes().iterator();
        while (entries.hasNext()) {
            Note note = (Note)entries.next();
            this.setNote(note.getDescriptor(), note.clone());
        }
    }

    public abstract int getIdentifier();

    public Spectrum getMasterSpectrum() {
        return this.masterSpectrum;
    }

    public Note getNote(int index) {
        if (index < this.notes.size()) {
            return (Note)this.notes.get(index);
        }
        return null;
    }

    public Collection getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public List getNotes(NoteDescriptor descr) {
        ArrayList list = (ArrayList)this.noteMap.get(descr);
        if (list == null) {
            return null;
        }
        return list;
    }

    public String getOrigin() {
        List origin = this.getNotes(NoteDescriptor.ORIGIN);
        if (origin != null) {
            return (String)((Note)origin.get(0)).getValue();
        }
        return "UNKNOWN ORIGIN";
    }

    public String getOwner() {
        List owner = this.getNotes(NoteDescriptor.OWNER);
        if (owner != null) {
            return (String)((Note)owner.get(0)).getValue();
        }
        return "UNKNOWN OWNER";
    }

    public String getTitle() {
        List title = this.getNotes(NoteDescriptor.TITLE);
        if (title != null) {
            return (String)((Note)title.get(0)).getValue();
        }
        return "SPECTRUM";
    }

    public abstract String getXAxisLabel();

    public abstract AxisMap getXAxisMap();

    public abstract String getYAxisLabel();

    public abstract AxisMap getYAxisMap();

    public boolean hasMasterSpectrum() {
        return this.masterSpectrum != null;
    }

    public abstract boolean isFullSpectrum();

    public abstract boolean isSameType(Spectrum var1);

    public void setMasterSpectrum(Spectrum newMasterSpectrum) {
        this.masterSpectrum = newMasterSpectrum;
    }

    public synchronized void setNote(NoteDescriptor descr, Object value) {
        Note note = new Note();
        note.setValue(value);
        note.setDescriptor(descr);
        ArrayList<Note> noteArr = (ArrayList<Note>)this.noteMap.get(descr);
        if (noteArr != null && descr.isUnique()) {
            Note oldNote = (Note)noteArr.get(0);
            oldNote.setValue(value);
            note = oldNote;
            return;
        }
        this.notes.add(note);
        if (noteArr == null) {
            noteArr = new ArrayList<Note>(descr.isUnique() ? 1 : 10);
            this.noteMap.put(descr, noteArr);
        }
        noteArr.add(note);
    }

    public void setNote(String key, Object value) {
        NoteDescriptor descr = NoteDescriptor.findByKey(key);
        if (descr == null) {
            descr = new NoteDescriptor(key);
        }
        this.setNote(descr, value);
    }

    public synchronized void setNoteValue(int index, Object value) {
        if (index >= this.notes.size()) {
            return;
        }
        ((Note)this.notes.get(index)).setValue(value);
    }

    public void setOrigin(String newOrigin) {
        this.setNote(NoteDescriptor.ORIGIN, (Object)newOrigin);
    }

    public void setOwner(String newOwner) {
        this.setNote(NoteDescriptor.OWNER, (Object)newOwner);
    }

    public void setTitle(String newTitle) {
        this.setNote(NoteDescriptor.TITLE, (Object)newTitle);
    }
}

