/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.io.Serializable;
import java.util.Arrays;
import org.jcamp.math.AxisMap;
import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.math.Range2D;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.ISpectrumLabel;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;

public abstract class Spectrum1D
extends Spectrum
implements Cloneable,
Serializable {
    IOrderedDataArray1D xData;
    IDataArray1D yData;
    protected boolean fullSpectrum;
    protected AxisMap xAxisMap = null;
    protected AxisMap yAxisMap = null;
    protected Peak1D[] peakTable = null;
    protected Pattern[] patternTable = null;
    protected Assignment[] assignments = null;

    public Spectrum1D() {
    }

    public Spectrum1D(IOrderedDataArray1D x, IDataArray1D y) {
        this(x, y, !(x instanceof EquidistantData));
    }

    public Spectrum1D(IOrderedDataArray1D x, IDataArray1D y, boolean fullSpectrum) {
        this.xData = x;
        this.yData = y;
        this.fullSpectrum = fullSpectrum;
        this.xAxisMap = new LinearAxisMap(x);
        this.yAxisMap = new LinearAxisMap(y);
    }

    protected void adjustFullViewRange() {
        if (this.isFullSpectrum()) {
            Range1D.Double xrange = this.xData.getRange1D();
            double w = xrange.getXWidth();
            xrange.set(xrange.getXMin() - 0.05 * w, xrange.getXMax() + 0.05 * w);
            this.setXFullViewRange(xrange);
            Range1D.Double yrange = this.yData.getRange1D();
            w = yrange.getXWidth();
            yrange.set(yrange.getXMin() - 0.05 * w, yrange.getXMax() + 0.05 * w);
            this.setYFullViewRange(yrange);
        } else {
            double w;
            int n = this.xData.getLength();
            if (n > 1) {
                Range1D.Double xrange = this.xData.getRange1D();
                w = xrange.getXWidth();
                xrange.set(xrange.getXMin() - 0.05 * w, xrange.getXMax() + 0.05 * w);
                this.setXFullViewRange(xrange);
            } else if (n == 1) {
                double x = this.xData.pointAt(0);
                this.setXFullViewRange(new Range1D.Double(x - 50.0, x + 50.0));
            } else {
                this.setXFullViewRange(new Range1D.Double(0.0, 300.0));
            }
            if (n > 1) {
                Range1D.Double yrange = this.yData.getRange1D();
                yrange.set(Math.min(yrange.getXMin(), 0.0), Math.max(yrange.getXMax(), 0.0));
                w = yrange.getXWidth();
                if (yrange.getXMin() == 0.0) {
                    yrange.set(yrange.getXMin(), yrange.getXMax() + 0.05 * w);
                } else {
                    yrange.set(yrange.getXMin() - 0.05 * w, yrange.getXMax());
                }
                this.setYFullViewRange(yrange);
            } else {
                this.setYFullViewRange(new Range1D.Double(0.0, 100.0));
            }
        }
    }

    public Object clone() {
        Spectrum1D spectrum = null;
        spectrum = (Spectrum1D)super.clone();
        spectrum.setData((IOrderedDataArray1D)this.xData.clone(), (IDataArray1D)this.yData.clone());
        spectrum.copyPeakTable(this.peakTable);
        spectrum.copyPatternTable(this.patternTable);
        spectrum.copyAssignments(this.assignments);
        return spectrum;
    }

    protected void copyAssignments(Assignment[] assignments) {
        if (assignments == null) {
            this.assignments = null;
            return;
        }
        this.assignments = new Assignment[assignments.length];
        for (int i = 0; i < this.assignments.length; ++i) {
            this.assignments[i] = (Assignment)assignments[i].clone();
            this.assignments[i].setSpectrum(this);
        }
    }

    protected void copyPatternTable(Pattern[] patternTable) {
        if (patternTable == null) {
            this.patternTable = null;
            return;
        }
        this.patternTable = new Pattern[patternTable.length];
        for (int i = 0; i < patternTable.length; ++i) {
            this.patternTable[i] = (Pattern)patternTable[i].clone();
            this.patternTable[i].setSpectrum(this);
        }
    }

    protected void copyPeakTable(Peak1D[] peakTable) {
        if (peakTable == null) {
            this.peakTable = null;
            return;
        }
        this.peakTable = new Peak1D[peakTable.length];
        for (int i = 0; i < peakTable.length; ++i) {
            this.peakTable[i] = (Peak1D)peakTable[i].clone();
            this.peakTable[i].setSpectrum(this);
        }
    }

    private static int findLabelIndexNearestTo(ISpectrumLabel[] array, double pos) {
        class SearchKey
        implements ISpectrumLabel {
            double[] position = new double[1];

            SearchKey(double pos) {
                this.position[0] = pos;
            }

            public double[] getPosition() {
                return this.position;
            }

            public String getLabel() {
                return null;
            }

            public int compareTo(Object o) {
                double p0 = this.position[0];
                double p1 = ((ISpectrumLabel)o).getPosition()[0];
                if (p0 < p1) {
                    return -1;
                }
                if (p1 > p0) {
                    return 1;
                }
                return 0;
            }

            public void translate(double[] a) {
            }
        }
        SearchKey key = new SearchKey(pos);
        int index = Arrays.binarySearch(array, key);
        if (index < 0) {
            index = -index - 1;
        }
        if (index >= array.length) {
            return array.length - 1;
        }
        if (index <= 0) {
            return 0;
        }
        if (pos - array[index - 1].getPosition()[0] < array[index].getPosition()[0] - pos) {
            return index - 1;
        }
        return index;
    }

    public ISpectrumLabel findNearestLabel(ISpectrumLabel[] array, double pos) {
        int index = Spectrum1D.findLabelIndexNearestTo(array, pos);
        return array[index];
    }

    public Assignment getAssignmentNearestTo(double pos) {
        if (this.assignments == null) {
            return null;
        }
        return (Assignment)this.findNearestLabel(this.assignments, pos);
    }

    public Assignment[] getAssignments() {
        return this.assignments;
    }

    public Range2D.Double getDataRange() {
        return new Range2D.Double(this.xAxisMap.getDataRange(), this.yAxisMap.getDataRange());
    }

    public Range2D.Double getFullViewRange() {
        return new Range2D.Double(this.getXFullViewRange(), this.getYFullViewRange());
    }

    public Pattern getPatternNearestTo(double pos) {
        if (this.patternTable == null) {
            return null;
        }
        return (Pattern)this.findNearestLabel(this.patternTable, pos);
    }

    public Pattern[] getPatternTable() {
        return this.patternTable;
    }

    public Peak1D getPeakNearestTo(double pos) {
        if (this.peakTable == null) {
            return null;
        }
        return (Peak1D)this.findNearestLabel(this.peakTable, pos);
    }

    public Peak1D[] getPeakTable() {
        return this.peakTable;
    }

    public String getXAxisLabel() {
        if (this.xData != null) {
            return this.xData.getLabel();
        }
        return "";
    }

    public AxisMap getXAxisMap() {
        return this.xAxisMap;
    }

    public IOrderedDataArray1D getXData() {
        return this.xData;
    }

    public Range1D.Double getXFullViewRange() {
        return new Range1D.Double(this.xAxisMap.getFullViewRange());
    }

    public String getYAxisLabel() {
        if (this.yData != null) {
            return this.yData.getLabel();
        }
        return "";
    }

    public AxisMap getYAxisMap() {
        return this.yAxisMap;
    }

    public IDataArray1D getYData() {
        return this.yData;
    }

    public double getYDataAs16BitIntArray(int[] y) {
        int n = this.yData.getLength();
        double y0 = this.yData.pointAt(0);
        double y1 = this.yData.pointAt(n - 1);
        Range1D.Double yRange = this.yData.getRange1D();
        double yWidth = Math.max(yRange.getXMax(), -yRange.getXMin());
        double shortIntWidth = 32768.0;
        double yf = shortIntWidth / yWidth;
        for (int i = 0; i < n; ++i) {
            y[i] = (int)(this.yData.pointAt(i) * yf + 0.5);
        }
        return yf;
    }

    public double getYDataAs32BitIntArray(int[] y) {
        int n = this.yData.getLength();
        double y0 = this.yData.pointAt(0);
        double y1 = this.yData.pointAt(n - 1);
        Range1D.Double yRange = this.yData.getRange1D();
        double yWidth = Math.max(yRange.getXMax(), -yRange.getXMin());
        double shortIntWidth = -2.147483648E9;
        double yf = shortIntWidth / yWidth;
        for (int i = 0; i < n; ++i) {
            y[i] = (int)(this.yData.pointAt(i) * yf + 0.5);
        }
        return yf;
    }

    public Range1D.Double getYFullViewRange() {
        return new Range1D.Double(this.yAxisMap.getFullViewRange());
    }

    public boolean hasAssignments() {
        return this.assignments != null;
    }

    public boolean hasPatternTable() {
        return this.patternTable != null;
    }

    public boolean hasPeakTable() {
        return this.peakTable != null;
    }

    public boolean isFullSpectrum() {
        return this.fullSpectrum;
    }

    public void removeAssignmentAt(double pos) {
        if (this.assignments != null && this.assignments.length > 0) {
            int index = Spectrum1D.findLabelIndexNearestTo(this.assignments, pos);
            Assignment[] newTable = new Assignment[this.assignments.length - 1];
            System.arraycopy(this.assignments, 0, newTable, 0, index);
            System.arraycopy(this.assignments, index + 1, newTable, index, this.assignments.length - index - 1);
            this.setAssignments(newTable);
        }
    }

    public void removePatternAt(double pos) {
        if (this.patternTable != null && this.patternTable.length > 0) {
            int index = Spectrum1D.findLabelIndexNearestTo(this.patternTable, pos);
            Pattern[] newTable = new Pattern[this.patternTable.length - 1];
            System.arraycopy(this.patternTable, 0, newTable, 0, index);
            System.arraycopy(this.patternTable, index + 1, newTable, index, this.patternTable.length - index - 1);
            this.setPatternTable(newTable);
        }
    }

    public void removePeakAt(double pos) {
        if (this.peakTable != null && this.peakTable.length > 0) {
            int index = Spectrum1D.findLabelIndexNearestTo(this.peakTable, pos);
            Peak1D[] newTable = new Peak1D[this.peakTable.length - 1];
            System.arraycopy(this.peakTable, 0, newTable, 0, index);
            System.arraycopy(this.peakTable, index + 1, newTable, index, this.peakTable.length - index - 1);
            this.setPeakTable(newTable);
        }
    }

    public void setAssignments(Assignment[] newAssignments) {
        if (this.assignments != newAssignments) {
            this.assignments = newAssignments;
            if (this.assignments != null) {
                for (int i = 0; i < this.assignments.length; ++i) {
                    this.assignments[i].setSpectrum(this);
                }
                Arrays.sort(newAssignments);
            }
        }
    }

    public void setData(IOrderedDataArray1D x, IDataArray1D y) {
        this.xData = x;
        this.yData = y;
    }

    protected void setFullSpectrum(boolean newFullSpectrum) {
        this.fullSpectrum = newFullSpectrum;
    }

    public void setFullViewRange(Range2D.Double range) {
        this.setXFullViewRange(range.getXRange());
        this.setYFullViewRange(range.getYRange());
    }

    public void setPatternTable(Pattern[] newPatternTable) {
        if (newPatternTable != this.patternTable) {
            this.patternTable = newPatternTable;
            if (this.patternTable != null) {
                for (int i = 0; i < this.patternTable.length; ++i) {
                    this.patternTable[i].setSpectrum(this);
                }
            }
        }
    }

    public void setPeakTable(Peak1D[] newPeakTable) {
        if (newPeakTable != this.peakTable) {
            this.peakTable = newPeakTable;
            if (this.peakTable != null) {
                for (int i = 0; i < this.peakTable.length; ++i) {
                    this.peakTable[i].setSpectrum(this);
                }
            }
        }
    }

    private void setXData(IOrderedDataArray1D newXData) {
        this.xData = newXData;
    }

    public void setXFullViewRange(Range1D.Double dataRange) {
        this.xAxisMap = new LinearAxisMap(this.xData, dataRange);
    }

    private void setYData(IDataArray1D newYData) {
        this.yData = newYData;
    }

    public void setYFullViewRange(Range1D.Double dataRange) {
        this.yAxisMap = new LinearAxisMap(this.yData, dataRange);
    }

    static void sort(double[][] array) {
        int n = array[0].length;
        for (int i = 1; i < n; ++i) {
            double x = array[0][i];
            double y = array[1][i];
            for (int j = i; j > 0 && array[0][j - 1] > x; --j) {
                array[0][j] = array[0][j - 1];
                array[1][j] = array[1][j - 1];
            }
            array[0][j] = x;
            array[1][j] = y;
        }
    }

    public void translate(double amount) {
        int i;
        double[] tvec = new double[]{amount, 0.0};
        this.xData.translate(amount);
        if (this.peakTable != null) {
            for (i = 0; i < this.peakTable.length; ++i) {
                this.peakTable[i].translate(tvec);
            }
        }
        if (this.patternTable != null) {
            for (i = 0; i < this.patternTable.length; ++i) {
                this.patternTable[i].translate(tvec);
            }
        }
        if (this.assignments != null) {
            for (i = 0; i < this.assignments.length; ++i) {
                this.assignments[i].translate(tvec);
            }
        }
        this.adjustFullViewRange();
    }
}

