/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum.assignments;

import java.io.Serializable;
import org.jcamp.spectrum.IAssignmentTarget;

public class AtomReference
implements IAssignmentTarget,
Cloneable,
Serializable {
    private String structure = "unknown";
    private int atomNo;

    public AtomReference(String structure, int atomno) {
        this.structure = structure != null ? structure : "unknown";
        this.atomNo = atomno;
    }

    public Object clone() {
        AtomReference ref;
        try {
            ref = (AtomReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("something went wrong in clone");
        }
        ref.setAtomNumber(this.atomNo);
        ref.setStructure(this.structure);
        return ref;
    }

    public boolean equals(Object object) {
        if (object instanceof AtomReference) {
            AtomReference ref = (AtomReference)object;
            if (ref == this) {
                return true;
            }
            return ref.atomNo == this.atomNo && ref.structure.equals(this.structure);
        }
        return false;
    }

    public int getAtomNumber() {
        return this.atomNo;
    }

    public String getLabel() {
        return Integer.toString(this.atomNo);
    }

    public String getStructure() {
        return this.structure;
    }

    public int hashCode() {
        return this.atomNo ^ this.structure.hashCode();
    }

    public void setAtomNumber(int newAtomNo) {
        this.atomNo = newAtomNo;
    }

    public void setStructure(String newStructure) {
        this.structure = newStructure == null ? "unknown" : newStructure;
    }

    public String toString() {
        return this.structure + " <" + this.atomNo + ">";
    }
}

