/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum.notes;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.notes.DefaultNoteContentParser;
import org.jcamp.spectrum.notes.INoteContentParser;
import org.jcamp.spectrum.notes.UnitParser;
import org.jcamp.units.Unit;

public class NoteDescriptor
implements Cloneable,
Serializable {
    private static final INoteContentParser DEFAULT_NOTECONTENT_PARSER = DefaultNoteContentParser.getInstance();
    private Class fieldNoteContentClass = class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String;
    private INoteContentParser fieldNoteContentParser = DEFAULT_NOTECONTENT_PARSER;
    private Unit fieldUnit = null;
    private boolean fieldUnique = true;
    private boolean fieldDefault = false;
    private String fieldName = new String();
    private String fieldKey = new String();
    private static Hashtable notesDescriptors = new Hashtable();
    private String fieldParentKey = null;
    private int fieldDeniedMask = 0;
    private int fieldAllowedMask = -1;
    public static NoteDescriptor TITLE;
    public static NoteDescriptor OWNER;
    public static NoteDescriptor ORIGIN;
    public static NoteDescriptor JCAMPDX;
    public static NoteDescriptor IGNORE;
    public static InputStream is;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jcamp$spectrum$notes$NoteDescriptor;
    static /* synthetic */ Class class$org$jcamp$units$Unit;

    public NoteDescriptor(String key) {
        this(key, key);
    }

    public NoteDescriptor(String key, String name) {
        this(key, name, false);
    }

    private NoteDescriptor(String key, String name, Class noteClass, boolean isUnique, boolean isDefault) {
        this.setKey(key);
        this.setName(name);
        this.setNoteContentClass(noteClass);
        this.setUnique(isUnique);
        this.setDefault(isDefault);
        if (isDefault) {
            notesDescriptors.put(key, this);
        }
    }

    private NoteDescriptor(String key, String name, boolean isDefault) {
        this.setKey(key);
        this.setName(name);
        this.setDefault(isDefault);
        this.setUnique(true);
        if (isDefault) {
            notesDescriptors.put(key, this);
        }
    }

    public Object clone() {
        NoteDescriptor desc = null;
        try {
            desc = (NoteDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        desc.fieldUnit = (Unit)this.fieldUnit.clone();
        return desc;
    }

    private static int createSpectrumMask(String maskStr) {
        int mask = 0;
        int ALL = -1;
        StringTokenizer tokenizer = new StringTokenizer(maskStr, "|");
        while (tokenizer.hasMoreTokens()) {
            boolean notFlag = false;
            String token = tokenizer.nextToken();
            if (token.charAt(0) == '^') {
                notFlag = true;
                token = token.substring(1);
            }
            if (token.equalsIgnoreCase("ir")) {
                mask |= notFlag ? ALL ^ 2 : 2;
                continue;
            }
            if (token.equalsIgnoreCase("uv")) {
                mask |= notFlag ? ALL ^ 8 : 8;
                continue;
            }
            if (token.equalsIgnoreCase("ms")) {
                mask |= notFlag ? ALL ^ 0x40 : 64;
                continue;
            }
            if (token.equalsIgnoreCase("nmr")) {
                mask |= notFlag ? ALL ^ 0x20 : 32;
                continue;
            }
            if (token.equalsIgnoreCase("raman")) {
                mask |= notFlag ? ALL ^ 4 : 4;
                continue;
            }
            if (token.equalsIgnoreCase("flourescence")) {
                mask |= notFlag ? ALL ^ 0x10 : 16;
                continue;
            }
            if (token.equalsIgnoreCase("chromatogram")) {
                mask |= notFlag ? ALL ^ 0x20000 : 131072;
                continue;
            }
            if (token.equalsIgnoreCase("2d")) {
                mask |= notFlag ? ALL ^ 0x2000000 : 0x2000000;
                continue;
            }
            if (!token.equalsIgnoreCase("all")) continue;
            mask = notFlag ? 0 : ALL;
            break;
        }
        return mask;
    }

    public boolean equals(Object obj) {
        return obj instanceof NoteDescriptor && ((NoteDescriptor)obj).getKey().equals(this.fieldKey);
    }

    public static NoteDescriptor findByKey(String key) {
        return (NoteDescriptor)notesDescriptors.get(key);
    }

    public int getAllowedSpectrumMask() {
        return this.fieldAllowedMask;
    }

    public int getDeniedSpectrumMask() {
        return this.fieldDeniedMask;
    }

    public String getKey() {
        return this.fieldKey;
    }

    public String getName() {
        return this.fieldName;
    }

    public Class getNoteContentClass() {
        return this.fieldNoteContentClass;
    }

    public INoteContentParser getNoteContentParser() {
        return this.fieldNoteContentParser;
    }

    public String getParentKey() {
        return this.fieldParentKey;
    }

    public Unit getUnit() {
        return this.fieldUnit;
    }

    public int hashCode() {
        return this.fieldKey.hashCode();
    }

    private static void initDefaults() {
        TITLE = new NoteDescriptor("title", "Title", class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String, true, true);
        OWNER = new NoteDescriptor("owner", "Owner", class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String, true, true);
        ORIGIN = new NoteDescriptor("origin", "Origin", class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String, true, true);
        JCAMPDX = new NoteDescriptor("jcampdx", "JCAMP-DX Version", class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String, true, true);
        IGNORE = new NoteDescriptor("#IGNORE", "", class$java$lang$String == null ? (class$java$lang$String = NoteDescriptor.class$("java.lang.String")) : class$java$lang$String, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNoteDescriptors() {
        Properties notesProps = new Properties();
        is = null;
        try {
            UnitParser unitParser = new UnitParser();
            is = (class$org$jcamp$spectrum$notes$NoteDescriptor == null ? (class$org$jcamp$spectrum$notes$NoteDescriptor = NoteDescriptor.class$("org.jcamp.spectrum.notes.NoteDescriptor")) : class$org$jcamp$spectrum$notes$NoteDescriptor).getResourceAsStream("notes.properties");
            if (is == null) {
                return;
            }
            notesProps.load(is);
            Enumeration<?> notesNames = notesProps.propertyNames();
            while (notesNames.hasMoreElements()) {
                INoteContentParser parser;
                Class notesClass;
                String key = (String)notesNames.nextElement();
                if (key.indexOf(46) >= 0) continue;
                String displayName = (String)notesProps.get(key);
                String notesClassName = (String)notesProps.get(key + ".class");
                if (notesClassName == null) {
                    notesClass = class$java$lang$String == null ? NoteDescriptor.class$("java.lang.String") : class$java$lang$String;
                } else {
                    try {
                        notesClass = Class.forName(notesClassName);
                    }
                    catch (ClassNotFoundException e) {
                        notesClass = class$java$lang$String == null ? NoteDescriptor.class$("java.lang.String") : class$java$lang$String;
                    }
                }
                String parserClassName = (String)notesProps.get(key + ".parser");
                if (parserClassName == null) {
                    parser = DEFAULT_NOTECONTENT_PARSER;
                } else {
                    try {
                        parser = (INoteContentParser)Class.forName(parserClassName).newInstance();
                    }
                    catch (Exception e) {
                        parser = DEFAULT_NOTECONTENT_PARSER;
                    }
                }
                String uniqueStr = (String)notesProps.get(key + ".unique");
                boolean unique = true;
                if (uniqueStr != null) {
                    unique = Boolean.valueOf(uniqueStr);
                }
                String parentKey = (String)notesProps.get(key + ".parent");
                String allowedMaskStr = (String)notesProps.get(key + ".allowed");
                int allowedMask = -1;
                if (allowedMaskStr != null) {
                    allowedMask = NoteDescriptor.createSpectrumMask(allowedMaskStr);
                }
                String deniedMaskStr = (String)notesProps.get(key + ".denied");
                int deniedMask = 0;
                if (deniedMaskStr != null) {
                    deniedMask = NoteDescriptor.createSpectrumMask(deniedMaskStr);
                }
                Unit unit = null;
                String unitStr = (String)notesProps.get(key + ".unit");
                if (unitStr != null) {
                    unit = (Unit)unitParser.parseContent(unitStr, class$org$jcamp$units$Unit == null ? NoteDescriptor.class$("org.jcamp.units.Unit") : class$org$jcamp$units$Unit);
                }
                NoteDescriptor descr = new NoteDescriptor(key, displayName, notesClass, unique, true);
                descr.setNoteContentParser(parser);
                descr.setUnit(unit);
                descr.setParentKey(parentKey);
                descr.setAllowedSpectrumMask(allowedMask);
                descr.setDeniedSpectrumMask(deniedMask);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isAllowedForSpectrum(Spectrum spectrum) {
        return this.isAllowedForSpectrumID(spectrum.getIdentifier());
    }

    public boolean isAllowedForSpectrumID(int id) {
        if ((id & this.fieldAllowedMask) == 0) {
            return false;
        }
        return (id & this.fieldDeniedMask) != id;
    }

    public boolean isDefault() {
        return this.fieldDefault;
    }

    public boolean isGlobal() {
        return this.fieldAllowedMask == -1 && this.fieldDeniedMask == 0;
    }

    public boolean isUnique() {
        return this.fieldUnique;
    }

    public void setAllowedSpectrumMask(int spectrumMask) {
        this.fieldAllowedMask = spectrumMask;
    }

    private void setDefault(boolean isDefault) {
        this.fieldDefault = isDefault;
    }

    public void setDeniedSpectrumMask(int spectrumMask) {
        this.fieldDeniedMask = spectrumMask;
    }

    public void setKey(String key) {
        this.fieldKey = key;
    }

    public void setName(String name) {
        this.fieldName = name;
    }

    public void setNoteContentClass(Class noteClass) {
        this.fieldNoteContentClass = noteClass;
    }

    public void setNoteContentParser(INoteContentParser parser) {
        this.fieldNoteContentParser = parser;
    }

    public void setParentKey(String parentKey) {
        this.fieldParentKey = parentKey;
    }

    public void setUnique(boolean unique) {
        this.fieldUnique = unique;
    }

    public void setUnit(Unit unit) {
        this.fieldUnit = unit;
    }

    public String toString() {
        return this.getKey();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NoteDescriptor.initDefaults();
        NoteDescriptor.initNoteDescriptors();
    }
}

