/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public class AliasUnit
extends Unit {
    Unit unit;
    String aliasSymbol;
    String aliasName;

    public AliasUnit(Unit unit, String aliasName) {
        super(unit.getIdentifier());
        Unit.addAlias(unit, aliasName);
        this.unit = unit;
        this.aliasName = aliasName;
        this.aliasSymbol = unit.getSymbol();
    }

    public AliasUnit(Unit unit, String aliasName, String aliasSymbol) {
        super(unit.getIdentifier());
        Unit.addAlias(unit, aliasName);
        Unit.addAlias(unit, aliasSymbol);
        this.unit = unit;
        this.aliasName = aliasName;
        this.aliasSymbol = aliasSymbol;
    }

    public Object clone() {
        AliasUnit unit = (AliasUnit)super.clone();
        unit.unit = (Unit)this.unit.clone();
        return unit;
    }

    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        return this.unit.convertFrom(value, thatUnit);
    }

    public double convertTo(double value, Unit thatUnit) throws UnitException {
        return this.unit.convertTo(value, thatUnit);
    }

    public String getName() {
        return this.aliasName;
    }

    public String getQuantity() {
        return this.unit.getQuantity();
    }

    double getScaleFactor() {
        return this.unit.getScaleFactor();
    }

    public String getSymbol() {
        return this.aliasSymbol;
    }

    public boolean isConvertibleTo(Unit thatUnit) {
        return this.unit.isConvertibleTo(thatUnit);
    }
}

