/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.BaseUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public final class DimensionlessUnit
extends Unit {
    String quantity;
    String name;
    String symbol;

    public DimensionlessUnit(String quantity, String name, String symbol) {
        super(quantity, name);
        this.quantity = quantity;
        this.name = name;
        this.symbol = symbol;
    }

    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DimensionlessUnit || thatUnit.equals(BaseUnit.generic)) {
                return value;
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DimensionlessUnit || thatUnit.equals(BaseUnit.generic)) {
                return value;
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    public String getName() {
        return this.name;
    }

    public String getQuantity() {
        return this.quantity;
    }

    final double getScaleFactor() {
        return 1.0;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isConvertibleTo(Unit thatUnit) {
        return BaseUnit.generic.isConvertibleTo(thatUnit);
    }
}

