/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.BaseUnit;
import org.jcamp.units.DerivedUnit;
import org.jcamp.units.DimensionlessUnit;
import org.jcamp.units.SIUnitScale;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;
import org.jcamp.units.UnitScale;

public final class ScaledUnit
extends Unit {
    Unit unit;
    UnitScale scale;
    String name;
    String symbol;

    public Object clone() {
        ScaledUnit unit = (ScaledUnit)super.clone();
        unit.unit = (Unit)this.unit.clone();
        unit.scale = (UnitScale)this.scale.clone();
        return unit;
    }

    public ScaledUnit(BaseUnit unit, double factor, String name, String symbol) {
        this((Unit)unit, new UnitScale(factor), name, symbol);
    }

    public ScaledUnit(BaseUnit unit, SIUnitScale factor) {
        this((Unit)unit, factor);
    }

    public ScaledUnit(BaseUnit unit, UnitScale factor, String name, String symbol) {
        this((Unit)unit, factor, name, symbol);
    }

    public ScaledUnit(DerivedUnit unit, double factor, String name, String symbol) {
        this((Unit)unit, new UnitScale(factor), name, symbol);
    }

    public ScaledUnit(DerivedUnit unit, SIUnitScale factor) {
        this((Unit)unit, factor);
    }

    public ScaledUnit(DerivedUnit unit, UnitScale factor, String name, String symbol) {
        this((Unit)unit, factor, name, symbol);
    }

    public ScaledUnit(DimensionlessUnit unit, double factor, String name, String symbol) {
        this((Unit)unit, new UnitScale(factor), name, symbol);
    }

    ScaledUnit(Unit unit, SIUnitScale factor) {
        super(ScaledUnit.makeName(unit, factor), ScaledUnit.makeSymbol(unit, factor));
        this.unit = unit;
        this.scale = factor;
        this.name = ScaledUnit.makeName(unit, factor);
        this.symbol = ScaledUnit.makeSymbol(unit, factor);
    }

    ScaledUnit(Unit unit, UnitScale factor, String name, String symbol) {
        super(symbol, name);
        this.unit = unit;
        this.scale = factor;
        this.name = name;
        this.symbol = symbol;
    }

    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof ScaledUnit || thatUnit instanceof BaseUnit || thatUnit instanceof DerivedUnit) {
                return value * thatUnit.getScaleFactor() / this.getScaleFactor();
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof ScaledUnit || thatUnit instanceof BaseUnit || thatUnit instanceof DerivedUnit) {
                return value * this.getScaleFactor() / thatUnit.getScaleFactor();
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    public String getName() {
        return this.name;
    }

    public String getQuantity() {
        return this.unit.getQuantity();
    }

    public double getScaleFactor() {
        return this.scale.factor;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isConvertibleTo(Unit thatUnit) {
        if (thatUnit instanceof ScaledUnit) {
            return this.unit.isConvertibleTo(((ScaledUnit)thatUnit).unit);
        }
        if (thatUnit instanceof BaseUnit) {
            return this.unit.isConvertibleTo((BaseUnit)thatUnit);
        }
        if (thatUnit instanceof DerivedUnit) {
            return this.unit.isConvertibleTo((DerivedUnit)thatUnit);
        }
        return false;
    }

    private static String makeName(Unit unit, UnitScale scale) {
        if (scale.name != null && scale.name.length() > 0) {
            if (unit.equals(BaseUnit.kilogram)) {
                return scale.name + "gram";
            }
            return scale.name + unit.getName();
        }
        return unit.getName();
    }

    private static final String makeSymbol(Unit unit, UnitScale scale) {
        String id = unit.equals(BaseUnit.kilogram) ? "g" : unit.getSymbol();
        if (scale.prefix != null && scale.prefix.length() > 0) {
            return scale.prefix + id;
        }
        return id;
    }
}

