/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.data.io.input.AccessSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.io.output.IncrementalSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;

public class AccessSpreadSheetWriter
extends AbstractSpreadSheetWriter
implements AppendableSpreadSheetWriter,
IncrementalSpreadSheetWriter {
    private static final long serialVersionUID = -3549185519778801930L;
    protected Database.FileFormat m_FileFormat;
    protected String m_TableName;
    protected boolean m_Appending;
    protected SpreadSheet m_Header;
    protected boolean m_KeepExisting;
    protected boolean m_FileExists;
    protected transient Database m_Database;
    protected transient Table m_Table;
    protected HashMap<Integer, DataType> m_ColumnTypes;

    public String globalInfo() {
        return "Writes spreadsheet data to a MS Access database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file-format", "fileFormat", (Object)Database.FileFormat.V2010);
        this.m_OptionManager.add("table-name", "tableName", (Object)"");
        this.m_OptionManager.add("appending", "appending", (Object)false);
        this.m_OptionManager.add("keep-existing", "keepExisting", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_FileExists = false;
        this.m_Database = null;
        this.m_Table = null;
        this.m_ColumnTypes = new HashMap();
    }

    public void reset() {
        super.reset();
        this.m_Header = null;
        this.m_FileExists = false;
        this.m_Database = null;
        this.m_Table = null;
        this.m_ColumnTypes.clear();
    }

    public void setFileFormat(Database.FileFormat value) {
        this.m_FileFormat = value;
        this.reset();
    }

    public Database.FileFormat getFileFormat() {
        return this.m_FileFormat;
    }

    public String fileFormatTipText() {
        return "The MS Access file format to use when creating a new database.";
    }

    public void setTableName(String value) {
        this.m_TableName = value;
        this.reset();
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public String tableNameTipText() {
        return "The table name to use; if empty the spreadsheet's name is used.";
    }

    public boolean canAppend(SpreadSheet sheet) {
        if (this.m_Header == null) {
            return this.m_KeepExisting;
        }
        return this.m_Header.equalsHeader(sheet) == null;
    }

    public void setAppending(boolean value) {
        this.m_Appending = value;
        this.reset();
    }

    public boolean isAppending() {
        return this.m_Appending;
    }

    public String appendingTipText() {
        return "If enabled, multiple spreadsheets with the same structure can be written to the same file.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setFileExists(boolean value) {
        this.m_FileExists = value;
    }

    public boolean getFileExists() {
        return this.m_FileExists;
    }

    public String getFormatDescription() {
        return "Comma-separated values files";
    }

    public String[] getFormatExtensions() {
        return new String[]{"mdb", "accdb"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new AccessSpreadSheetReader();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.FILE;
    }

    protected String determineTableName(SpreadSheet sheet) {
        if (!this.m_TableName.isEmpty()) {
            return this.m_TableName;
        }
        return sheet.getName() == null ? Environment.getInstance().getProject() : sheet.getName();
    }

    protected boolean doWriteHeader(Row header, String filename) {
        boolean result = true;
        try {
            this.m_Database = !FileUtils.fileExists((String)filename) ? DatabaseBuilder.create((Database.FileFormat)this.m_FileFormat, (File)new File(filename)) : DatabaseBuilder.open((File)new File(filename));
            SpreadSheet sheet = header.getOwner();
            String name = this.determineTableName(sheet);
            this.m_ColumnTypes.clear();
            if (!this.m_Database.getTableNames().contains(sheet.getName())) {
                TableBuilder builder = new TableBuilder(name);
                for (int i = 0; i < sheet.getColumnCount(); ++i) {
                    DataType colType;
                    HashSet types = new HashSet(sheet.getContentTypes(i));
                    Cell.ContentType type = types.size() == 1 ? types.toArray(new Cell.ContentType[1])[0] : (types.size() > 0 && sheet.isNumeric(i) ? Cell.ContentType.DOUBLE : Cell.ContentType.STRING);
                    switch (type) {
                        case BOOLEAN: {
                            colType = DataType.BOOLEAN;
                            break;
                        }
                        case TIME: 
                        case DATE: 
                        case DATETIME: 
                        case DATETIMEMSEC: {
                            colType = DataType.SHORT_DATE_TIME;
                            break;
                        }
                        case DOUBLE: {
                            colType = DataType.DOUBLE;
                            break;
                        }
                        case LONG: {
                            colType = DataType.LONG;
                            break;
                        }
                        default: {
                            colType = DataType.TEXT;
                        }
                    }
                    this.m_ColumnTypes.put(i, colType);
                    builder.addColumn(new ColumnBuilder(sheet.getColumnName(i), colType));
                }
                this.m_Table = builder.toTable(this.m_Database);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed creating m_Table!", (Throwable)e);
        }
        return result;
    }

    protected boolean writeHeader(Row header, String filename) {
        boolean result = true;
        if (!(this.m_Header != null || this.m_FileExists && this.m_KeepExisting)) {
            result = this.doWriteHeader(header, filename);
            if (this.m_Appending) {
                this.m_Header = header.getOwner().getHeader();
            }
        }
        return result;
    }

    protected boolean doWrite(Row content, String filename) {
        boolean result = true;
        try {
            SpreadSheet sheet = content.getOwner();
            if (this.m_Table == null) {
                String name = this.determineTableName(sheet);
                this.m_Table = this.m_Database.getTable(name);
            }
            Object[] cells = new Object[sheet.getColumnCount()];
            block9: for (int i = 0; i < sheet.getColumnCount(); ++i) {
                Cell cell = content.getCell(sheet.getHeaderRow().getCellKey(i));
                cells[i] = null;
                if (cell == null || cell.getContent() == null || cell.isMissing()) continue;
                switch (this.m_ColumnTypes.get(i)) {
                    case BOOLEAN: {
                        cells[i] = cell.toBoolean();
                        continue block9;
                    }
                    case LONG: {
                        cells[i] = cell.toLong();
                        continue block9;
                    }
                    case DOUBLE: {
                        cells[i] = cell.toDouble();
                        continue block9;
                    }
                    case SHORT_DATE_TIME: {
                        cells[i] = cell.toAnyDateType();
                        continue block9;
                    }
                    case TEXT: {
                        cells[i] = cell.toString();
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled SQL column type: " + this.m_ColumnTypes.get(i));
                    }
                }
            }
            this.m_Table.addRow(cells);
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }

    protected boolean doWrite(SpreadSheet content, String filename) {
        this.m_Appending = true;
        boolean result = this.writeHeader((Row)content.getHeaderRow(), filename);
        for (DataRow row : content.rows()) {
            if (this.m_Stopped) {
                return false;
            }
            result = this.doWrite((Row)row, filename);
            if (result) continue;
            break;
        }
        return result;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean write(Row content, File file) {
        this.m_Appending = true;
        return this.write(content, file.getAbsolutePath());
    }

    public boolean write(Row content, String filename) {
        this.m_Appending = true;
        boolean result = this.writeHeader((Row)content.getOwner().getHeaderRow(), filename);
        if (result) {
            result = this.doWrite(content, filename);
        }
        return result;
    }

    public boolean write(Row content, OutputStream stream) {
        return false;
    }

    public boolean write(Row content, Writer writer) {
        return false;
    }
}

