/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderStandard;
import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderUnrolled_F32_F32;
import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderUnrolled_S16_I16;
import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderUnrolled_S16_I16_Div;
import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderUnrolled_U8_I16;
import boofcv.alg.filter.convolve.down.ConvolveDownNoBorderUnrolled_U8_I8_Div;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class ConvolveDownNoBorder {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        ConvolveDownNoBorder.checkParametersH(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_F32_F32.horizontal(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.horizontal(kernel, input, output, skip);
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        ConvolveDownNoBorder.checkParametersV(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_F32_F32.vertical(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.vertical(kernel, input, output, skip);
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        ConvolveDownNoBorder.checkParameters(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_F32_F32.convolve(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.convolve(kernel, input, output, skip);
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParametersH(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I16.horizontal(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.horizontal(kernel, input, output, skip);
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParametersV(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I16.vertical(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.vertical(kernel, input, output, skip);
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParameters(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I16.convolve(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.convolve(kernel, input, output, skip);
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParametersH(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16.horizontal(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.horizontal(kernel, input, output, skip);
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParametersV(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16.vertical(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.vertical(kernel, input, output, skip);
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        ConvolveDownNoBorder.checkParameters(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16.convolve(kernel, input, output, skip)) {
            ConvolveDownNoBorderStandard.convolve(kernel, input, output, skip);
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParametersH(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I8_Div.horizontal(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.horizontal(kernel, input, output, skip, divisor);
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParametersV(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I8_Div.vertical(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.vertical(kernel, input, output, skip, divisor);
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParameters(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_U8_I8_Div.convolve(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.convolve(kernel, input, output, skip, divisor);
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParametersH(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16_Div.horizontal(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.horizontal(kernel, input, output, skip, divisor);
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParametersV(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16_Div.vertical(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.vertical(kernel, input, output, skip, divisor);
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip, int divisor) {
        ConvolveDownNoBorder.checkParameters(input, output, skip);
        if (!ConvolveDownNoBorderUnrolled_S16_I16_Div.convolve(kernel, input, output, skip, divisor)) {
            ConvolveDownNoBorderStandard.convolve(kernel, input, output, skip, divisor);
        }
    }

    public static void checkParametersH(ImageSingleBand input, ImageSingleBand output, int skip) {
        if (skip <= 0) {
            throw new IllegalArgumentException("Skip must be >= 1");
        }
        if (output.width < input.width / skip) {
            throw new IllegalArgumentException("Output width is too small: output.width = " + output.width + " input.widht/skip " + input.width / skip);
        }
        if (output.height < input.height) {
            throw new IllegalArgumentException("Output height is too small");
        }
    }

    public static void checkParametersV(ImageSingleBand input, ImageSingleBand output, int skip) {
        if (skip <= 0) {
            throw new IllegalArgumentException("Skip must be >= 1");
        }
        if (output.width < input.width) {
            throw new IllegalArgumentException("Output width is too small: output.width = " + output.width + " input.widht/skip " + input.width / skip);
        }
        if (output.height < input.height / skip) {
            throw new IllegalArgumentException("Output height is too small");
        }
    }

    public static void checkParameters(ImageSingleBand input, ImageSingleBand output, int skip) {
        if (skip <= 0) {
            throw new IllegalArgumentException("Skip must be >= 1");
        }
        if (output.width < input.width / skip) {
            throw new IllegalArgumentException("Output width is too small: output.width = " + output.width + " input.widht/skip " + input.width / skip);
        }
        if (output.height < input.height / skip) {
            throw new IllegalArgumentException("Output height is too small");
        }
    }
}

