/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.kernel;

import boofcv.alg.filter.kernel.KernelMath;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;

public class GKernelMath {
    public static Kernel2D transpose(Kernel2D a) {
        if (a instanceof Kernel2D_F32) {
            return KernelMath.transpose((Kernel2D_F32)a);
        }
        return KernelMath.transpose((Kernel2D_I32)a);
    }

    public static Kernel1D convolve1D(Kernel1D a, Kernel1D b) {
        if (a.isInteger() != b.isInteger()) {
            throw new IllegalArgumentException("But input kernels must be of the same type.");
        }
        if (a.isInteger()) {
            throw new IllegalArgumentException("Add support");
        }
        return KernelMath.convolve1D((Kernel1D_F32)a, (Kernel1D_F32)b);
    }

    public static Kernel2D convolve(Kernel1D a, Kernel1D b) {
        if (a.isInteger() != b.isInteger()) {
            throw new IllegalArgumentException("But input kernels must be of the same type.");
        }
        if (a.isInteger()) {
            return KernelMath.convolve((Kernel1D_I32)a, (Kernel1D_I32)b);
        }
        return KernelMath.convolve((Kernel1D_F32)a, (Kernel1D_F32)b);
    }

    public static <T extends ImageSingleBand> T convertToImage(Kernel2D kernel) {
        if (kernel.isInteger()) {
            return (T)KernelMath.convertToImage((Kernel2D_I32)kernel);
        }
        return (T)KernelMath.convertToImage((Kernel2D_F32)kernel);
    }

    public static Kernel2D convertToKernel(ImageSingleBand image) {
        if (image.getDataType().isInteger()) {
            return KernelMath.convertToKernel((ImageInteger)image);
        }
        return KernelMath.convertToKernel((ImageFloat32)image);
    }
}

