/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedI16;

public class InterleavedS16
extends InterleavedI16 {
    public InterleavedS16(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedS16() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S16;
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    @Override
    public InterleavedS16 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedS16();
        }
        return new InterleavedS16(imgWidth, imgHeight, this.numBands);
    }
}

