/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta.thresholding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.InvalidDataException;
import mulan.classifier.ModelInitializationException;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public abstract class Meta
extends MultiLabelMetaLearner {
    protected Classifier classifier;
    protected Instances classifierInstances;
    protected String metaDatasetChoice;
    protected int kFoldsCV;
    protected MultiLabelLearner foldLearner;

    public Meta(MultiLabelLearner baseLearner, Classifier aClassifier, String aMetaDatasetChoice) {
        super(baseLearner);
        this.metaDatasetChoice = aMetaDatasetChoice;
        this.classifier = aClassifier;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    protected abstract Instances transformData(MultiLabelInstances var1) throws Exception;

    protected Instance modifiedInstanceX(Instance instance, String xBased) {
        Instance modifiedIns = null;
        MultiLabelOutput mlo = null;
        if (xBased.compareTo("Content-Based") == 0) {
            Instance tempInstance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
            modifiedIns = DataUtils.createInstance(tempInstance, tempInstance.weight(), tempInstance.toDoubleArray());
        } else if (xBased.compareTo("Score-Based") == 0) {
            try {
                mlo = this.baseLearner.makePrediction(instance);
            }
            catch (InvalidDataException ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ModelInitializationException ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
            double[] arrayOfScores = mlo.getConfidences();
            modifiedIns = DataUtils.createInstance(instance, this.numLabels);
            for (int i = 0; i < this.numLabels; ++i) {
                modifiedIns.setValue(i, arrayOfScores[i]);
            }
        } else {
            try {
                mlo = this.baseLearner.makePrediction(instance);
                double[] arrayOfScores = mlo.getConfidences();
                ArrayList<Double> list = new ArrayList<Double>();
                for (int i = 0; i < this.numLabels; ++i) {
                    list.add(arrayOfScores[i]);
                }
                Collections.sort(list);
                modifiedIns = DataUtils.createInstance(instance, this.numLabels);
                int j = this.numLabels - 1;
                for (Double x : list) {
                    modifiedIns.setValue(j, x.doubleValue());
                    --j;
                }
            }
            catch (InvalidDataException ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ModelInitializationException ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return modifiedIns;
    }

    protected Instances prepareClassifierInstances(MultiLabelInstances data) {
        Instances temp = null;
        if (this.metaDatasetChoice.compareTo("Content-Based") == 0) {
            try {
                temp = RemoveAllLabels.transformInstances(data);
                temp = new Instances(temp, 0);
            }
            catch (Exception ex) {
                Logger.getLogger(Meta.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < this.numLabels; ++i) {
                atts.add(new Attribute("Label" + i));
            }
            temp = new Instances("threshold", atts, 0);
        }
        return temp;
    }

    protected void valuesX(MultiLabelLearner learner, Instance instance, double[] newValues, String xBased) throws Exception {
        block4: {
            block5: {
                block3: {
                    if (this.metaDatasetChoice.compareTo("Content-Based") != 0) break block3;
                    double[] values = instance.toDoubleArray();
                    for (int i = 0; i < this.featureIndices.length; ++i) {
                        newValues[i] = values[this.featureIndices[i]];
                    }
                    break block4;
                }
                if (this.metaDatasetChoice.compareTo("Score-Based") != 0) break block5;
                MultiLabelOutput mlo = learner.makePrediction(instance);
                double[] values = mlo.getConfidences();
                System.arraycopy(values, 0, newValues, 0, values.length);
                break block4;
            }
            if (this.metaDatasetChoice.compareTo("Rank-Based") != 0) break block4;
            MultiLabelOutput mlo = learner.makePrediction(instance);
            double[] values = mlo.getConfidences();
            ArrayList<Double> list = new ArrayList<Double>();
            for (int i = 0; i < this.numLabels; ++i) {
                list.add(values[i]);
            }
            Collections.sort(list);
            int j = this.numLabels - 1;
            for (Double x : list) {
                newValues[j] = x;
                --j;
            }
        }
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingData) throws Exception {
        this.debug("building meta-model");
        this.classifierInstances = this.transformData(trainingData);
        this.classifier.buildClassifier(this.classifierInstances);
        this.classifierInstances = new Instances(this.classifierInstances, 0);
        this.debug("building the multi-label classifier");
        this.baseLearner.setDebug(this.getDebug());
        this.baseLearner.build(trainingData);
    }
}

