/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.evaluation.measure.ConfidenceMeasureBase;
import weka.classifiers.evaluation.NominalPrediction;
import weka.core.FastVector;

public abstract class LabelBasedAUC
extends ConfidenceMeasureBase {
    protected int numOfLabels;
    protected FastVector[] m_Predictions;
    protected FastVector all_Predictions;

    public LabelBasedAUC(int numOfLabels) {
        this.numOfLabels = numOfLabels;
        this.m_Predictions = new FastVector[numOfLabels];
        for (int labelIndex = 0; labelIndex < numOfLabels; ++labelIndex) {
            this.m_Predictions[labelIndex] = new FastVector();
        }
        this.all_Predictions = new FastVector();
    }

    @Override
    public void reset() {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            this.m_Predictions[labelIndex] = new FastVector();
        }
        this.all_Predictions = new FastVector();
    }

    @Override
    public double getIdealValue() {
        return 1.0;
    }

    @Override
    protected void updateConfidence(double[] confidences, boolean[] truth) {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            boolean actual = truth[labelIndex];
            boolean classValue = actual;
            double[] dist = new double[2];
            dist[1] = confidences[labelIndex];
            dist[0] = 1.0 - dist[1];
            this.m_Predictions[labelIndex].addElement((Object)new NominalPrediction((double)classValue, dist, 1.0));
            this.all_Predictions.addElement((Object)new NominalPrediction((double)classValue, dist, 1.0));
        }
    }
}

