/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.net.TwitterHelper;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractTweetReplay;
import adams.data.twitter.SimulatedStatus;
import twitter4j.Status;

public class FixedTweets
extends AbstractTweetReplay {
    private static final long serialVersionUID = -3432288686771377759L;
    protected BaseString[] m_Tweets;
    protected int m_Index;

    public String globalInfo() {
        return "Dummy replayer that just outputs tweets from manually set status texts.\nExtracts hashtags ('#...') and usermentions ('@...') automatically.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tweet", "tweets", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Index = 0;
    }

    public void setTweets(BaseString[] value) {
        this.m_Tweets = value;
        this.reset();
    }

    public BaseString[] getTweets() {
        return this.m_Tweets;
    }

    public String tweetsTipText() {
        return "The status texts to generate the tweets from.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"tweets", (Object)(this.m_Tweets.length + " tweet" + (this.m_Tweets.length == 1 ? "" : "s")));
    }

    @Override
    protected String doConfigure() {
        this.m_Index = 0;
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.m_Index < this.m_Tweets.length;
    }

    @Override
    public Status next() {
        if (this.m_Index >= this.m_Tweets.length) {
            return null;
        }
        SimulatedStatus result = new SimulatedStatus();
        result.setText(this.m_Tweets[this.m_Index].getValue());
        result.setHashtagEntities(TwitterHelper.extractHashtags(this.m_Tweets[this.m_Index].getValue()));
        result.setUserMentionEntities(TwitterHelper.extractUserMentions(this.m_Tweets[this.m_Index].getValue()));
        ++this.m_Index;
        return result;
    }
}

