/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoSupporter;
import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionTraverser;
import adams.core.option.OptionUtils;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorVariablesFinder;
import adams.flow.core.QueueHelper;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.output.RatOutput;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class AbstractRatOutput
extends AbstractOptionHandler
implements RatOutput,
ShallowCopySupporter<AbstractRatOutput>,
QuickInfoSupporter,
CleanUpHandler {
    private static final long serialVersionUID = -2633576389566678059L;
    protected Rat m_Owner;
    protected boolean m_Stopped;
    protected String m_LoggingPrefix;
    protected Object m_Input;
    protected HashSet<String> m_DetectedVariables;
    protected HashSet<String> m_DetectedObjectVariables;
    protected HashSet<String> m_VariablesUpdated;
    protected Hashtable<String, Object> m_BackupState;

    protected void initialize() {
        super.initialize();
        this.m_LoggingPrefix = "";
        this.m_DetectedVariables = null;
        this.m_DetectedObjectVariables = null;
        this.m_VariablesUpdated = new HashSet();
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger((String)this.m_LoggingPrefix);
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    @Override
    public String getFullName() {
        if (this.getOwner() != null) {
            return this.getOwner().getFullName() + "$" + this.getClass().getSimpleName();
        }
        return "???$" + this.getClass().getSimpleName();
    }

    protected void updatePrefix() {
        if (this.getOwner() != null) {
            this.m_LoggingPrefix = this.getFullName();
            this.m_Logger = null;
        }
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException((LoggingObject)this, (String)msg, (Throwable)t);
    }

    @Override
    public void setOwner(Rat value) {
        this.m_Owner = value;
        this.updatePrefix();
    }

    @Override
    public Rat getOwner() {
        return this.m_Owner;
    }

    public String getQuickInfo() {
        return null;
    }

    @Override
    public abstract Class[] accepts();

    @Override
    public boolean canInput() {
        return this.m_Input == null;
    }

    @Override
    public void input(Object obj) {
        this.m_Input = obj;
    }

    public Variables getVariables() {
        if (this.getOwner() != null) {
            return this.getOwner().getVariables();
        }
        return null;
    }

    protected HashSet<String> findVariables() {
        this.getLogger().finest("Locating variables in " + this.getFullName() + "...");
        ActorVariablesFinder finder = new ActorVariablesFinder();
        this.getOptionManager().traverse((OptionTraverser)finder);
        HashSet result = finder.getResult();
        this.getLogger().finest("Found variables in " + this.getFullName() + " (" + result.size() + "): " + result);
        return result;
    }

    protected void updateDetectedVariables() {
        this.getOptionManager().registerVariables();
        this.m_DetectedVariables = this.findVariables();
        this.m_DetectedObjectVariables = new HashSet();
        for (String var : this.m_DetectedVariables) {
            if (!this.getVariables().isObject(var)) continue;
            this.m_DetectedObjectVariables.add(var);
        }
        this.m_DetectedVariables.removeAll(this.m_DetectedObjectVariables);
        if (this.m_DetectedVariables.size() > 0) {
            this.getVariables().addVariableChangeListener((VariableChangeListener)this);
        }
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Owner == null) {
            result = "No owning actor set!";
        }
        if (result == null) {
            this.updatePrefix();
            this.updateDetectedVariables();
        }
        return result;
    }

    protected String check() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWait(int msec) {
        if (msec == 0) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("doWait: " + msec);
        }
        int count = 0;
        while (count < msec && !this.m_Stopped) {
            try {
                int current = msec - 100;
                if (current <= 0) {
                    current = msec;
                }
                if (current > 100) {
                    current = 100;
                }
                AbstractRatOutput abstractRatOutput = this;
                synchronized (abstractRatOutput) {
                    this.wait(current);
                }
                count += current;
            }
            catch (Exception exception) {}
        }
    }

    protected StorageQueueHandler getQueue(StorageName name) {
        return QueueHelper.getQueue((Actor)this.getOwner(), (StorageName)name);
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        if (this.m_DetectedVariables == null || this.m_DetectedVariables.size() == 0) {
            return;
        }
        if (this.m_VariablesUpdated.contains(e.getName())) {
            return;
        }
        if (this.m_DetectedVariables.contains(e.getName()) && e.getType() != VariableChangeEvent.Type.REMOVED) {
            this.m_VariablesUpdated.add(e.getName());
            this.getLogger().info("Changes in variable '" + e.getName() + "'");
        }
    }

    protected boolean isBackedUp(String key) {
        if (this.m_BackupState == null) {
            return false;
        }
        return this.m_BackupState.containsKey(key);
    }

    protected void pruneBackup(String key) {
        if (this.m_BackupState == null) {
            return;
        }
        if (!this.m_BackupState.containsKey(key)) {
            return;
        }
        this.m_BackupState.remove(key);
    }

    protected void pruneBackup() {
    }

    protected Hashtable<String, Object> backupState() {
        return new Hashtable<String, Object>();
    }

    protected void restoreState(Hashtable<String, Object> state) {
    }

    protected String updateVariables() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Attempting updating variables (" + this.getOptionManager().getVariables().hashCode() + "): " + this.m_VariablesUpdated + "/" + this.m_DetectedObjectVariables);
        }
        this.m_BackupState = this.backupState();
        Variables combined = this.getOptionManager().getVariables().getClone();
        combined.assign(this.getOwner().getInternalActor().getVariables());
        this.getOptionManager().setQuiet(true);
        this.getOptionManager().setVariables(combined);
        this.getOptionManager().updateVariablesInstance(combined);
        this.getOptionManager().updateVariableValues(true);
        this.getOptionManager().setQuiet(false);
        String result = this.setUp();
        if (result == null) {
            this.restoreState(this.m_BackupState);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Finished updating variables " + this.m_VariablesUpdated + "/" + this.m_DetectedObjectVariables + ": " + (result == null ? "successful" : result));
        }
        this.m_BackupState = null;
        this.m_VariablesUpdated.clear();
        return result;
    }

    protected abstract String doTransmit();

    @Override
    public String transmit() {
        this.m_Stopped = false;
        this.updateVariables();
        String result = this.check();
        if (result == null) {
            result = this.doTransmit();
            this.m_Input = null;
        }
        return result;
    }

    public AbstractRatOutput shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractRatOutput shallowCopy(boolean expand) {
        return (AbstractRatOutput)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    @Override
    public void stopExecution() {
        this.getOptionManager().deregisterVariables();
        if (this.m_DetectedVariables != null) {
            this.m_DetectedVariables.clear();
            this.m_DetectedVariables = null;
        }
        if (this.m_DetectedObjectVariables != null) {
            this.m_DetectedObjectVariables.clear();
            this.m_DetectedObjectVariables = null;
        }
        this.m_Stopped = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Stopped");
        }
    }

    @Override
    public boolean isStopped() {
        return this.m_Stopped;
    }

    public void cleanUp() {
        this.m_Input = null;
    }
}

