/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractMetaRatOutput;

public class OutputWithCallableTransformer
extends AbstractMetaRatOutput
implements CallableActorUser {
    private static final long serialVersionUID = -4073060833120998241L;
    protected CallableActorReference m_CallableName;
    protected AbstractActor m_CallableActor;
    protected CallableActorHelper m_Helper;

    public String globalInfo() {
        return "Meta-transmitter that passes the data through the callable transformer before forwarding it to the base-transmitter.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable transformer to use.";
    }

    public AbstractActor getCallableActor() {
        return this.m_CallableActor;
    }

    protected AbstractActor findCallableActor() {
        AbstractActor result = this.m_Helper.findCallableActorRecursive((AbstractActor)this.getOwner(), this.getCallableName());
        if (!ActorUtils.isTransformer((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a transformer" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
    }

    @Override
    public Class[] accepts() {
        if (this.m_CallableActor != null) {
            return ((InputConsumer)this.m_CallableActor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_CallableActor = this.findCallableActor();
            if (this.m_CallableActor == null) {
                result = "Failed to locate callable transformer '" + this.m_CallableName + "', check log!";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String preTransmit() {
        String result = super.preTransmit();
        if (result == null && !this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passing data through '" + this.m_CallableName + "'");
            }
            Token input = new Token(this.m_Input);
            this.m_Input = null;
            AbstractActor abstractActor = this.m_CallableActor;
            synchronized (abstractActor) {
                ((InputConsumer)this.m_CallableActor).input(input);
                result = this.m_CallableActor.execute();
                if (result == null && ((OutputProducer)this.m_CallableActor).hasPendingOutput()) {
                    Token output = ((OutputProducer)this.m_CallableActor).output();
                    if (output.getPayload() != null) {
                        this.m_Input = output.getPayload();
                    }
                    if (((OutputProducer)this.m_CallableActor).hasPendingOutput()) {
                        this.getLogger().warning("Only retrieved first output token!");
                    }
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passed data through '" + this.m_CallableName + "'");
            }
        }
        return result;
    }
}

