/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.IndexedBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.standalone.rats.output.RatOutput;

public class Switch
extends AbstractRatOutput {
    private static final long serialVersionUID = -3300963022239958581L;
    protected BooleanCondition[] m_Conditions;
    protected RatOutput[] m_Cases;

    public String globalInfo() {
        return "Forwards the input data to all defined sub-outputs ('sub-branches').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "conditions", (Object)new BooleanCondition[0]);
        this.m_OptionManager.add("case", "cases", (Object)new RatOutput[0]);
    }

    @Override
    public void setOwner(Rat value) {
        super.setOwner(value);
        for (RatOutput output : this.m_Cases) {
            output.setOwner(this.getOwner());
        }
    }

    public void setConditions(BooleanCondition[] value) {
        if (value.length > 1) {
            for (int i = 0; i < value.length; ++i) {
                if (!(value[i] instanceof IndexedBooleanCondition)) continue;
                this.getLogger().severe("When using " + IndexedBooleanCondition.class.getName() + " conditions, only a single one is allowed!");
                return;
            }
        }
        this.m_Conditions = value;
        this.reset();
    }

    public BooleanCondition[] getConditions() {
        return this.m_Conditions;
    }

    public String conditionsTipText() {
        return "The switch conditions to evaluate - the first condition that evaluates to 'true' triggers the execution of the corresponding 'case' actor.";
    }

    public void setCases(RatOutput[] value) {
        for (RatOutput output : this.m_Cases = value) {
            output.setOwner(this.getOwner());
        }
        this.reset();
    }

    public RatOutput[] getCases() {
        return this.m_Cases;
    }

    public String casesTipText() {
        return "The transmitters to send the data to.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Conditions.length != this.m_Cases.length) {
            result = "Number of conditions and cases differ: " + this.m_Conditions.length + " != " + this.m_Cases.length;
        }
        if (result == null) {
            for (int i = 0; i < this.m_Cases.length; ++i) {
                result = this.m_Cases[i].setUp();
                if (result == null) continue;
                result = "Case #" + (i + 1) + ": ";
                break;
            }
        }
        return result;
    }

    @Override
    protected String doTransmit() {
        String result = null;
        Token input = new Token(this.m_Input);
        for (int i = 0; i < this.m_Conditions.length; ++i) {
            if (this.m_Conditions[i].evaluate((Actor)this.getOwner(), input)) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Condition #" + (i + 1) + ": matches");
                }
                this.m_Cases[i].input(this.m_Input);
                result = this.m_Cases[i].transmit();
                if (result == null) break;
                result = "Case #" + (i + 1) + " failed with transmitting: " + result;
                break;
            }
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Condition #" + (i + 1) + ": does not match");
        }
        return result;
    }

    @Override
    public void stopExecution() {
        for (BooleanCondition cond : this.m_Conditions) {
            cond.stopExecution();
        }
        super.stopExecution();
    }
}

