/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.io.output.AbstractTextWriter;
import adams.data.io.output.NullWriter;
import adams.data.text.TextContainer;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class TextWriter
extends AbstractRatOutput {
    private static final long serialVersionUID = 5871927859523743161L;
    protected String m_ContentName;
    protected AbstractTextWriter m_Writer;

    public String globalInfo() {
        return "Writes incoming textual data to a text file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("content-name", "contentName", (Object)"");
        this.m_OptionManager.add("writer", "writer", (Object)new NullWriter());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer);
    }

    public void setContentName(String value) {
        this.m_ContentName = value;
        this.reset();
    }

    public String getContentName() {
        return this.m_ContentName;
    }

    public String contentNameTipText() {
        return "The name of the content, might be used in the filename of the output.";
    }

    public void setWriter(AbstractTextWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractTextWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for ouputting the textual data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, TextContainer.class};
    }

    @Override
    protected String doTransmit() {
        String result;
        try {
            result = null;
            if (this.m_Input instanceof TextContainer) {
                if (this.m_Writer.write((TextContainer)this.m_Input, this.m_ContentName) == null) {
                    result = "Error writing data: " + this.m_Writer.toCommandLine();
                }
            } else if (this.m_Writer.write(this.m_Input.toString(), this.m_ContentName) == null) {
                result = "Error writing data: " + this.m_Writer.toCommandLine();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to write data:", e);
        }
        return result;
    }
}

