/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.core.ConfidenceIntervalForecaster;
import weka.classifiers.timeseries.core.CustomPeriodicTest;
import weka.classifiers.timeseries.core.ErrorBasedConfidenceIntervalEstimator;
import weka.classifiers.timeseries.core.IncrementallyPrimeable;
import weka.classifiers.timeseries.core.OverlayForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.classifiers.timeseries.core.Utils;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.logging.Logger;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.RemoveType;

public class WekaForecaster
extends AbstractForecaster
implements TSLagUser,
ConfidenceIntervalForecaster,
OverlayForecaster,
IncrementallyPrimeable,
OptionHandler,
Serializable {
    private static final long serialVersionUID = 5562710925011828590L;
    protected Instances m_originalHeader;
    protected transient Instances m_primedInput;
    protected Instances m_transformedHeader;
    protected Classifier m_forecaster = new LinearRegression();
    protected List<SingleTargetForecaster> m_singleTargetForecasters;
    protected boolean m_modelBuilt = false;
    protected boolean m_useArtificialTimeIndex = false;
    protected ErrorBasedConfidenceIntervalEstimator m_confidenceLimitEstimator;
    protected int m_calculateConfLimitsSteps = 0;
    protected double m_confidenceLevel = 0.95;
    TSLagMaker m_lagMaker = new TSLagMaker();
    protected RemoveType m_dateRemover;
    protected List<Integer> m_missingTargetList;
    protected List<Integer> m_missingTimeStampList;
    protected List<String> m_missingTimeStampRows;
    protected Logger m_log;
    private transient Instance m_previousPrimeInstance = null;
    private transient Instances m_missingBuffer = null;
    private transient boolean m_hadLeadingMissingPrime = false;
    private transient boolean m_first = false;
    private transient boolean m_atLeastOneNonMissingTimeStamp = false;

    @Override
    public String getAlgorithmName() {
        if (this.m_forecaster != null) {
            String spec = this.getForecasterSpec();
            spec = spec.replace("weka.classifiers.", "");
            spec = spec.replace("functions.", "");
            spec = spec.replace("bayes.", "");
            spec = spec.replace("rules.", "");
            spec = spec.replace("trees.", "");
            spec = spec.replace("meta.", "");
            spec = spec.replace("lazy.", "");
            spec = spec.replace("supportVector.", "");
            return spec;
        }
        return "";
    }

    @Override
    public void setTSLagMaker(TSLagMaker lagMaker) {
        this.m_lagMaker = lagMaker;
    }

    @Override
    public TSLagMaker getTSLagMaker() {
        return this.m_lagMaker;
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tSet the fields to forecast.", "F", 1, "-F <comma separated list of names>"));
        newVector.add(new Option("\tSet the fields to be considered as overlay data.", "overlay", 1, "-overlay <comma separated list of names>"));
        newVector.add(new Option("\tSet the minimum lag length to generate.\n\t(default = 1)", "L", 1, "-L <num>"));
        newVector.add(new Option("\tSet the maximum lag length to generate.\n\t(default = 12)", "M", 1, "-M <num>"));
        newVector.add(new Option("\tFine tune selection of lags within min and max by specifying ranges", "R", 1, "-R <ranges>"));
        newVector.add(new Option("\tAverage consecutive long lags.", "A", 0, "-A"));
        newVector.add(new Option("\tAverage those lags longer than this number oftime steps.\n\tUse in conjuction with -A.\n\t(default = 2)", "B", 1, "-B <num>"));
        newVector.add(new Option("\tAverage this many consecutive long lags.\n\tUse in conjuction with -B (default = 2)", "C", 1, "-C <num>"));
        newVector.add(new Option("\tDon't adjust for trends.", "Z", 0, "-Z"));
        newVector.add(new Option("\tSpecify the name of the timestamp field", "G", 1, "-G <timestamp name>"));
        newVector.add(new Option("\tAdjust for variance.", "V", 0, "-V"));
        newVector.add(new Option("\tSpecify the primary periodic field, \n\tif one exists already in the data (e.g. day, month, quarter etc.\n\tIf there is more thanone such field, choose the one with the finest granularity.\n\tThis field must becyclic and declared as nominal.", "periodic", 1, "-periodic <field name>"));
        newVector.add(new Option("\tCalculate confidence limits for predictions\n\t(based on errors) for up to, and including, the specified\n\tnumber of time stepsinto the future\n\t(default = 0 (don't compute conf. levels)).", "conf", 1, "-conf <num steps>"));
        newVector.add(new Option("\tConfidence level for computing confidence limits.\n\tUse in conjunction with -conf.\n\t(default = 0.95).", "P", 1, "-P <confidence level>"));
        newVector.add(new Option("\tSpecify the base regression scheme to use.\n\tSupply a fully qualified name, along with options, enclosed in\n\tquotes (e.g. \"weka.classifiers.functions.SMOreg -R 0.5\").\n\t(default = weka.classifiers.functions.SMOreg)", "W", 1, "-W"));
        newVector.add(new Option("\tAdd an AM/PM indicator (requires a date timestamp)", "am-pm", 0, "-am-pm"));
        newVector.add(new Option("\tAdd a day of the week field (requres a date timestamp)", "day", 0, "-dayofweek"));
        newVector.add(new Option("\tAdd a day of the month field (requres a date timestamp)", "dayofmonth", 0, "-dayofmonth"));
        newVector.add(new Option("\tAdd a number of days in the month field (requres a date timestamp)", "numdaysinmonth", 0, "-numdaysinmonth"));
        newVector.add(new Option("\tAdd a weekend indicator (requires a date timestamp)", "weekend", 0, "-weekend"));
        newVector.add(new Option("\tAdd a month field (requires a date timestamp)", "month", 0, "-month"));
        newVector.add(new Option("\tAdd a quarter of the year field (requires a date timestamp)", "quarter", 0, "-quarter"));
        newVector.add(new Option("\tAdd a custom date-derived boolean field (requires a date timestamp).\n\tFormat: \"fieldName=Test Test|Test Test| ...\n\twhere Test = OPERATORyear:month:week-of-yr:week-of-month:day-of-yr:day-of-month:day-of-week:hour:min:second\n\te.g.XmasHoliday=>:dec::::24::: <:jan::::3:::\n\tLegal OPERATORs are =,>,<,>=,<=. For = operator only\n\tone Test is needed rather than a pair.\n\tThis option may be specified more than once on the command line\n\tin order to define multiple variables.", "custom", 1, "-custom"));
        newVector.add(new Option("\tAdd a comma-separated 'skip' list of dates that should not\n\tbe considered as a time step. Days of the week,\n\tmonths of the year, 'weekend', integers (indicating day of year\n\t, hour of day etc.) or specific dates are all valid entries.\n\tE.g sat,sun,27-08-2011,28-08-2011", "skip", 1, "-skip"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String[] classifierSpec;
        String baseClassifierS;
        String confLevel;
        String confSteps;
        String skipString;
        boolean dontAdjTrends;
        String consecutiveLongLagS;
        String maxL;
        String minL;
        String fieldsToForecast = weka.core.Utils.getOption((char)'F', (String[])options);
        if (fieldsToForecast.length() == 0) {
            throw new Exception("Must specify the name of at least one field to forecast!");
        }
        this.setFieldsToForecast(fieldsToForecast);
        String overlayFields = weka.core.Utils.getOption((String)"overlay", (String[])options);
        if (overlayFields.length() > 0) {
            this.setOverlayFields(overlayFields);
        }
        if ((minL = weka.core.Utils.getOption((char)'L', (String[])options)).length() > 0) {
            int mL = Integer.parseInt(minL);
            this.m_lagMaker.setMinLag(mL);
            if (mL < 1) {
                throw new Exception("Minimum lag can't be less than 1!");
            }
        }
        if ((maxL = weka.core.Utils.getOption((char)'M', (String[])options)).length() > 0) {
            int mL = Integer.parseInt(maxL);
            this.m_lagMaker.setMaxLag(mL);
        }
        if (this.m_lagMaker.getMaxLag() < this.m_lagMaker.getMinLag()) {
            throw new Exception("Can't have the maximum lag set lower than the minimum lag!");
        }
        String lagRange = weka.core.Utils.getOption((char)'R', (String[])options);
        if (lagRange.length() > 0) {
            this.m_lagMaker.setLagRange(lagRange);
        }
        boolean avLongLags = weka.core.Utils.getFlag((char)'A', (String[])options);
        this.m_lagMaker.setAverageConsecutiveLongLags(avLongLags);
        String avLongerThan = weka.core.Utils.getOption((char)'B', (String[])options);
        if (avLongerThan.length() > 0) {
            int avL = Integer.parseInt(avLongerThan);
            if (avL < this.m_lagMaker.getMinLag() || avL > this.m_lagMaker.getMaxLag()) {
                throw new Exception("Average consecutive long lags value can't be less than the minimum lag or greater than the maximum lag!");
            }
            this.m_lagMaker.setAverageLagsAfter(avL);
        }
        if ((consecutiveLongLagS = weka.core.Utils.getOption((char)'C', (String[])options)).length() > 0) {
            int consecutive = Integer.parseInt(consecutiveLongLagS);
            if (consecutive < 1 || consecutive > this.m_lagMaker.getMaxLag() - this.m_lagMaker.getAverageLagsAfter()) {
                throw new Exception("Number of consecutive long lags to average must be greater than 0 and less than " + (this.m_lagMaker.getMaxLag() - this.m_lagMaker.getMinLag()));
            }
            this.m_lagMaker.setNumConsecutiveLongLagsToAverage(consecutive);
        }
        this.m_lagMaker.setAdjustForTrends(!(dontAdjTrends = weka.core.Utils.getFlag((char)'Z', (String[])options)));
        boolean adjVariance = weka.core.Utils.getFlag((String)"V", (String[])options);
        this.m_lagMaker.setAdjustForVariance(adjVariance);
        String timeStampF = weka.core.Utils.getOption((char)'G', (String[])options);
        if (timeStampF.length() > 0) {
            this.m_lagMaker.setTimeStampField(timeStampF);
        }
        this.m_lagMaker.setAddAMIndicator(weka.core.Utils.getFlag((String)"am-pm", (String[])options));
        this.m_lagMaker.setAddDayOfWeek(weka.core.Utils.getFlag((String)"dayofweek", (String[])options));
        this.m_lagMaker.setAddWeekendIndicator(weka.core.Utils.getFlag((String)"weekend", (String[])options));
        this.m_lagMaker.setAddMonthOfYear(weka.core.Utils.getFlag((String)"month", (String[])options));
        this.m_lagMaker.setAddQuarterOfYear(weka.core.Utils.getFlag((String)"quarter", (String[])options));
        this.m_lagMaker.setAddDayOfMonth(weka.core.Utils.getFlag((String)"dayofmonth", (String[])options));
        this.m_lagMaker.setAddNumDaysInMonth(weka.core.Utils.getFlag((String)"numdaysinmonth", (String[])options));
        String customPeriodic = weka.core.Utils.getOption((String)"custom", (String[])options);
        while (customPeriodic.length() > 0) {
            this.m_lagMaker.addCustomPeriodic(customPeriodic);
        }
        String primaryPeriodicN = weka.core.Utils.getOption((String)"periodic", (String[])options);
        if (primaryPeriodicN.length() > 0) {
            this.m_lagMaker.setPrimaryPeriodicFieldName(primaryPeriodicN);
        }
        if ((skipString = weka.core.Utils.getOption((String)"skip", (String[])options)).length() > 0) {
            this.m_lagMaker.setSkipEntries(skipString);
        }
        if ((confSteps = weka.core.Utils.getOption((String)"conf", (String[])options)).length() > 0) {
            int numSteps = Integer.parseInt(confSteps);
            if (numSteps < 0) {
                throw new Exception("Number of steps must be >= 0");
            }
            this.setCalculateConfIntervalsForForecasts(numSteps);
        }
        if ((confLevel = weka.core.Utils.getOption((char)'P', (String[])options)).length() > 0) {
            double cL = Double.parseDouble(confLevel);
            if (cL < 0.0 || cL > 1.0) {
                throw new Exception("Confidence level must be between 0 and 1.");
            }
            this.setConfidenceLevel(cL);
        }
        if ((baseClassifierS = weka.core.Utils.getOption((char)'W', (String[])options)).length() == 0) {
            baseClassifierS = "weka.classifiers.functions.SMOreg";
        }
        if ((classifierSpec = weka.core.Utils.splitOptions((String)baseClassifierS)).length == 0) {
            throw new Exception("Invalid classifier specification.");
        }
        String classifierName = classifierSpec[0];
        classifierSpec[0] = "";
        this.setBaseForecaster(AbstractClassifier.forName((String)classifierName, (String[])classifierSpec));
    }

    public String[] getOptions() {
        Map<String, ArrayList<CustomPeriodicTest>> customPeriodics;
        ArrayList<String> options = new ArrayList<String>();
        options.add("-F");
        options.add(this.getFieldsToForecast());
        if (this.getOverlayFields() != null && this.getOverlayFields().length() > 0) {
            options.add("-O");
            options.add(this.getOverlayFields());
        }
        options.add("-L");
        options.add("" + this.m_lagMaker.getMinLag());
        options.add("-M");
        options.add("" + this.m_lagMaker.getMaxLag());
        if (this.m_lagMaker.getLagRange().length() > 0) {
            options.add("-R");
            options.add(this.m_lagMaker.getLagRange());
        }
        if (this.m_lagMaker.getAverageConsecutiveLongLags()) {
            options.add("-A");
        } else {
            options.add("-B");
            options.add("" + this.m_lagMaker.getAverageLagsAfter());
        }
        options.add("-C");
        options.add("" + this.m_lagMaker.getNumConsecutiveLongLagsToAverage());
        if (!this.m_lagMaker.getAdjustForTrends()) {
            options.add("-Z");
        }
        if (this.m_lagMaker.getAdjustForVariance()) {
            options.add("-V");
        }
        if (this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0) {
            options.add("-G");
            options.add(this.m_lagMaker.getTimeStampField());
        }
        if (this.m_lagMaker.getAddAMIndicator()) {
            options.add("-am-pm");
        }
        if (this.m_lagMaker.getAddDayOfWeek()) {
            options.add("-dayofweek");
        }
        if (this.m_lagMaker.getAddDayOfMonth()) {
            options.add("-dayofmonth");
        }
        if (this.m_lagMaker.getAddWeekendIndicator()) {
            options.add("-weekend");
        }
        if (this.m_lagMaker.getAddMonthOfYear()) {
            options.add("-month");
        }
        if (this.m_lagMaker.getAddNumDaysInMonth()) {
            options.add("-numdaysinmonth");
        }
        if (this.m_lagMaker.getAddQuarterOfYear()) {
            options.add("-quarter");
        }
        if ((customPeriodics = this.m_lagMaker.getCustomPeriodics()) != null && customPeriodics.keySet().size() > 0) {
            for (String name : customPeriodics.keySet()) {
                List tests = customPeriodics.get(name);
                options.add("-custom");
                StringBuffer tempBuff = new StringBuffer();
                tempBuff.append("\"");
                for (int i = 0; i < tests.size(); ++i) {
                    tempBuff.append(((CustomPeriodicTest)tests.get(i)).toString());
                    if (i < tests.size() - 1) {
                        tempBuff.append("|");
                        continue;
                    }
                    tempBuff.append("\"");
                }
                options.add(tempBuff.toString());
            }
        }
        if (this.m_lagMaker.getSkipEntries() != null && this.m_lagMaker.getSkipEntries().length() > 0) {
            options.add("-skip");
            options.add(this.m_lagMaker.getSkipEntries());
        }
        if (this.m_lagMaker.getPrimaryPeriodicFieldName() != null && this.m_lagMaker.getPrimaryPeriodicFieldName().length() > 0) {
            options.add("-periodic");
            options.add(this.m_lagMaker.getPrimaryPeriodicFieldName());
        }
        options.add("-conf");
        options.add("" + this.getCalculateConfIntervalsForForecasts());
        options.add("-P");
        options.add("" + this.getConfidenceLevel());
        options.add("-W");
        options.add(this.getForecasterSpec());
        return options.toArray(new String[1]);
    }

    protected String getForecasterSpec() {
        Classifier c = this.getBaseForecaster();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + weka.core.Utils.joinOptions((String[])((OptionHandler)c).getOptions());
        }
        return c.getClass().getName();
    }

    public void addCustomPeriodic(String customPeriodic) {
        this.m_lagMaker.addCustomPeriodic(customPeriodic);
    }

    public void clearCustomPeriodics() {
        this.m_lagMaker.clearCustomPeriodics();
    }

    @Override
    public void setFieldsToForecast(String fieldsToForecast) throws Exception {
        super.setFieldsToForecast(fieldsToForecast);
        this.m_lagMaker.setFieldsToLag(this.m_fieldsToForecast);
    }

    @Override
    public void setOverlayFields(String overlayFields) throws Exception {
        if (overlayFields == null) {
            this.m_lagMaker.setOverlayFields(null);
        } else {
            this.m_lagMaker.setOverlayFields(AbstractForecaster.stringToList(overlayFields));
        }
    }

    @Override
    public String getOverlayFields() {
        String list = "";
        List<String> overlayF = this.m_lagMaker.getOverlayFields();
        if (overlayF != null) {
            for (String f : overlayF) {
                list = list + f + ",";
            }
            list = list.substring(0, list.lastIndexOf(44));
        }
        return list;
    }

    @Override
    public void setCalculateConfIntervalsForForecasts(int steps) {
        this.m_calculateConfLimitsSteps = steps;
    }

    @Override
    public int getCalculateConfIntervalsForForecasts() {
        return this.m_calculateConfLimitsSteps;
    }

    @Override
    public boolean isProducingConfidenceIntervals() {
        return this.getCalculateConfIntervalsForForecasts() > 0;
    }

    @Override
    public void setConfidenceLevel(double confLevel) {
        this.m_confidenceLevel = confLevel;
    }

    @Override
    public double getConfidenceLevel() {
        return this.m_confidenceLevel;
    }

    public void setBaseForecaster(Classifier f) {
        this.m_forecaster = f;
    }

    public Classifier getBaseForecaster() {
        return this.m_forecaster;
    }

    @Override
    public boolean isUsingOverlayData() {
        return this.m_lagMaker.getOverlayFields() != null && this.m_lagMaker.getOverlayFields().size() > 0;
    }

    @Override
    public void reset() {
        this.m_modelBuilt = false;
        this.m_lagMaker.reset();
        this.m_dateRemover = null;
        this.m_primedInput = null;
        this.m_confidenceLimitEstimator = null;
        this.m_missingTargetList = new ArrayList<Integer>();
        this.m_missingTimeStampList = new ArrayList<Integer>();
        this.m_missingTimeStampRows = new ArrayList<String>();
    }

    @Override
    public void buildForecaster(Instances insts, PrintStream ... progress) throws Exception {
        this.reset();
        this.m_originalHeader = new Instances(insts, 0);
        insts = new Instances(insts);
        insts = Utils.replaceMissing(insts, this.m_fieldsToForecast, this.m_lagMaker.getTimeStampField(), false, this.m_lagMaker.getPeriodicity(), this.m_lagMaker.getSkipEntries(), this.m_missingTargetList, this.m_missingTimeStampList, this.m_missingTimeStampRows);
        for (PrintStream p : progress) {
            p.println("Transforming input data...");
        }
        Instances trainingData = insts;
        trainingData = this.m_lagMaker.getTransformedData(trainingData);
        this.m_transformedHeader = new Instances(trainingData, 0);
        this.m_dateRemover = new RemoveType();
        this.m_dateRemover.setOptions(new String[]{"-T", "date"});
        this.m_dateRemover.setInputFormat(trainingData);
        trainingData = Filter.useFilter((Instances)trainingData, (Filter)this.m_dateRemover);
        this.m_singleTargetForecasters = new ArrayList<SingleTargetForecaster>();
        for (int i = 0; i < this.m_fieldsToForecast.size(); ++i) {
            SingleTargetForecaster f = new SingleTargetForecaster();
            Classifier c = AbstractClassifier.makeCopy((Classifier)this.m_forecaster);
            f.setClassifier(c);
            f.buildForecaster(trainingData, (String)this.m_fieldsToForecast.get(i), new PrintStream[0]);
            this.m_singleTargetForecasters.add(f);
        }
        this.m_modelBuilt = true;
        if (this.m_calculateConfLimitsSteps > 0) {
            for (PrintStream p : progress) {
                p.println("Computing confidence intervals...");
            }
            int artificialTimeStart = this.m_lagMaker.isUsingAnArtificialTimeIndex() ? 1 : -1;
            ErrorBasedConfidenceIntervalEstimator e = new ErrorBasedConfidenceIntervalEstimator();
            e.calculateConfidenceOffsets((TSForecaster)this, insts, this.m_lagMaker.getMaxLag(), artificialTimeStart, this.m_calculateConfLimitsSteps, this.m_confidenceLevel, progress);
            this.m_confidenceLimitEstimator = e;
        }
    }

    public String toString() {
        int i;
        if (!this.m_modelBuilt) {
            return "Forecaster has not been built yet!";
        }
        StringBuffer result = new StringBuffer();
        result.append("Transformed training data:\n\n");
        for (i = 0; i < this.m_transformedHeader.numAttributes(); ++i) {
            result.append("              " + this.m_transformedHeader.attribute(i).name()).append("\n");
        }
        if (this.m_missingTimeStampRows != null && this.m_missingTimeStampRows.size() > 0) {
            result.append("\n--------------------------------------------------------\nInstances were inserted in the taining data for the\nfollowing time-stamps (target values set by interpolation):\n\n");
            for (i = 0; i < this.m_missingTimeStampRows.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTimeStampRows.get(i));
                    continue;
                }
                result.append(", " + this.m_missingTimeStampRows.get(i));
            }
            result.append("\n--------------------------------------------------------\n");
        }
        if (this.m_missingTargetList != null && this.m_missingTargetList.size() > 0) {
            Collections.sort(this.m_missingTargetList);
            result.append("\n---------------------------------------------------\nThe following training instances had missing values\nimputed via interpolation. Check source data as\nthis may affect forecasting performance:\n\n");
            for (i = 0; i < this.m_missingTargetList.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTargetList.get(i));
                    continue;
                }
                if (this.m_missingTargetList.get(i).equals(this.m_missingTargetList.get(i - 1))) continue;
                result.append("," + this.m_missingTargetList.get(i));
            }
            result.append("\n---------------------------------------------------\n");
        }
        if (this.m_missingTimeStampList != null && this.m_missingTimeStampList.size() > 0) {
            Collections.sort(this.m_missingTimeStampList);
            result.append("\n--------------------------------------------------------\nThe following training instances had missing time stamps:\n\n");
            for (i = 0; i < this.m_missingTimeStampList.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTimeStampList.get(i));
                    continue;
                }
                result.append("," + this.m_missingTimeStampList.get(i));
            }
            result.append("\n-------------------------------------------------------\n");
        }
        for (i = 0; i < this.m_singleTargetForecasters.size(); ++i) {
            result.append("\n" + this.m_singleTargetForecasters.get(i)).append("\n");
        }
        return result.toString();
    }

    protected Instance applyFilters(Instance source, boolean incrementArtificialTime, boolean setAnyPeriodic) throws Exception {
        Instance result = source;
        result = this.m_lagMaker.processInstance(result, incrementArtificialTime, setAnyPeriodic);
        return result;
    }

    @Override
    public void primeForecaster(Instances insts) throws Exception {
        this.m_primedInput = new Instances(insts);
        this.m_previousPrimeInstance = null;
        this.m_missingBuffer = new Instances(insts, 0);
        this.m_hadLeadingMissingPrime = false;
        this.m_first = true;
        this.m_atLeastOneNonMissingTimeStamp = false;
        this.m_lagMaker.clearLagHistories();
        for (int i = 0; i < this.m_primedInput.numInstances(); ++i) {
            this.primeForecasterIncremental(this.m_primedInput.instance(i));
            this.m_first = false;
        }
    }

    @Override
    public void primeForecasterIncremental(Instance inst) throws Exception {
        if (this.m_primedInput == null) {
            throw new Exception("WekaForecaster hasn't been initialized with a call to primeForecaster()!!");
        }
        if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0 && !this.m_first && this.m_previousPrimeInstance != null && !this.m_previousPrimeInstance.isMissing(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()))) {
            double previous = this.m_previousPrimeInstance.value(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()));
            double current = inst.value(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()));
            if (current <= previous) {
                throw new Exception("Priming instances do not appear to be in ascending order of the time stamp field (" + this.m_lagMaker.getTimeStampField() + ")! " + this.m_previousPrimeInstance + " : " + inst);
            }
        }
        boolean wasBuffered = false;
        boolean onlyTimeMissing = false;
        if (inst.hasMissingValue()) {
            boolean ok = true;
            for (String target : this.m_fieldsToForecast) {
                if (!inst.isMissing(inst.dataset().attribute(target))) continue;
                ok = false;
                break;
            }
            if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0) {
                if (inst.isMissing(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()))) {
                    onlyTimeMissing = ok;
                    if (this.m_previousPrimeInstance != null && !this.m_previousPrimeInstance.isMissing(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()))) {
                        double newValue = this.m_previousPrimeInstance.value(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()));
                        newValue = this.m_lagMaker.advanceSuppliedTimeValue(newValue);
                        inst.setValue(inst.dataset().attribute(this.m_lagMaker.getTimeStampField()), newValue);
                    }
                } else {
                    this.m_atLeastOneNonMissingTimeStamp = true;
                }
            }
            if (!ok) {
                if (this.m_first) {
                    this.m_hadLeadingMissingPrime = !onlyTimeMissing;
                    this.m_missingBuffer.add(inst);
                    wasBuffered = true;
                } else {
                    this.m_missingBuffer.add(inst);
                    wasBuffered = true;
                }
            }
        } else if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0) {
            this.m_atLeastOneNonMissingTimeStamp = true;
        }
        this.m_previousPrimeInstance = inst;
        if (!wasBuffered && this.m_missingBuffer.numInstances() > 0) {
            this.m_missingBuffer.add(inst);
            wasBuffered = true;
            Instances missingReplaced = Utils.replaceMissing(this.m_missingBuffer, this.m_fieldsToForecast, this.m_lagMaker.getTimeStampField(), false, this.m_lagMaker.getPeriodicity(), this.m_lagMaker.getSkipEntries(), new Object[0]);
            for (int i = 0; i < missingReplaced.numInstances(); ++i) {
                this.applyFilters(missingReplaced.instance(i), false, false);
            }
            this.m_missingBuffer = new Instances(this.m_primedInput, 0);
        } else if (!wasBuffered) {
            this.applyFilters(inst, false, false);
        }
        this.m_first = false;
    }

    protected double forecastOneStepAhead(Instance transformed) throws Exception {
        return this.m_forecaster.classifyInstance(transformed);
    }

    @Override
    public List<List<NumericPrediction>> forecast(int numSteps, PrintStream ... progress) throws Exception {
        return this.forecast(numSteps, (Instances)null, progress);
    }

    @Override
    public List<List<NumericPrediction>> forecast(int numSteps, Instances overlay, PrintStream ... progress) throws Exception {
        if (overlay != null) {
            if (this.m_lagMaker.getOverlayFields() == null || this.m_lagMaker.getOverlayFields().size() == 0) {
                throw new Exception("[WekaForecaster] overlay data has been supplied to the forecasting routine but no overlay data has been trained with.");
            }
            String message = this.m_originalHeader.equalHeadersMsg(overlay);
            if (message != null) {
                throw new Exception("[WekaForecaster] supplied overlay data does not have the same structure as the data used to learn the model!");
            }
        } else if (this.m_lagMaker.getOverlayFields() != null && this.m_lagMaker.getOverlayFields().size() > 0) {
            throw new Exception("[WekaForecaster] was trained with overlay data but none has been supplied for making a forecast!");
        }
        if (this.m_missingBuffer != null && this.m_missingBuffer.numInstances() > 0) {
            System.err.println("Here..... \n\n" + this.m_missingBuffer);
            Instances missingReplaced = Utils.replaceMissing(this.m_missingBuffer, this.m_fieldsToForecast, this.m_lagMaker.getTimeStampField(), false, this.m_lagMaker.getPeriodicity(), this.m_lagMaker.getSkipEntries(), new Object[0]);
            for (int i = 0; i < this.m_missingBuffer.numInstances(); ++i) {
                this.applyFilters(missingReplaced.instance(i), false, false);
            }
            for (PrintStream p : progress) {
                p.println("WARNING: priming data contained missing target/date values that could not be interpolated/replaced. Forecasting performance may be adversely affected.");
            }
        }
        if (this.m_hadLeadingMissingPrime) {
            for (PrintStream p : progress) {
                p.println("WARNING: priming data contained missing target/date values that could not be interpolated/replaced. Forecasting performance may be adversely affected.");
            }
        }
        if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0 && !this.m_atLeastOneNonMissingTimeStamp) {
            throw new Exception("All values of the time stamp field (" + this.m_lagMaker.getTimeStampField() + ") were missing in the priming " + "data!");
        }
        ArrayList<List<NumericPrediction>> forecastForSteps = new ArrayList<List<NumericPrediction>>();
        int stepsToDo = overlay != null ? overlay.numInstances() : numSteps;
        boolean setPeriodics = true;
        boolean incrementTime = true;
        for (int i = 0; i < stepsToDo; ++i) {
            int j;
            incrementTime = true;
            double[] newVals = new double[this.m_originalHeader.numAttributes()];
            for (int j2 = 0; j2 < newVals.length; ++j2) {
                newVals[j2] = weka.core.Utils.missingValue();
            }
            if (overlay != null) {
                int timeStampIndex;
                Instance overlayI = overlay.instance(i);
                for (String field : this.m_lagMaker.getOverlayFields()) {
                    int index = this.m_originalHeader.attribute(field).index();
                    newVals[index] = overlayI.value(index);
                }
                if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0 && !overlayI.isMissing(timeStampIndex = this.m_originalHeader.attribute(this.m_lagMaker.getTimeStampField()).index())) {
                    newVals[timeStampIndex] = overlayI.value(timeStampIndex);
                    incrementTime = false;
                }
            }
            DenseInstance origTest = new DenseInstance(1.0, newVals);
            origTest.setDataset(this.m_originalHeader);
            DenseInstance transformedWithDate = origTest;
            transformedWithDate = this.m_lagMaker.processInstancePreview((Instance)transformedWithDate, incrementTime, setPeriodics);
            this.m_dateRemover.input((Instance)transformedWithDate);
            Instance transformed = this.m_dateRemover.output();
            double[] preds = new double[this.m_singleTargetForecasters.size()];
            for (int j3 = 0; j3 < this.m_singleTargetForecasters.size(); ++j3) {
                preds[j3] = this.m_singleTargetForecasters.get(j3).forecastOneStepAhead(transformed);
            }
            ArrayList<NumericPrediction> finalForecast = new ArrayList<NumericPrediction>();
            for (j = 0; j < this.m_fieldsToForecast.size(); ++j) {
                if (this.m_confidenceLimitEstimator != null && i < this.m_calculateConfLimitsSteps) {
                    double[] limits = this.m_confidenceLimitEstimator.getConfidenceLimitsForTarget((String)this.m_fieldsToForecast.get(j), preds[j], i + 1);
                    double[][] limitsToAdd = new double[][]{limits};
                    finalForecast.add(new NumericPrediction(weka.core.Utils.missingValue(), preds[j], 1.0, (double[][])limitsToAdd));
                    continue;
                }
                finalForecast.add(new NumericPrediction(weka.core.Utils.missingValue(), preds[j]));
            }
            forecastForSteps.add(finalForecast);
            for (j = 0; j < this.m_fieldsToForecast.size(); ++j) {
                int targetIndex = this.m_originalHeader.attribute((String)this.m_fieldsToForecast.get(j)).index();
                origTest.setValue(targetIndex, preds[j]);
            }
            if (!this.m_lagMaker.isUsingAnArtificialTimeIndex() && this.m_lagMaker.getAdjustForTrends() && this.m_lagMaker.getTimeStampField() != null && this.m_lagMaker.getTimeStampField().length() > 0) {
                int timeIndex = this.m_originalHeader.attribute(this.m_lagMaker.getTimeStampField()).index();
                double timeValue = transformedWithDate.value(transformedWithDate.dataset().attribute(this.m_lagMaker.getTimeStampField()));
                origTest.setValue(timeIndex, timeValue);
            }
            this.primeForecasterIncremental((Instance)origTest);
        }
        if (this.m_lagMaker.isUsingAnArtificialTimeIndex()) {
            this.m_lagMaker.incrementArtificialTimeValue(-(stepsToDo - 1));
        }
        this.m_primedInput = null;
        return forecastForSteps;
    }

    public static void main(String[] args) {
        try {
            WekaForecaster fs = new WekaForecaster();
            fs.runForecaster(fs, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class SingleTargetForecaster
    implements Serializable {
        private static final long serialVersionUID = -4404412501006669036L;
        protected Classifier m_targetForecaster;
        private Remove m_otherTargetRemover;
        private int m_classIndex;
        private String m_className;

        protected SingleTargetForecaster() {
        }

        public void setClassifier(Classifier classifier) {
            this.m_targetForecaster = classifier;
        }

        public void buildForecaster(Instances train, String targetName, PrintStream ... progress) throws Exception {
            if (this.m_targetForecaster == null) {
                throw new Exception("[SingleTargetForecaster] base classifier has not been set!");
            }
            train = new Instances(train);
            this.m_classIndex = train.attribute(targetName).index();
            if (this.m_classIndex < 0) {
                throw new Exception("Can't find target field '" + targetName + "' in" + "the data!");
            }
            if (!train.attribute(this.m_classIndex).isNumeric()) {
                throw new Exception("[SingleTargetForecaster] target '" + targetName + "' is not numeric!");
            }
            train.setClassIndex(this.m_classIndex);
            this.m_className = targetName;
            String otherTargets = "";
            for (String n : WekaForecaster.this.m_fieldsToForecast) {
                int i;
                if (n.equals(targetName) || (i = train.attribute(n).index()) < 0) continue;
                otherTargets = otherTargets + (i + 1) + ",";
            }
            if (otherTargets.length() > 0) {
                otherTargets = otherTargets.substring(0, otherTargets.lastIndexOf(44));
                this.m_otherTargetRemover = new Remove();
                this.m_otherTargetRemover.setAttributeIndices(otherTargets);
                this.m_otherTargetRemover.setInputFormat(train);
                train = Filter.useFilter((Instances)train, (Filter)this.m_otherTargetRemover);
            }
            for (PrintStream p : progress) {
                p.println("Building forecaster for target: " + this.m_className);
            }
            this.m_targetForecaster.buildClassifier(train);
        }

        public double forecastOneStepAhead(Instance transformed) throws Exception {
            transformed.dataset().setClassIndex(this.m_classIndex);
            if (this.m_otherTargetRemover != null) {
                this.m_otherTargetRemover.input(transformed);
                transformed = this.m_otherTargetRemover.output();
            }
            double pred = this.m_targetForecaster.classifyInstance(transformed);
            if (WekaForecaster.this.m_lagMaker.getAdjustForVariance()) {
                pred = Math.exp(pred);
            }
            return pred;
        }

        public String toString() {
            if (this.m_targetForecaster == null) {
                return "SingleTargetForecaster: no model built yet!";
            }
            return this.m_className + ":\n" + this.m_targetForecaster.toString();
        }
    }
}

