/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.core;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CustomPeriodicTest
implements Serializable {
    private static final long serialVersionUID = -1470297629040276248L;
    protected TestPart m_upperTest;
    protected TestPart m_lowerTest;
    protected String m_label;

    public CustomPeriodicTest(String theTest) throws IllegalArgumentException {
        this.setTest(theTest);
    }

    public TestPart getLowerTest() {
        return this.m_lowerTest;
    }

    public TestPart getUpperTest() {
        return this.m_upperTest;
    }

    public void setTest(String theTest) throws IllegalArgumentException {
        if ((theTest = theTest.trim()).indexOf(32) > 0) {
            String[] parts = theTest.split(" ");
            this.m_lowerTest = this.parseTest(parts[0]);
            this.m_upperTest = this.parseTest(parts[1]);
            this.m_upperTest.setIsUpper(true);
            if (this.m_upperTest.m_boundOperator == this.m_lowerTest.m_boundOperator) {
                throw new IllegalArgumentException("Doesn't make sense to define an upper and lower test that uses the same operator");
            }
        } else {
            this.m_lowerTest = this.parseTest(theTest);
        }
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public boolean evaluate(Date d) {
        boolean result = this.m_lowerTest.eval(d, this.m_upperTest);
        if (this.m_upperTest != null && this.m_lowerTest.m_boundOperator != Operator.EQUALS) {
            result = result && this.m_upperTest.eval(d, this.m_lowerTest);
        }
        return result;
    }

    private int parseDay(String day) throws IllegalArgumentException {
        try {
            int result = Integer.parseInt(day);
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            day = day.toLowerCase();
            if (day.equals("sunday") || day.equals("sun")) {
                return 1;
            }
            if (day.equals("monday") || day.equals("mon")) {
                return 2;
            }
            if (day.equals("tuesday") || day.equals("tue")) {
                return 3;
            }
            if (day.equals("wednesday") || day.equals("wed")) {
                return 4;
            }
            if (day.equals("thursday") || day.equals("thu")) {
                return 5;
            }
            if (day.equals("friday") || day.equals("fri")) {
                return 6;
            }
            if (day.equals("saturday") || day.equals("sat")) {
                return 7;
            }
            if (day.equals("*")) {
                return -100;
            }
            throw new IllegalArgumentException("Can't parse month!");
        }
    }

    private int parseMonth(String month) throws IllegalArgumentException {
        try {
            int result = Integer.parseInt(month);
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            month = month.toLowerCase();
            if (month.equals("january") || month.equals("jan")) {
                return 0;
            }
            if (month.equals("february") || month.equals("feb")) {
                return 1;
            }
            if (month.equals("march") || month.equals("mar")) {
                return 2;
            }
            if (month.equals("april") || month.equals("apr")) {
                return 3;
            }
            if (month.equals("may")) {
                return 4;
            }
            if (month.equals("june") || month.equals("jun")) {
                return 5;
            }
            if (month.equals("july") || month.equals("jul")) {
                return 6;
            }
            if (month.equals("august") || month.equals("aug")) {
                return 7;
            }
            if (month.equals("september") || month.equals("sep")) {
                return 8;
            }
            if (month.equals("october") || month.equals("oct")) {
                return 9;
            }
            if (month.equals("november") || month.equals("nov")) {
                return 10;
            }
            if (month.equals("december") || month.equals("dec")) {
                return 11;
            }
            if (month.equals("*")) {
                return -100;
            }
            throw new IllegalArgumentException("Can't parse month!");
        }
    }

    protected TestPart parseTest(String aTest) throws IllegalArgumentException {
        if (aTest.indexOf(47) > 0) {
            String[] parts = aTest.split("/");
            aTest = parts[0].trim();
            this.m_label = parts[1].trim();
        }
        aTest = aTest.trim();
        TestPart newTest = new TestPart();
        if (aTest.charAt(0) == '=') {
            newTest.m_boundOperator = Operator.EQUALS;
            aTest = aTest.substring(1, aTest.length());
        } else if (aTest.charAt(0) == '>') {
            newTest.m_boundOperator = Operator.GREATER_THAN;
            if ((aTest = aTest.substring(1, aTest.length())).charAt(0) == '=') {
                newTest.m_boundOperator = Operator.GREATER_THAN_OR_EQUAL_TO;
                aTest = aTest.substring(1, aTest.length());
            }
        } else if (aTest.charAt(0) == '<') {
            newTest.m_boundOperator = Operator.LESS_THAN;
            if ((aTest = aTest.substring(1, aTest.length())).charAt(0) == '=') {
                newTest.m_boundOperator = Operator.LESS_THAN_OR_EQUAL_TO;
                aTest = aTest.substring(1, aTest.length());
            }
        }
        String[] parts = aTest.split(":");
        if (parts.length != 10) {
            throw new IllegalArgumentException("Test does not contain 10 parts!");
        }
        if (parts[0].trim().length() > 0 && parts[0].charAt(0) != '*') {
            newTest.m_year = Integer.parseInt(parts[0].trim());
        }
        if (parts[1].trim().length() > 0 && parts[1].charAt(0) != '*') {
            newTest.m_month = this.parseMonth(parts[1].trim());
        }
        if (parts[2].trim().length() > 0 && parts[2].charAt(0) != '*') {
            newTest.m_week_of_yr = Integer.parseInt(parts[2].trim());
        }
        if (parts[3].trim().length() > 0 && parts[3].charAt(0) != '*') {
            newTest.m_week_of_month = Integer.parseInt(parts[3].trim());
        }
        if (parts[4].trim().length() > 0 && parts[4].charAt(0) != '*') {
            newTest.m_day_of_yr = Integer.parseInt(parts[4].trim());
        }
        if (parts[5].trim().length() > 0 && parts[5].charAt(0) != '*') {
            newTest.m_day_of_month = Integer.parseInt(parts[5].trim());
        }
        if (parts[6].trim().length() > 0 && parts[6].charAt(0) != '*') {
            newTest.m_day_of_week = this.parseDay(parts[6].trim());
        }
        if (parts[7].trim().length() > 0 && parts[7].charAt(0) != '*') {
            newTest.m_hour_of_day = Integer.parseInt(parts[7].trim());
        }
        if (parts[8].trim().length() > 0 && parts[8].charAt(0) != '*') {
            newTest.m_min_of_hour = Integer.parseInt(parts[8].trim());
        }
        if (parts[9].trim().length() > 0 && parts[9].charAt(0) != '*') {
            newTest.m_second = Integer.parseInt(parts[9].trim());
        }
        return newTest;
    }

    public String toString() {
        String result = this.m_lowerTest.toString();
        if (this.m_upperTest != null && this.m_lowerTest.m_boundOperator != Operator.EQUALS) {
            result = result + " " + this.m_upperTest.toString();
        }
        if (this.m_label != null && this.m_label.length() > 0) {
            result = result + "/" + this.m_label;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: CustomPeriodicTest \"TestPart TestPart\"");
                System.exit(1);
            }
            CustomPeriodicTest test = new CustomPeriodicTest(args[0]);
            System.out.println("CustomPeriodicTest: \n\n" + test.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class TestPart
    implements Serializable {
        private static final long serialVersionUID = -898852333853148631L;
        public Operator m_boundOperator = Operator.NONE;
        protected boolean m_isUpper = false;
        public int m_year = -100;
        protected int m_month = -100;
        public int m_week_of_yr = -100;
        public int m_week_of_month = -100;
        public int m_day_of_yr = -100;
        public int m_day_of_month = -100;
        protected int m_day_of_week = -100;
        public int m_hour_of_day = -100;
        public int m_min_of_hour = -100;
        public int m_second = -100;
        protected Calendar c = new GregorianCalendar();

        public void setIsUpper(boolean upper) {
            this.m_isUpper = upper;
        }

        public boolean isUpper() {
            return this.m_isUpper;
        }

        public boolean eval(Date d, TestPart other) {
            int dayBound;
            int weekBound;
            int val;
            this.c.setTime(d);
            boolean result = true;
            if (this.m_year != -100) {
                boolean bl = result = result && this.m_boundOperator.evaluate(this.c.get(1), this.m_year);
            }
            if (this.m_month != -100) {
                int monthBound = this.m_month;
                val = this.c.get(2);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_month != -100) {
                    if ((monthBound -= other.m_month) < 0) {
                        monthBound += 12;
                    }
                    if ((val -= other.m_month) < 0) {
                        val += 12;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_month != -100) {
                    monthBound = 0;
                    if ((val -= this.m_month) < 0) {
                        val += 12;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, monthBound);
            }
            if (this.m_week_of_yr != -100) {
                weekBound = this.m_week_of_yr;
                val = this.c.get(3);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_week_of_yr != -100) {
                    if ((weekBound -= other.m_week_of_yr) < 0) {
                        weekBound += 52;
                    }
                    if ((val -= other.m_week_of_yr) < 0) {
                        val += 52;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_week_of_yr != -100) {
                    weekBound = 0;
                    if ((val -= this.m_week_of_yr) < 0) {
                        val += 52;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, weekBound);
            }
            if (this.m_week_of_month != -100) {
                weekBound = this.m_week_of_month;
                val = this.c.get(4);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_week_of_month != -100) {
                    if ((weekBound -= other.m_week_of_month) < 0) {
                        weekBound += 6;
                    }
                    if ((val -= other.m_week_of_month) < 0) {
                        val += 6;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_week_of_month != -100) {
                    weekBound = 0;
                    if ((val -= this.m_week_of_month) < 0) {
                        val += 6;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, weekBound);
            }
            if (this.m_day_of_yr != -100) {
                dayBound = this.m_day_of_yr;
                val = this.c.get(6);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_day_of_yr != -100) {
                    if ((dayBound -= other.m_day_of_yr) < 0) {
                        dayBound += 365;
                    }
                    if ((val -= other.m_day_of_yr) < 0) {
                        val += 365;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_day_of_yr != -100) {
                    dayBound = 0;
                    if ((val -= this.m_day_of_yr) < 0) {
                        val += 365;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, dayBound);
            }
            if (this.m_day_of_month != -100) {
                dayBound = this.m_day_of_month;
                val = this.c.get(5);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_day_of_month != -100) {
                    if ((dayBound -= other.m_day_of_month) < 0) {
                        dayBound += 31;
                    }
                    if ((val -= other.m_day_of_month) < 0) {
                        val += 31;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_day_of_month != -100) {
                    dayBound = 0;
                    if ((val -= this.m_day_of_month) < 0) {
                        val += 31;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, dayBound);
            }
            if (this.m_day_of_week != -100) {
                dayBound = this.m_day_of_week;
                val = this.c.get(7);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_day_of_week != -100) {
                    if ((dayBound -= other.m_day_of_week) < 0) {
                        dayBound += 7;
                    }
                    if ((val -= other.m_day_of_week) < 0) {
                        val += 7;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_day_of_week != -100) {
                    dayBound = 0;
                    if ((val -= this.m_day_of_week) < 0) {
                        val += 7;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, dayBound);
            }
            if (this.m_hour_of_day != -100) {
                int hourBound = this.m_hour_of_day;
                val = this.c.get(11);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_hour_of_day != -100) {
                    if ((hourBound -= other.m_hour_of_day) < 0) {
                        hourBound += 24;
                    }
                    if ((val -= other.m_hour_of_day) < 0) {
                        val += 24;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_hour_of_day != -100) {
                    hourBound = 0;
                    if ((val -= this.m_hour_of_day) < 0) {
                        val += 24;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, hourBound);
            }
            if (this.m_min_of_hour != -100) {
                int minBound = this.m_min_of_hour;
                val = this.c.get(12);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_min_of_hour != -100) {
                    if ((minBound -= other.m_min_of_hour) < 0) {
                        minBound += 60;
                    }
                    if ((val -= other.m_min_of_hour) < 0) {
                        val += 60;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_min_of_hour != -100) {
                    minBound = 0;
                    if ((val -= this.m_min_of_hour) < 0) {
                        val += 60;
                    }
                }
                boolean bl = result = result && this.m_boundOperator.evaluate(val, minBound);
            }
            if (this.m_second != -100) {
                int secBound = this.m_second;
                val = this.c.get(13);
                if (this.m_isUpper && other != null && other.m_boundOperator != Operator.EQUALS && other.m_second != -100) {
                    if ((secBound -= other.m_second) < 0) {
                        secBound += 60;
                    }
                    if ((val -= other.m_second) < 0) {
                        val += 60;
                    }
                }
                if (!this.m_isUpper && this.m_boundOperator != Operator.EQUALS && other != null && other.m_second != -100) {
                    secBound = 0;
                    if ((val -= this.m_second) < 0) {
                        val += 60;
                    }
                }
                result = result && this.m_boundOperator.evaluate(val, secBound);
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.m_boundOperator.toString());
            if (this.m_year != -100) {
                result.append("" + this.m_year);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_month != -100) {
                result.append(this.getMonthString());
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_week_of_yr != -100) {
                result.append("" + this.m_week_of_yr);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_week_of_month != -100) {
                result.append("" + this.m_week_of_month);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_day_of_yr != -100) {
                result.append("" + this.m_day_of_yr);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_day_of_month != -100) {
                result.append("" + this.m_day_of_month);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_day_of_week != -100) {
                result.append(this.getDayString());
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_hour_of_day != -100) {
                result.append("" + this.m_hour_of_day);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_min_of_hour != -100) {
                result.append("" + this.m_min_of_hour);
            } else {
                result.append("*");
            }
            result.append(":");
            if (this.m_second != -100) {
                result.append("" + this.m_second);
            } else {
                result.append("*");
            }
            return result.toString();
        }

        public void setOperator(String operator) {
            for (Operator t : Operator.values()) {
                if (!operator.equals(t.toString())) continue;
                this.m_boundOperator = t;
                break;
            }
        }

        public void setYear(String year) {
            this.m_year = year.equals("*") ? -100 : Integer.parseInt(year);
        }

        public void setWeekOfYear(String week) {
            this.m_week_of_yr = week.equals("*") ? -100 : Integer.parseInt(week);
        }

        public void setWeekOfMonth(String week) {
            if (week.equals("*")) {
                this.m_week_of_yr = -100;
            } else {
                this.m_week_of_month = Integer.parseInt(week);
            }
        }

        public void setDayOfYear(String dayOfYear) {
            this.m_day_of_yr = dayOfYear.equals("*") ? -100 : Integer.parseInt(dayOfYear);
        }

        public void setDayOfMonth(String dayOfMonth) {
            this.m_day_of_month = dayOfMonth.equals("*") ? -100 : Integer.parseInt(dayOfMonth);
        }

        public void setMonth(String month) {
            this.m_month = CustomPeriodicTest.this.parseMonth(month);
        }

        public void setDayOfWeek(String dayOfWeek) {
            this.m_day_of_week = CustomPeriodicTest.this.parseDay(dayOfWeek);
        }

        public void setHourOfDay(String hourOfDay) {
            this.m_hour_of_day = hourOfDay.equals("*") ? -100 : Integer.parseInt(hourOfDay);
        }

        public void setMinuteOfHour(String min) {
            this.m_min_of_hour = min.equals("*") ? -100 : Integer.parseInt(min);
        }

        public void setSecond(String second) {
            this.m_second = second.equals("*") ? -100 : Integer.parseInt(second);
        }

        public String getDayString() {
            if (this.m_day_of_week == 1) {
                return "sun";
            }
            if (this.m_day_of_week == 2) {
                return "mon";
            }
            if (this.m_day_of_week == 3) {
                return "tue";
            }
            if (this.m_day_of_week == 4) {
                return "wed";
            }
            if (this.m_day_of_week == 5) {
                return "thu";
            }
            if (this.m_day_of_week == 6) {
                return "fri";
            }
            if (this.m_day_of_week == 7) {
                return "sat";
            }
            return "*";
        }

        public String getMonthString() {
            if (this.m_month == 0) {
                return "jan";
            }
            if (this.m_month == 1) {
                return "feb";
            }
            if (this.m_month == 2) {
                return "mar";
            }
            if (this.m_month == 3) {
                return "apr";
            }
            if (this.m_month == 4) {
                return "may";
            }
            if (this.m_month == 5) {
                return "jun";
            }
            if (this.m_month == 6) {
                return "jul";
            }
            if (this.m_month == 7) {
                return "aug";
            }
            if (this.m_month == 8) {
                return "sep";
            }
            if (this.m_month == 9) {
                return "oct";
            }
            if (this.m_month == 10) {
                return "nov";
            }
            if (this.m_month == 11) {
                return "dec";
            }
            return "*";
        }
    }

    public static enum Operator {
        NONE("None"){

            @Override
            boolean evaluate(int first, int second) {
                return false;
            }
        }
        ,
        EQUALS("="){

            @Override
            boolean evaluate(int first, int second) {
                return first == second;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL_TO(">="){

            @Override
            boolean evaluate(int first, int second) {
                return first >= second;
            }
        }
        ,
        GREATER_THAN(">"){

            @Override
            boolean evaluate(int first, int second) {
                return first > second;
            }
        }
        ,
        LESS_THAN_OR_EQUAL_TO("<="){

            @Override
            boolean evaluate(int first, int second) {
                return first <= second;
            }
        }
        ,
        LESS_THAN("<"){

            @Override
            boolean evaluate(int first, int second) {
                return first < second;
            }
        };

        private final String m_stringVal;

        abstract boolean evaluate(int var1, int var2);

        private Operator(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

