/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.classifiers.timeseries.core.CustomPeriodicTest;

public class CustomPeriodicTestEditor
extends JPanel {
    private static final long serialVersionUID = 8515802184515862677L;
    protected JComboBox m_operator = new JComboBox();
    protected JComboBox m_year = new JComboBox();
    protected JComboBox m_month = new JComboBox();
    protected JComboBox m_week_of_yr = new JComboBox();
    protected JComboBox m_week_of_month = new JComboBox();
    protected JComboBox m_day_of_yr = new JComboBox();
    protected JComboBox m_day_of_month = new JComboBox();
    protected JComboBox m_day_of_week = new JComboBox();
    protected JComboBox m_hour_of_day = new JComboBox();
    protected JComboBox m_min_of_hour = new JComboBox();
    protected JComboBox m_second = new JComboBox();
    protected boolean m_right;
    protected CustomPeriodicTest m_testToEdit = new CustomPeriodicTest(">*:*:*:*:*:*:*:*:*:*");
    protected CustomPeriodicTest.TestPart m_partToEdit;
    protected PropertyChangeSupport m_support = new PropertyChangeSupport(this);

    public CustomPeriodicTestEditor(boolean right) {
        this.setLayout(new GridLayout(1, 10));
        this.add(this.m_operator);
        this.add(this.m_year);
        this.add(this.m_month);
        this.add(this.m_week_of_yr);
        this.add(this.m_week_of_month);
        this.add(this.m_day_of_yr);
        this.add(this.m_day_of_month);
        this.add(this.m_day_of_week);
        this.add(this.m_hour_of_day);
        this.add(this.m_min_of_hour);
        this.add(this.m_second);
        this.m_right = right;
        if (this.m_right) {
            this.m_testToEdit = new CustomPeriodicTest("<*:*:*:*:*:*:*:*:*:*");
        }
        this.m_partToEdit = this.m_right ? this.m_testToEdit.getUpperTest() : this.m_testToEdit.getLowerTest();
        this.setupCombos();
        this.m_operator.setToolTipText("Operator");
        this.m_operator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setOperator(CustomPeriodicTestEditor.this.m_operator.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_year.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setYear(CustomPeriodicTestEditor.this.m_year.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_year.setToolTipText("Year");
        this.m_month.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setMonth(CustomPeriodicTestEditor.this.m_month.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_month.setToolTipText("Month");
        this.m_week_of_yr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setWeekOfYear(CustomPeriodicTestEditor.this.m_week_of_yr.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_week_of_yr.setToolTipText("Week of the year");
        this.m_week_of_month.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setWeekOfMonth(CustomPeriodicTestEditor.this.m_week_of_month.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_week_of_month.setToolTipText("Week of the month");
        this.m_day_of_yr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setDayOfYear(CustomPeriodicTestEditor.this.m_day_of_yr.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_day_of_yr.setToolTipText("Day of the year");
        this.m_day_of_month.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setDayOfMonth(CustomPeriodicTestEditor.this.m_day_of_month.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_day_of_month.setToolTipText("Day of the month");
        this.m_day_of_week.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setDayOfWeek(CustomPeriodicTestEditor.this.m_day_of_week.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_day_of_week.setToolTipText("Day of the week");
        this.m_hour_of_day.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setHourOfDay(CustomPeriodicTestEditor.this.m_hour_of_day.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_hour_of_day.setToolTipText("Hour of the day");
        this.m_min_of_hour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setMinuteOfHour(CustomPeriodicTestEditor.this.m_min_of_hour.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_min_of_hour.setToolTipText("Minute of the hour");
        this.m_second.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPeriodicTestEditor.this.m_partToEdit != null) {
                    CustomPeriodicTestEditor.this.m_partToEdit.setSecond(CustomPeriodicTestEditor.this.m_second.getSelectedItem().toString());
                    CustomPeriodicTestEditor.this.m_support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_second.setToolTipText("Second");
    }

    public void setTestToEdit(CustomPeriodicTest t) {
        this.m_testToEdit = t;
        this.m_partToEdit = this.m_right ? this.m_testToEdit.getUpperTest() : this.m_testToEdit.getLowerTest();
        this.fillGUIElements();
    }

    public CustomPeriodicTest getTestBeingEdited() {
        return this.m_testToEdit;
    }

    protected void fillGUIElements() {
        if (this.m_partToEdit == null) {
            this.setEnabled(false);
            return;
        }
        this.m_operator.setSelectedItem(this.m_partToEdit.m_boundOperator.toString());
        this.m_year.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_year));
        this.m_month.setSelectedItem(this.m_partToEdit.getMonthString());
        this.m_week_of_yr.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_week_of_yr));
        this.m_week_of_month.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_week_of_month));
        this.m_day_of_yr.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_day_of_yr));
        this.m_day_of_month.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_day_of_month));
        this.m_day_of_week.setSelectedItem(this.m_partToEdit.getDayString());
        this.m_hour_of_day.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_hour_of_day));
        this.m_min_of_hour.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_min_of_hour));
        this.m_second.setSelectedItem(this.numericValueToString(this.m_partToEdit.m_second));
    }

    protected String numericValueToString(int val) {
        if (val == -100) {
            return "*";
        }
        return "" + val;
    }

    protected void setupCombos() {
        int i;
        Vector<String> inequalities = new Vector<String>();
        if (!this.m_right) {
            inequalities.add(">");
            inequalities.add(">=");
            inequalities.add("=");
        } else {
            inequalities.add("<");
            inequalities.add("<=");
        }
        this.m_operator.setModel(new DefaultComboBoxModel(inequalities));
        Vector<String> years = new Vector<String>();
        years.add("*");
        for (int i2 = 1900; i2 <= 2100; ++i2) {
            years.add("" + i2);
        }
        this.m_year.setModel(new DefaultComboBoxModel(years));
        Vector<String> months = new Vector<String>();
        months.add("*");
        months.add("jan");
        months.add("feb");
        months.add("mar");
        months.add("apr");
        months.add("may");
        months.add("jun");
        months.add("jul");
        months.add("aug");
        months.add("sep");
        months.add("oct");
        months.add("nov");
        months.add("dec");
        this.m_month.setModel(new DefaultComboBoxModel(months));
        Vector<String> days = new Vector<String>();
        days.add("*");
        days.add("sun");
        days.add("mon");
        days.add("tue");
        days.add("wed");
        days.add("thu");
        days.add("fri");
        days.add("sat");
        this.m_day_of_week.setModel(new DefaultComboBoxModel(days));
        Vector<String> week = new Vector<String>();
        week.add("*");
        for (i = 1; i <= 52; ++i) {
            week.add("" + i);
        }
        this.m_week_of_yr.setModel(new DefaultComboBoxModel(week));
        week = new Vector();
        week.add("*");
        for (i = 0; i <= 6; ++i) {
            week.add("" + i);
        }
        this.m_week_of_month.setModel(new DefaultComboBoxModel(week));
        days = new Vector();
        days.add("*");
        for (i = 1; i <= 365; ++i) {
            days.add("" + i);
        }
        this.m_day_of_yr.setModel(new DefaultComboBoxModel(days));
        days = new Vector();
        days.add("*");
        for (i = 1; i <= 31; ++i) {
            days.add("" + i);
        }
        this.m_day_of_month.setModel(new DefaultComboBoxModel(days));
        Vector<String> hour = new Vector<String>();
        hour.add("*");
        for (int i3 = 0; i3 < 24; ++i3) {
            hour.add("" + i3);
        }
        this.m_hour_of_day.setModel(new DefaultComboBoxModel(hour));
        Vector<String> minute = new Vector<String>();
        minute.add("*");
        for (int i4 = 0; i4 < 60; ++i4) {
            minute.add("" + i4);
        }
        this.m_min_of_hour.setModel(new DefaultComboBoxModel(minute));
        Vector<String> second = new Vector<String>();
        second.add("*");
        for (int i5 = 0; i5 < 60; ++i5) {
            second.add("" + i5);
        }
        this.m_second.setModel(new DefaultComboBoxModel(second));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_operator.setEnabled(enabled);
        this.m_year.setEnabled(enabled);
        this.m_month.setEnabled(enabled);
        this.m_week_of_yr.setEnabled(enabled);
        this.m_week_of_month.setEnabled(enabled);
        this.m_day_of_yr.setEnabled(enabled);
        this.m_day_of_month.setEnabled(enabled);
        this.m_day_of_week.setEnabled(enabled);
        this.m_hour_of_day.setEnabled(enabled);
        this.m_min_of_hour.setEnabled(enabled);
        this.m_second.setEnabled(enabled);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_support.removePropertyChangeListener(l);
    }

    public static void main(String[] args) {
        try {
            CustomPeriodicTestEditor ed = new CustomPeriodicTestEditor(false);
            final CustomPeriodicTest test = new CustomPeriodicTest(">1965:aug:*:*:*:28:*:*:*:*");
            ed.setTestToEdit(test);
            final JFrame jf = new JFrame("Periodic test editor");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)ed, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.out.println(test.toString());
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

