/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.WekaForecaster;
import weka.classifiers.timeseries.core.OverlayForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.classifiers.timeseries.eval.TSEvaluation;
import weka.classifiers.timeseries.eval.graph.GraphDriver;
import weka.classifiers.timeseries.gui.AdvancedConfigPanel;
import weka.classifiers.timeseries.gui.SimpleConfigPanel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.BrowserHelper;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.ResultHistoryPanel;
import weka.gui.TaskLogger;
import weka.gui.WekaTaskMonitor;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TimeSeriesForecasting;
import weka.gui.beans.TimeSeriesForecastingKFPerspective;

public class ForecastingPanel
extends JPanel {
    private static final long serialVersionUID = -8415151090793037265L;
    protected Instances m_instances;
    protected Logger m_log;
    protected SimpleConfigPanel m_simpleConfigPanel;
    protected AdvancedConfigPanel m_advancedConfigPanel;
    protected WekaForecaster m_forecaster = new WekaForecaster();
    protected JTabbedPane m_configPane = new JTabbedPane();
    protected JTextArea m_outText = new JTextArea(20, 50);
    protected ResultHistoryPanel m_history = new ResultHistoryPanel((JTextComponent)this.m_outText);
    protected JButton m_startBut = new JButton("Start");
    protected JButton m_stopBut = new JButton("Stop");
    protected JButton m_helpBut = new JButton("Help");
    protected JSplitPane m_splitP;
    protected Thread m_runThread;
    protected boolean m_isRunningAsPerspective = false;
    protected JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected boolean m_sortedCheck;
    JTabbedPane m_outputPane = new JTabbedPane();
    protected HashMap<String, JTabbedPane> m_framedOutputMap = new HashMap();

    public ForecastingPanel(LogPanel log, boolean displayWelcome) {
        this(log, displayWelcome, true, false);
    }

    public ForecastingPanel(LogPanel log, boolean displayLogWelcome, boolean allowSeparateTestSet, boolean kfPerspective) {
        this.m_isRunningAsPerspective = kfPerspective;
        this.m_simpleConfigPanel = new SimpleConfigPanel(this);
        this.m_advancedConfigPanel = new AdvancedConfigPanel(this.m_simpleConfigPanel, allowSeparateTestSet);
        this.setLayout(new BorderLayout());
        this.m_log = log;
        if (this.m_log != null && displayLogWelcome) {
            String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
            this.m_log.logMessage("Weka Forecaster");
            this.m_log.logMessage("Started on " + date);
            this.m_log.statusMessage("Welcome to the Weka Forecaster");
        }
        this.m_simpleConfigPanel.setAdvancedConfig(this.m_advancedConfigPanel);
        this.m_configPane.addTab(this.m_simpleConfigPanel.getTabTitle(), null, this.m_simpleConfigPanel, this.m_simpleConfigPanel.getTabTitleToolTip());
        this.m_configPane.addTab(this.m_advancedConfigPanel.getTabTitle(), null, this.m_advancedConfigPanel, this.m_advancedConfigPanel.getTabTitleToolTip());
        this.m_outText.setEditable(false);
        this.m_outText.setFont(new Font("Monospaced", 0, 12));
        this.m_outText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane js = new JScrollPane(this.m_outText);
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        this.m_outputPane.setBorder(BorderFactory.createTitledBorder("Output/Visualization"));
        this.m_outputPane.addTab("Output", null, js, "Forecaster output");
        this.m_history.setBorder((Border)BorderFactory.createTitledBorder("Result list"));
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                ForecastingPanel forecastingPanel = ForecastingPanel.this;
                synchronized (forecastingPanel) {
                    if (!e.getValueIsAdjusting()) {
                        ListSelectionModel lm = (ListSelectionModel)e.getSource();
                        for (int j = e.getFirstIndex(); j <= e.getLastIndex(); ++j) {
                            if (!lm.isSelectedIndex(j)) continue;
                            String name = ForecastingPanel.this.m_history.getSelectedName();
                            ForecastingPanel.this.updateMainTabs(name);
                        }
                    }
                }
            }
        });
        this.m_history.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = ForecastingPanel.this.m_history.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = ForecastingPanel.this.m_history.getNameAtIndex(index);
                        ForecastingPanel.this.resultPopup(name, e.getX(), e.getY());
                    } else {
                        ForecastingPanel.this.resultPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_history.setHandleRightClicks(false);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout());
        JPanel butAndHistHolder = new JPanel();
        butAndHistHolder.setLayout(new BorderLayout());
        butAndHistHolder.add((Component)this.m_history, "Center");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 3));
        butHolder.add(this.m_startBut);
        butHolder.add(this.m_stopBut);
        butHolder.add(this.m_helpBut);
        this.m_startBut.setToolTipText("Start the forecasting process");
        this.m_stopBut.setToolTipText("Stop the running forecasting process");
        butAndHistHolder.add((Component)butHolder, "North");
        this.m_startBut.setEnabled(false);
        this.m_stopBut.setEnabled(false);
        this.m_stopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForecastingPanel.this.stopForecaster();
            }
        });
        this.m_helpBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL((Component)ForecastingPanel.this, (String)"http://wiki.pentaho.com/display/DATAMINING/Time+Series+Analysis+and+Forecasting+with+Weka");
            }
        });
        this.m_helpBut.setToolTipText("Visit documentation for the time series environment in your browser");
        lowerPanel.add((Component)butAndHistHolder, "West");
        lowerPanel.add((Component)this.m_outputPane, "Center");
        this.m_splitP = new JSplitPane(0, this.m_configPane, lowerPanel);
        this.m_splitP.setOneTouchExpandable(true);
        this.add((Component)this.m_splitP, "Center");
        if (this.m_log != null && this.m_log instanceof JComponent) {
            this.add((Component)((JComponent)this.m_log), "South");
        }
        double width = this.m_history.getPreferredSize().width;
        int height = this.m_history.getPreferredSize().height;
        this.m_history.setPreferredSize(new Dimension((int)(width *= 0.75), height));
        this.m_startBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForecastingPanel.this.startForecaster(ForecastingPanel.this.m_forecaster);
            }
        });
    }

    protected void enableStartButton(boolean enable) {
        this.m_startBut.setEnabled(enable);
    }

    protected void openResultFrame(String name) {
        StringBuffer buffer = this.m_history.getNamedBuffer(name);
        JTabbedPane tabbedPane = this.m_framedOutputMap.get(name);
        if (buffer != null && tabbedPane == null) {
            JTextArea textA = new JTextArea(20, 50);
            textA.setEditable(false);
            textA.setFont(new Font("Monospaced", 0, 12));
            textA.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            textA.setText(buffer.toString());
            tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Output", new JScrollPane(textA));
            this.updateComponentTabs(name, tabbedPane);
            this.m_framedOutputMap.put(name, tabbedPane);
            final JFrame jf = new JFrame(name);
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ForecastingPanel.this.m_framedOutputMap.remove(jf.getTitle());
                    jf.dispose();
                }
            });
            jf.setLayout(new BorderLayout());
            jf.add((Component)tabbedPane, "Center");
            jf.pack();
            jf.setSize(550, 400);
            jf.setVisible(true);
        }
    }

    protected void resultPopup(final String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem showMainBuff = new JMenuItem("View in main window");
        if (selectedName != null) {
            showMainBuff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ForecastingPanel.this.m_history.setSingle(selectedName);
                    ForecastingPanel.this.updateMainTabs(selectedName);
                }
            });
        } else {
            showMainBuff.setEnabled(false);
        }
        resultListMenu.add(showMainBuff);
        JMenuItem showSepBuff = new JMenuItem("View in separate window");
        if (selectedName != null) {
            showSepBuff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ForecastingPanel.this.openResultFrame(selectedName);
                }
            });
        } else {
            showSepBuff.setEnabled(false);
        }
        resultListMenu.add(showSepBuff);
        JMenuItem deleteResultBuff = new JMenuItem("Delete result");
        if (selectedName != null && this.m_runThread == null) {
            deleteResultBuff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ForecastingPanel.this.m_history.removeResult(selectedName);
                }
            });
        } else {
            deleteResultBuff.setEnabled(false);
        }
        resultListMenu.add(deleteResultBuff);
        resultListMenu.addSeparator();
        List resultList = null;
        if (selectedName != null) {
            resultList = (List)this.m_history.getNamedObject(name);
        }
        WekaForecaster saveForecaster = null;
        Instances saveForecasterStructure = null;
        if (resultList != null) {
            for (Object o : resultList) {
                if (o instanceof WekaForecaster) {
                    saveForecaster = (WekaForecaster)o;
                    continue;
                }
                if (!(o instanceof Instances)) continue;
                saveForecasterStructure = (Instances)o;
            }
        }
        final WekaForecaster toSave = saveForecaster;
        final Instances structureToSave = saveForecasterStructure;
        JMenuItem saveForecasterMenuItem = new JMenuItem("Save forecasting model");
        if (saveForecaster != null) {
            saveForecasterMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ForecastingPanel.this.saveForecaster(name, toSave, structureToSave);
                }
            });
        } else {
            saveForecasterMenuItem.setEnabled(false);
        }
        resultListMenu.add(saveForecasterMenuItem);
        JMenuItem loadForecasterMenuItem = new JMenuItem("Load forecasting model");
        resultListMenu.add(loadForecasterMenuItem);
        loadForecasterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForecastingPanel.this.loadForecaster();
            }
        });
        if (this.m_isRunningAsPerspective) {
            JMenuItem copyToKFClipboardMenuItem = new JMenuItem("Copy model to Knowledge Flow clipboard");
            resultListMenu.add(copyToKFClipboardMenuItem);
            copyToKFClipboardMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        KnowledgeFlowApp singleton = KnowledgeFlowApp.getSingleton();
                        String encoded = TimeSeriesForecasting.encodeForecasterToBase64(toSave, structureToSave);
                        TimeSeriesForecasting component = new TimeSeriesForecasting();
                        component.setEncodedForecaster(encoded);
                        TimeSeriesForecastingKFPerspective.setClipboard(component);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        JMenuItem reevaluateModelItem = new JMenuItem("Re-evaluate model");
        if (selectedName != null && this.m_runThread == null) {
            reevaluateModelItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ForecastingPanel.this.reevaluateForecaster(selectedName, toSave, structureToSave);
                }
            });
            reevaluateModelItem.setEnabled((this.m_advancedConfigPanel.m_trainingCheckBox.isSelected() || this.m_advancedConfigPanel.m_holdoutCheckBox.isSelected()) && this.m_instances != null);
        } else {
            reevaluateModelItem.setEnabled(false);
        }
        resultListMenu.add(reevaluateModelItem);
        resultListMenu.show(this.m_history.getList(), x, y);
    }

    protected void loadForecaster() {
        File sFile = null;
        int returnVal = this.m_fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            sFile = this.m_fileChooser.getSelectedFile();
            if (this.m_log != null) {
                this.m_log.statusMessage("Loading forecaster...");
            }
            Object f = null;
            Instances header = null;
            boolean loadOK = true;
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(sFile));
                f = is.readObject();
                header = (Instances)is.readObject();
                is.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex, "Load failed", 0);
                loadOK = false;
            }
            if (!loadOK) {
                if (this.m_log != null) {
                    this.m_log.logMessage("Loading from file " + sFile.getName() + "' failed.");
                    this.m_log.statusMessage("OK");
                }
            } else if (!(f instanceof WekaForecaster)) {
                JOptionPane.showMessageDialog(this, "Loaded model is not a weka forecaster!", "Weka forecasting", 0);
                loadOK = false;
            }
            if (loadOK) {
                String fname;
                String algoName;
                String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                StringBuffer outBuff = new StringBuffer();
                WekaForecaster wf = (WekaForecaster)f;
                String lagOptions = "";
                if (wf instanceof TSLagUser) {
                    TSLagMaker lagMaker = wf.getTSLagMaker();
                    lagOptions = Utils.joinOptions((String[])lagMaker.getOptions());
                }
                name = (algoName = (fname = wf.getAlgorithmName()).substring(0, fname.indexOf(32))).startsWith("weka.classifiers.") ? name + algoName.substring("weka.classifiers.".length()) : name + algoName;
                name = name + " loaded from '" + sFile.getName() + "'";
                outBuff.append("Scheme:\n\t" + fname).append("\n");
                outBuff.append("loaded from '" + sFile.getName() + "'\n\n");
                if (lagOptions.length() > 0) {
                    outBuff.append("Lagged and derived variable options:\n\t").append(lagOptions + "\n\n");
                }
                outBuff.append(wf.toString());
                this.m_history.addResult(name, outBuff);
                this.m_history.setSingle(name);
                ArrayList<WekaForecaster> resultList = new ArrayList<WekaForecaster>();
                resultList.add(wf);
                resultList.add((WekaForecaster)header);
                this.m_history.addObject(name, resultList);
                this.updateMainTabs(name);
            }
        }
    }

    protected void saveForecaster(String name, TSForecaster forecaster, Instances structure) {
        File sFile = null;
        boolean saveOK = true;
        int returnVal = this.m_fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            sFile = this.m_fileChooser.getSelectedFile();
            if (!sFile.getName().toLowerCase().endsWith(".model")) {
                sFile = new File(sFile.getParent(), sFile.getName() + ".model");
            }
            if (this.m_log != null) {
                this.m_log.statusMessage("Saving forecaster to file...");
            }
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(sFile));
                oos.writeObject(forecaster);
                if (structure != null) {
                    oos.writeObject(new Instances(structure, 0));
                }
                oos.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex, "Save Failed", 0);
                saveOK = false;
            }
            if (saveOK && this.m_log != null) {
                this.m_log.logMessage("Saved model (" + name + " ) to file '" + sFile.getName() + "'");
                this.m_log.statusMessage("OK");
            }
        }
    }

    protected synchronized void updateComponentTabs(String name, JTabbedPane outputPane) {
        int numTabs = outputPane.getTabCount();
        if (numTabs > 1) {
            for (int i = numTabs - 1; i > 0; --i) {
                outputPane.removeTabAt(i);
            }
        }
        List storedResults = (List)this.m_history.getNamedObject(name);
        List graphList = null;
        if (storedResults != null) {
            for (Object o : storedResults) {
                if (!(o instanceof List)) continue;
                graphList = (List)o;
            }
        }
        if (graphList != null && graphList.size() > 0) {
            for (JPanel p : graphList) {
                outputPane.addTab(p.getToolTipText(), p);
            }
        }
    }

    protected synchronized void updateMainTabs(String entryName) {
        String name = this.m_history.getSelectedName();
        if (!name.equals(entryName)) {
            return;
        }
        this.updateComponentTabs(name, this.m_outputPane);
    }

    public void setLog(Logger log) {
        if (log instanceof JComponent) {
            if (this.m_log != null) {
                this.remove((JComponent)this.m_log);
            }
            this.m_log = log;
            this.add((Component)((JComponent)this.m_log), "South");
        }
    }

    public void setInstances(Instances insts) throws Exception {
        this.m_sortedCheck = false;
        boolean first = this.m_simpleConfigPanel.m_targetPanel.getTableModel() == null;
        this.m_instances = new Instances(insts);
        this.m_simpleConfigPanel.setInstances(insts);
        this.m_advancedConfigPanel.setInstances(insts);
        if (first) {
            TableModel model = this.m_simpleConfigPanel.m_targetPanel.getTableModel();
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int[] selected = ForecastingPanel.this.m_simpleConfigPanel.m_targetPanel.getSelectedAttributes();
                    if (selected != null && selected.length > 0) {
                        ForecastingPanel.this.m_startBut.setEnabled(true);
                    } else {
                        ForecastingPanel.this.m_startBut.setEnabled(false);
                    }
                    ForecastingPanel.this.m_advancedConfigPanel.updatePanel();
                }
            });
        }
    }

    protected void sortCheck() {
        String timeStampF;
        Attribute timeStampAtt;
        if (this.m_instances == null) {
            return;
        }
        if (this.m_simpleConfigPanel.isUsingANativeTimeStamp() && (timeStampAtt = this.m_instances.attribute(timeStampF = this.m_simpleConfigPanel.getSelectedTimeStampField())) != null) {
            int result;
            double lastNonMissing = Utils.missingValue();
            boolean ok = true;
            boolean hasMissing = false;
            for (int i = 0; i < this.m_instances.numInstances(); ++i) {
                Instance current = this.m_instances.instance(i);
                if (Utils.isMissingValue((double)lastNonMissing)) {
                    if (!current.isMissing(timeStampAtt)) {
                        lastNonMissing = current.value(timeStampAtt);
                        continue;
                    }
                    hasMissing = true;
                    continue;
                }
                if (!current.isMissing(timeStampAtt)) {
                    if (current.value(timeStampAtt) - lastNonMissing < 0.0) {
                        ok = false;
                        break;
                    }
                    lastNonMissing = current.value(timeStampAtt);
                    continue;
                }
                hasMissing = true;
            }
            if (!ok && !hasMissing && (result = JOptionPane.showConfirmDialog(this, "The data does not appear to be in sorted order of \"" + timeStampF + "\". Do you want to sort the data?", "Forecasting", 0)) == 0) {
                if (this.m_log != null) {
                    this.m_log.statusMessage("Sorting data...");
                }
                this.m_instances.sort(timeStampAtt);
                this.m_sortedCheck = true;
            }
            if (!ok && hasMissing && (result = JOptionPane.showConfirmDialog(this, "The data does not appear to be in sorted order of \"" + timeStampF + "\". \nFurthermore, there are rows with\n" + "missing timestamp values. We can remove these\n" + "rows and then sort the data but this is likely to\n" + "result in degraded performance. It is strongly\n" + "recommended that you fix these issues in the data\n" + "before continuing. Do you want the system to proceed\n" + "anyway by removing rows with missing timestamps and\n" + "then sorting the data?", "Forecasting", 0)) == 0) {
                if (this.m_log != null) {
                    this.m_log.statusMessage("Removing rows with missing time stamps and sorting data...");
                }
                this.m_instances.deleteWithMissing(timeStampAtt);
                this.m_instances.sort(timeStampAtt);
                this.m_sortedCheck = true;
            }
        }
    }

    protected void stopForecaster() {
        if (this.m_runThread != null) {
            this.m_runThread.interrupt();
            this.m_runThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reevaluateForecaster(String name, WekaForecaster forecaster, Instances trainHeader) {
        if (!trainHeader.equalHeaders(this.m_instances)) {
            JOptionPane.showMessageDialog(null, "Data used to train this forecaster is not compatible with the currently loaded data:\n\n" + trainHeader.equalHeadersMsg(this.m_instances), "Unable to reevaluate model", 0);
        } else if (this.m_runThread == null) {
            ForecastingPanel forecastingPanel = this;
            synchronized (forecastingPanel) {
                this.m_startBut.setEnabled(false);
                this.m_stopBut.setEnabled(true);
            }
            this.m_runThread = new ForecastingThread(forecaster, name);
            ((ForecastingThread)this.m_runThread).setConfigureAndBuild(false);
            this.m_runThread.setPriority(1);
            this.m_runThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startForecaster(WekaForecaster forecaster) {
        if (this.m_runThread == null) {
            ForecastingPanel forecastingPanel = this;
            synchronized (forecastingPanel) {
                this.m_startBut.setEnabled(false);
                this.m_stopBut.setEnabled(true);
            }
            this.m_runThread = new ForecastingThread(forecaster, null);
            this.m_runThread.setPriority(1);
            this.m_runThread.start();
        }
    }

    private void dontShowMessageDialog(String key, String message, String dialogTitle) {
        if (!Utils.getDontShowDialog((String)key)) {
            JCheckBox dontShow = new JCheckBox("Do not show this message again");
            Object[] stuff = new Object[]{message + "\n", dontShow};
            JOptionPane.showMessageDialog(this, stuff, dialogTitle, 0);
            if (dontShow.isSelected()) {
                try {
                    Utils.setDontShowDialog((String)key);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            ForecastingPanel scp = new ForecastingPanel(new LogPanel(new WekaTaskMonitor()), true, false, false);
            scp.setInstances(i);
            final JFrame jf = new JFrame("Weka Forecasting");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)scp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class LogPrintStream
    extends PrintStream {
        public LogPrintStream() {
            super(System.out);
        }

        private void logStatusMessage(String string) {
            if (ForecastingPanel.this.m_log != null) {
                ForecastingPanel.this.m_log.statusMessage(string);
                if (string.contains("WARNING") || string.contains("ERROR")) {
                    ForecastingPanel.this.m_log.logMessage(string);
                }
            }
        }

        @Override
        public void println(String string) {
            System.out.println(string);
            this.logStatusMessage(string);
        }

        @Override
        public void println(Object obj) {
            this.println(obj.toString());
        }

        @Override
        public void print(String string) {
            System.out.print(string);
            this.logStatusMessage(string);
        }

        @Override
        public void print(Object obj) {
            this.print(obj.toString());
        }
    }

    protected class ForecastingThread
    extends Thread {
        protected boolean m_configAndBuild = true;
        protected WekaForecaster m_threadForecaster = null;
        protected String m_name;

        public ForecastingThread(WekaForecaster forecaster, String name) {
            this.m_threadForecaster = forecaster;
            this.m_name = name;
        }

        public void setConfigureAndBuild(boolean configAndBuild) {
            this.m_configAndBuild = configAndBuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogPrintStream logger = new LogPrintStream();
            logger.println("Setting up...");
            String name = this.m_name;
            StringBuffer outBuff = null;
            if (name == null) {
                name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                outBuff = new StringBuffer();
            }
            String fname = "";
            try {
                ArrayList<JPanel> graphList;
                ArrayList<Serializable> resultList;
                Instances trainInst;
                block74: {
                    String fieldsToForecast;
                    if (!ForecastingPanel.this.m_sortedCheck) {
                        ForecastingPanel.this.sortCheck();
                    }
                    Object inst = new Instances(ForecastingPanel.this.m_instances);
                    TSEvaluation eval = new TSEvaluation((Instances)inst, ForecastingPanel.this.m_advancedConfigPanel.getHoldoutSetSize());
                    if (this.m_configAndBuild) {
                        this.m_threadForecaster.setBaseForecaster(ForecastingPanel.this.m_advancedConfigPanel.getBaseClassifier());
                        ForecastingPanel.this.m_simpleConfigPanel.applyToForecaster(this.m_threadForecaster);
                        ForecastingPanel.this.m_advancedConfigPanel.applyToForecaster(this.m_threadForecaster);
                    }
                    ForecastingPanel.this.m_simpleConfigPanel.applyToEvaluation(eval, this.m_threadForecaster);
                    ForecastingPanel.this.m_advancedConfigPanel.applyToEvaluation(eval, this.m_threadForecaster);
                    eval.setForecastFuture(ForecastingPanel.this.m_advancedConfigPanel.getOutputFuturePredictions() || ForecastingPanel.this.m_advancedConfigPanel.getGraphFuturePredictions());
                    if (this.m_threadForecaster instanceof OverlayForecaster && this.m_threadForecaster.isUsingOverlayData()) {
                        if (!eval.getEvaluateOnTestData() && (ForecastingPanel.this.m_advancedConfigPanel.m_outputFutureCheckBox.isSelected() || ForecastingPanel.this.m_advancedConfigPanel.m_graphFutureCheckBox.isSelected())) {
                            ForecastingPanel.this.dontShowMessageDialog("weka.classifiers.timeseries.gui.CantFutureForecastTraining", "Unable to generate a future forecast beyond the end of the training\ndata because there is no future overlay data available. Use a holdout\nset for evaluation in order to simulate having \"future\" overlay\ndata available.\n\n", "ForecastingPanel");
                        }
                        if (eval.getEvaluateOnTestData() && (ForecastingPanel.this.m_advancedConfigPanel.m_outputFutureCheckBox.isSelected() || ForecastingPanel.this.m_advancedConfigPanel.m_graphFutureCheckBox.isSelected())) {
                            ForecastingPanel.this.dontShowMessageDialog("weka.classifiers.timeseries.gui.CantFutureForecastTesting", "Unable to generate a future forecast beyond the end of the test\ndata because there is no future overlay data available.\n\n", "ForecastingPanel");
                        }
                    }
                    fname = this.m_threadForecaster.getAlgorithmName();
                    if (this.m_name == null) {
                        String algoName = fname.substring(0, fname.indexOf(32));
                        name = algoName.startsWith("weka.classifiers.") ? name + algoName.substring("weka.classifiers.".length()) : name + algoName;
                    }
                    String lagOptions = "";
                    if (this.m_threadForecaster instanceof TSLagUser) {
                        TSLagMaker lagMaker = this.m_threadForecaster.getTSLagMaker();
                        lagOptions = Utils.joinOptions((String[])lagMaker.getOptions());
                    }
                    if (lagOptions.length() > 0 && this.m_name == null) {
                        name = name + " [" + lagOptions + "]";
                    }
                    if (this.m_name == null) {
                        outBuff.append("=== Run information ===\n\n");
                    } else {
                        outBuff = ForecastingPanel.this.m_history.getNamedBuffer(name);
                        outBuff.append("\n=== Model re-evaluation===\n\n");
                    }
                    outBuff.append("Scheme:\n\t" + fname).append("\n\n");
                    if (lagOptions.length() > 0) {
                        outBuff.append("Lagged and derived variable options:\n\t").append(lagOptions + "\n\n");
                    }
                    outBuff.append("Relation:     " + inst.relationName() + '\n');
                    outBuff.append("Instances:    " + inst.numInstances() + '\n');
                    outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                    if (inst.numAttributes() < 100) {
                        for (int i = 0; i < inst.numAttributes(); ++i) {
                            outBuff.append("              " + inst.attribute(i).name() + '\n');
                        }
                    } else {
                        outBuff.append("              [list of attributes omitted]\n");
                    }
                    if (this.m_configAndBuild) {
                        ForecastingPanel.this.m_history.addResult(name, outBuff);
                    }
                    ForecastingPanel.this.m_history.setSingle(name);
                    if (ForecastingPanel.this.m_log != null) {
                        ForecastingPanel.this.m_log.logMessage("Started " + fname);
                        if (this.m_configAndBuild) {
                            logger.println("Training forecaster...");
                        }
                        if (ForecastingPanel.this.m_log instanceof TaskLogger) {
                            ((TaskLogger)ForecastingPanel.this.m_log).taskStarted();
                        }
                    }
                    trainInst = eval.getTrainingData();
                    if (this.m_configAndBuild) {
                        this.m_threadForecaster.buildForecaster(trainInst, logger);
                        outBuff.append("\n" + this.m_threadForecaster.toString());
                        ForecastingPanel.this.m_history.updateResult(name);
                    }
                    if (eval.getEvaluateOnTrainingData() || eval.getEvaluateOnTestData()) {
                        logger.println("Evaluating...");
                    }
                    eval.evaluateForecaster((TSForecaster)this.m_threadForecaster, false, logger);
                    if (ForecastingPanel.this.m_advancedConfigPanel.getOutputPredictionsAtStep() > 0) {
                        int step = ForecastingPanel.this.m_advancedConfigPanel.getOutputPredictionsAtStep();
                        String targetName = ForecastingPanel.this.m_advancedConfigPanel.getOutputPredictionsTarget();
                        fieldsToForecast = this.m_threadForecaster.getFieldsToForecast();
                        if (!fieldsToForecast.contains(targetName)) {
                            throw new Exception("Cannot output predictions for \"" + targetName + "\" because that field is not being predicted.");
                        }
                        if (eval.getTrainingData() != null && eval.getEvaluateOnTrainingData()) {
                            String predString = eval.printPredictionsForTrainingData("=== Predictions for training data: " + targetName + " (" + step + (step > 1 ? "-steps ahead)" : "-step ahead)") + " ===", targetName, step, eval.getPrimeWindowSize());
                            outBuff.append("\n").append(predString);
                        }
                        if (eval.getTestData() != null) {
                            int instanceNumOffset = eval.getTrainingData() != null && ForecastingPanel.this.m_advancedConfigPanel.getHoldoutSetSize() > 0.0 ? eval.getTrainingData().numInstances() : 0;
                            String predString = eval.printPredictionsForTestData("=== Predictions for test data: " + targetName + " (" + step + (step > 1 ? "-steps ahead)" : "-step ahead)") + " ===", targetName, step, instanceNumOffset);
                            outBuff.append("\n").append(predString);
                        }
                        ForecastingPanel.this.m_history.updateResult(name);
                    }
                    if (ForecastingPanel.this.m_advancedConfigPanel.getOutputFuturePredictions()) {
                        if (eval.getTrainingData() != null) {
                            outBuff.append("\n=== Future predictions from end of training data ===\n");
                            outBuff.append(eval.printFutureTrainingForecast(this.m_threadForecaster));
                        }
                        if (eval.getTestData() != null && eval.getEvaluateOnTestData()) {
                            outBuff.append("\n=== Future predictions from end of test data ===\n");
                            outBuff.append(eval.printFutureTestForecast(this.m_threadForecaster));
                        }
                        ForecastingPanel.this.m_history.updateResult(name);
                    }
                    if (eval.getEvaluateOnTrainingData() || eval.getEvaluateOnTestData()) {
                        outBuff.append("\n" + eval.toSummaryString());
                        ForecastingPanel.this.m_history.updateResult(name);
                    }
                    List<Serializable> list = resultList = this.m_configAndBuild ? new ArrayList<Serializable>() : (List)ForecastingPanel.this.m_history.getNamedObject(name);
                    if (!this.m_configAndBuild) {
                        ArrayList newResultList = new ArrayList();
                        for (int z = 0; z < resultList.size(); ++z) {
                            if (!(resultList.get(z) instanceof TSForecaster) && !(resultList.get(z) instanceof Instances)) continue;
                            newResultList.add(resultList.get(z));
                        }
                        resultList = newResultList;
                    }
                    graphList = new ArrayList<JPanel>();
                    if (ForecastingPanel.this.m_advancedConfigPanel.getGraphPredictionsAtStep() > 0) {
                        int stepNum = ForecastingPanel.this.m_advancedConfigPanel.getGraphPredictionsAtStep();
                        List<String> targets = AbstractForecaster.stringToList(this.m_threadForecaster.getFieldsToForecast());
                        if (eval.getTrainingData() != null && eval.getEvaluateOnTrainingData()) {
                            JPanel trainTargetsAtStep = eval.graphPredictionsForTargetsOnTraining(GraphDriver.getDefaultDriver(), this.m_threadForecaster, targets, stepNum, eval.getPrimeWindowSize());
                            trainTargetsAtStep.setToolTipText("Train pred. for targets");
                            graphList.add(trainTargetsAtStep);
                        }
                        if (eval.getTestData() != null && eval.getEvaluateOnTestData()) {
                            int instanceOffset = eval.getPrimeForTestDataWithTestData() ? eval.getPrimeWindowSize() : 0;
                            JPanel testTargetsAtStep = eval.graphPredictionsForTargetsOnTesting(GraphDriver.getDefaultDriver(), this.m_threadForecaster, targets, stepNum, instanceOffset);
                            testTargetsAtStep.setToolTipText("Test pred. for targets");
                            graphList.add(testTargetsAtStep);
                        }
                    }
                    if (ForecastingPanel.this.m_advancedConfigPanel.getGraphTargetForSteps()) {
                        String selectedTarget;
                        fieldsToForecast = this.m_threadForecaster.getFieldsToForecast();
                        if (!fieldsToForecast.contains(selectedTarget = ForecastingPanel.this.m_advancedConfigPanel.getGraphTargetForStepsTarget())) {
                            throw new Exception("Cannot graph predictions for \"" + selectedTarget + "\" because that field is not being predicted.");
                        }
                        List<Integer> stepList = ForecastingPanel.this.m_advancedConfigPanel.getGraphTargetForStepsStepList();
                        if (eval.getTrainingData() != null && eval.getEvaluateOnTrainingData()) {
                            JPanel trainStepsForTarget = eval.graphPredictionsForStepsOnTraining(GraphDriver.getDefaultDriver(), this.m_threadForecaster, selectedTarget, stepList, eval.getPrimeWindowSize());
                            trainStepsForTarget.setToolTipText("Train pred. at steps");
                            graphList.add(trainStepsForTarget);
                        }
                        if (eval.getTestData() != null && eval.getEvaluateOnTestData()) {
                            int instanceOffset = eval.getPrimeForTestDataWithTestData() ? eval.getPrimeWindowSize() : 0;
                            JPanel testStepsForTarget = eval.graphPredictionsForStepsOnTesting(GraphDriver.getDefaultDriver(), this.m_threadForecaster, selectedTarget, stepList, instanceOffset);
                            testStepsForTarget.setToolTipText("Test pred. at steps");
                            graphList.add(testStepsForTarget);
                        }
                    }
                    if (ForecastingPanel.this.m_advancedConfigPanel.getGraphFuturePredictions()) {
                        block73: {
                            if (eval.getTrainingData() != null) {
                                try {
                                    JPanel trainFuture = eval.graphFutureForecastOnTraining(GraphDriver.getDefaultDriver(), this.m_threadForecaster, AbstractForecaster.stringToList(this.m_threadForecaster.getFieldsToForecast()));
                                    trainFuture.setToolTipText("Train future pred.");
                                    graphList.add(trainFuture);
                                }
                                catch (Exception ex) {
                                    if (this.m_threadForecaster instanceof OverlayForecaster && this.m_threadForecaster.isUsingOverlayData()) {
                                        if (ForecastingPanel.this.m_log != null) {
                                            ForecastingPanel.this.m_log.logMessage("Unable to graph future forecast for training data because no future overlay data is available");
                                        }
                                    }
                                    if (ForecastingPanel.this.m_log == null) break block73;
                                    ForecastingPanel.this.m_log.logMessage("Unable to graph future forecast for training data: " + ex.getMessage());
                                }
                            }
                        }
                        if (eval.getTestData() != null && eval.getEvaluateOnTestData()) {
                            try {
                                JPanel testFuture = eval.graphFutureForecastOnTesting(GraphDriver.getDefaultDriver(), this.m_threadForecaster, AbstractForecaster.stringToList(this.m_threadForecaster.getFieldsToForecast()));
                                testFuture.setToolTipText("Test future pred.");
                                graphList.add(testFuture);
                            }
                            catch (Exception ex) {
                                if (this.m_threadForecaster instanceof OverlayForecaster && this.m_threadForecaster.isUsingOverlayData()) {
                                    if (ForecastingPanel.this.m_log != null) {
                                        ForecastingPanel.this.m_log.logMessage("Unable to graph future forecast for test data because no future overlay data is available");
                                    }
                                }
                                if (ForecastingPanel.this.m_log == null) break block74;
                                ForecastingPanel.this.m_log.logMessage("Unable to graph future forecast for test data: " + ex.getMessage());
                            }
                        }
                    }
                }
                try {
                    if (this.m_configAndBuild) {
                        WekaForecaster copiedForecaster = (WekaForecaster)AbstractForecaster.makeCopy(this.m_threadForecaster);
                        resultList.add(copiedForecaster);
                        Instances trainHeader = new Instances(trainInst, 0);
                        resultList.add((Serializable)trainHeader);
                    }
                }
                catch (Exception ex) {
                    if (ForecastingPanel.this.m_log != null) {
                        logger.println("Problem copying model.");
                        ForecastingPanel.this.m_log.logMessage("Problem copying model: " + ex.getMessage());
                    }
                    ex.printStackTrace();
                }
                if (graphList.size() > 0) {
                    resultList.add(graphList);
                }
                ForecastingPanel.this.m_history.addObject(name, resultList);
                if (graphList.size() > 0) {
                    ForecastingPanel.this.updateMainTabs(name);
                }
                if (ForecastingPanel.this.m_log != null) {
                    ForecastingPanel.this.m_log.logMessage("Finished " + fname);
                    logger.println("OK");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ForecastingPanel.this.m_log != null) {
                    ForecastingPanel.this.m_log.logMessage(ex.getMessage());
                    logger.println("Problem evaluating forecaster");
                }
                JOptionPane.showMessageDialog(ForecastingPanel.this, "Problem evaluating forecaster:\n" + ex.getMessage(), "Evaluate forecaster", 0);
            }
            finally {
                if (this.isInterrupted() && ForecastingPanel.this.m_log != null) {
                    ForecastingPanel.this.m_log.logMessage("Interrupted " + fname);
                    logger.println("Interrupted");
                }
                ForecastingThread forecastingThread = this;
                synchronized (forecastingThread) {
                    ForecastingPanel.this.m_startBut.setEnabled(true);
                    ForecastingPanel.this.m_stopBut.setEnabled(false);
                    ForecastingPanel.this.m_runThread = null;
                }
                if (ForecastingPanel.this.m_log instanceof TaskLogger) {
                    ((TaskLogger)ForecastingPanel.this.m_log).taskFinished();
                }
            }
        }
    }
}

