/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ClassLocator;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.logging.ConsoleLoggingObject;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ClassLister
extends ConsoleLoggingObject {
    private static final long serialVersionUID = 8482163084925911272L;
    public static final String FILENAME = "ClassLister.props";
    public static final String BLACKLIST = "ClassLister.blacklist";
    protected Properties m_Packages;
    protected Properties m_Classes;
    protected Hashtable<String, HashSet<String>> m_ClassesCache;
    protected static ClassLister m_Singleton;

    private ClassLister() {
        this.initialize();
    }

    protected void initialize() {
        try {
            this.m_Packages = Environment.getInstance().read("class lister");
            this.m_Classes = new Properties();
            this.m_ClassesCache = new Hashtable();
            Properties blacklist = Environment.getInstance().read("class lister blacklist");
            Enumeration<?> enm = this.m_Packages.propertyNames();
            while (enm.hasMoreElements()) {
                String superclass = (String)enm.nextElement();
                String[] packages = this.m_Packages.getProperty(superclass).replaceAll(" ", "").split(",");
                List<String> classes = ClassLocator.getSingleton().find(superclass, packages);
                if (blacklist.hasKey(superclass)) {
                    try {
                        String[] patterns;
                        for (String pattern : patterns = blacklist.getProperty(superclass).replaceAll(" ", "").split(",")) {
                            Pattern p = Pattern.compile(pattern);
                            int i = 0;
                            while (i < classes.size()) {
                                if (p.matcher(classes.get(i)).matches()) {
                                    classes.remove(i);
                                    continue;
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().log(Level.SEVERE, "Failed to blacklist classes for superclass '" + superclass + "':", ex);
                    }
                }
                this.m_Classes.setProperty(superclass, Utils.flatten(classes, ","));
                this.m_ClassesCache.put(superclass, new HashSet<String>(classes));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to determine packages/classes:", e);
            this.m_Packages = new Properties();
        }
    }

    public String[] getClassnames(Class superclass) {
        return this.getClassnames(superclass.getName());
    }

    public String[] getClassnames(String superclass) {
        String classes = this.m_Classes.getProperty(superclass);
        if (classes == null || classes.length() == 0) {
            return new String[0];
        }
        return classes.split(",");
    }

    public String[] getSuperclasses(Class cls) {
        return this.getSuperclasses(cls.getName());
    }

    public String[] getSuperclasses(String cls) {
        ArrayList<String> result = new ArrayList<String>();
        for (String superclass : this.m_ClassesCache.keySet()) {
            if (!this.m_ClassesCache.get(superclass).contains(cls)) continue;
            result.add(superclass);
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getSuperclasses() {
        ArrayList<String> result = new ArrayList<String>(this.m_ClassesCache.keySet());
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public Properties getClasses() {
        return this.m_Classes;
    }

    public String[] getPackages(Class superclass) {
        return this.getPackages(superclass.getName());
    }

    public String[] getPackages(String superclass) {
        String packages = this.m_Packages.getProperty(superclass);
        if (packages == null || packages.length() == 0) {
            return new String[0];
        }
        return packages.split(",");
    }

    public Properties getPackages() {
        return this.m_Packages;
    }

    public String toString() {
        return this.m_Classes.toString();
    }

    public static synchronized ClassLister getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ClassLister();
        }
        return m_Singleton;
    }

    public static void main(String[] args) throws Exception {
        if (OptionUtils.helpRequested(args)) {
            System.out.println();
            System.out.println("Usage: " + ClassLister.class.getName() + " [-env <classname>] [-super <classname>] [-match <regexp>] [-allow-empty]");
            System.out.println();
            return;
        }
        String env = OptionUtils.getOption(args, "-env");
        if (env == null) {
            env = Environment.class.getName();
        }
        Class<?> cls = Class.forName(env);
        Environment.setEnvironmentClass(cls);
        String match = OptionUtils.getOption(args, "-match");
        if (match == null) {
            match = ".*";
        }
        BaseRegExp regexp = new BaseRegExp(match);
        boolean allowEmpty = OptionUtils.hasFlag(args, "-allow-empty");
        String sclass = OptionUtils.getOption(args, "-super");
        String[] superclasses = sclass == null ? ClassLister.getSingleton().getSuperclasses() : new String[]{sclass};
        for (String superclass : superclasses) {
            cls = Class.forName(superclass);
            String[] classnames = ClassLister.getSingleton().getClassnames(cls);
            if (classnames.length <= 0 && !allowEmpty) continue;
            System.out.println("--> " + superclass);
            for (String classname : classnames) {
                if (!regexp.isMatch(classname)) continue;
                System.out.println(classname);
            }
            System.out.println();
        }
    }
}

