/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;

public class BaseByte
extends BaseObject {
    private static final long serialVersionUID = -3504062141216626521L;
    public static final String DEFAULT = "0";

    public BaseByte() {
        this(DEFAULT);
    }

    public BaseByte(String s) {
        super(s);
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    public BaseByte(Byte value) {
        this(value.toString());
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            Byte.parseByte(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Internal = Byte.valueOf(Byte.parseByte(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = new Byte(0);
        }
    }

    @Override
    public String getValue() {
        return ((Byte)this.m_Internal).toString();
    }

    public byte byteValue() {
        return (Byte)this.m_Internal;
    }

    @Override
    public String getTipText() {
        return "A byte (from -128 to 127).";
    }
}

