/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;
import java.net.URI;

public class BaseURI
extends BaseObject {
    private static final long serialVersionUID = 4461135181234402629L;
    public static final String DEFAULT_URI = "http://localhost";
    protected URI m_Current;

    public BaseURI() {
        this(DEFAULT_URI);
    }

    public BaseURI(String s) {
        super(s);
    }

    public BaseURI(URI value) {
        this(value.toString());
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT_URI;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            new URI(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Current = new URI(value);
            this.m_Internal = value;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = DEFAULT_URI;
            try {
                this.m_Current = new URI(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public URI uriValue() {
        return this.m_Current;
    }

    @Override
    public String getTipText() {
        return "An URI (uniform resource identifier).";
    }
}

